/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AcceptTermsOfServiceRequest
 */
@JsonPropertyOrder({
  AcceptTermsOfServiceRequest.JSON_PROPERTY_ACCEPTED_BY,
  AcceptTermsOfServiceRequest.JSON_PROPERTY_IP_ADDRESS
})

public class AcceptTermsOfServiceRequest {
  public static final String JSON_PROPERTY_ACCEPTED_BY = "acceptedBy";
  private String acceptedBy;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public AcceptTermsOfServiceRequest() { 
  }

  /**
   * The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   *
   * @param acceptedBy The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   * @return the current {@code AcceptTermsOfServiceRequest} instance, allowing for method chaining
   */
  public AcceptTermsOfServiceRequest acceptedBy(String acceptedBy) {
    this.acceptedBy = acceptedBy;
    return this;
  }

  /**
   * The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   * @return acceptedBy The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcceptedBy() {
    return acceptedBy;
  }

  /**
   * The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   *
   * @param acceptedBy The legal entity ID of the user accepting the Terms of Service.  For organizations, this must be the individual legal entity ID of an authorized signatory for the organization.  For sole proprietorships, this must be the individual legal entity ID of the owner.  For individuals, this must be the individual legal entity id of either the individual, parent, or guardian.  
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcceptedBy(String acceptedBy) {
    this.acceptedBy = acceptedBy;
  }

  /**
   * The IP address of the user accepting the Terms of Service.
   *
   * @param ipAddress The IP address of the user accepting the Terms of Service.
   * @return the current {@code AcceptTermsOfServiceRequest} instance, allowing for method chaining
   */
  public AcceptTermsOfServiceRequest ipAddress(String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * The IP address of the user accepting the Terms of Service.
   * @return ipAddress The IP address of the user accepting the Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIpAddress() {
    return ipAddress;
  }

  /**
   * The IP address of the user accepting the Terms of Service.
   *
   * @param ipAddress The IP address of the user accepting the Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }

  /**
   * Return true if this AcceptTermsOfServiceRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcceptTermsOfServiceRequest acceptTermsOfServiceRequest = (AcceptTermsOfServiceRequest) o;
    return Objects.equals(this.acceptedBy, acceptTermsOfServiceRequest.acceptedBy) &&
        Objects.equals(this.ipAddress, acceptTermsOfServiceRequest.ipAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acceptedBy, ipAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcceptTermsOfServiceRequest {\n");
    sb.append("    acceptedBy: ").append(toIndentedString(acceptedBy)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AcceptTermsOfServiceRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AcceptTermsOfServiceRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to AcceptTermsOfServiceRequest
   */
  public static AcceptTermsOfServiceRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AcceptTermsOfServiceRequest.class);
  }
/**
  * Convert an instance of AcceptTermsOfServiceRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
