/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CalculatePciStatusRequest
 */
@JsonPropertyOrder({
  CalculatePciStatusRequest.JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS
})

public class CalculatePciStatusRequest {
  /**
   * Gets or Sets additionalSalesChannels
   */
  public enum AdditionalSalesChannelsEnum {
    ECOMMERCE(String.valueOf("eCommerce")),
    
    ECOMMOTO(String.valueOf("ecomMoto")),
    
    POS(String.valueOf("pos")),
    
    POSMOTO(String.valueOf("posMoto"));

    private String value;

    AdditionalSalesChannelsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdditionalSalesChannelsEnum fromValue(String value) {
      for (AdditionalSalesChannelsEnum b : AdditionalSalesChannelsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS = "additionalSalesChannels";
  private List<AdditionalSalesChannelsEnum> additionalSalesChannels;

  public CalculatePciStatusRequest() { 
  }

  /**
   * An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   *
   * @param additionalSalesChannels An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   * @return the current {@code CalculatePciStatusRequest} instance, allowing for method chaining
   */
  public CalculatePciStatusRequest additionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
    this.additionalSalesChannels = additionalSalesChannels;
    return this;
  }

  public CalculatePciStatusRequest addAdditionalSalesChannelsItem(AdditionalSalesChannelsEnum additionalSalesChannelsItem) {
    if (this.additionalSalesChannels == null) {
      this.additionalSalesChannels = new ArrayList<>();
    }
    this.additionalSalesChannels.add(additionalSalesChannelsItem);
    return this;
  }

  /**
   * An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   * @return additionalSalesChannels An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<AdditionalSalesChannelsEnum> getAdditionalSalesChannels() {
    return additionalSalesChannels;
  }

  /**
   * An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   *
   * @param additionalSalesChannels An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
    this.additionalSalesChannels = additionalSalesChannels;
  }

  /**
   * Return true if this CalculatePciStatusRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CalculatePciStatusRequest calculatePciStatusRequest = (CalculatePciStatusRequest) o;
    return Objects.equals(this.additionalSalesChannels, calculatePciStatusRequest.additionalSalesChannels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalSalesChannels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CalculatePciStatusRequest {\n");
    sb.append("    additionalSalesChannels: ").append(toIndentedString(additionalSalesChannels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CalculatePciStatusRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CalculatePciStatusRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to CalculatePciStatusRequest
   */
  public static CalculatePciStatusRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CalculatePciStatusRequest.class);
  }
/**
  * Convert an instance of CalculatePciStatusRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
