/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.legalentitymanagement.DocumentPage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DocumentReference
 */
@JsonPropertyOrder({
  DocumentReference.JSON_PROPERTY_ACTIVE,
  DocumentReference.JSON_PROPERTY_DESCRIPTION,
  DocumentReference.JSON_PROPERTY_FILE_NAME,
  DocumentReference.JSON_PROPERTY_ID,
  DocumentReference.JSON_PROPERTY_MODIFICATION_DATE,
  DocumentReference.JSON_PROPERTY_PAGES,
  DocumentReference.JSON_PROPERTY_TYPE
})

public class DocumentReference {
  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
  private OffsetDateTime modificationDate;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private List<DocumentPage> pages;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public DocumentReference() { 
  }

  /**
   * Identifies whether the document is active and used for checks.
   *
   * @param active Identifies whether the document is active and used for checks.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Identifies whether the document is active and used for checks.
   * @return active Identifies whether the document is active and used for checks.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getActive() {
    return active;
  }

  /**
   * Identifies whether the document is active and used for checks.
   *
   * @param active Identifies whether the document is active and used for checks.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * Your description for the document.
   *
   * @param description Your description for the document.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Your description for the document.
   * @return description Your description for the document.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Your description for the document.
   *
   * @param description Your description for the document.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Document name.
   *
   * @param fileName Document name.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference fileName(String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * Document name.
   * @return fileName Document name.
   */
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFileName() {
    return fileName;
  }

  /**
   * Document name.
   *
   * @param fileName Document name.
   */
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  /**
   * The unique identifier of the resource.
   *
   * @param id The unique identifier of the resource.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the resource.
   * @return id The unique identifier of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the resource.
   *
   * @param id The unique identifier of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The modification date of the document.
   *
   * @param modificationDate The modification date of the document.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference modificationDate(OffsetDateTime modificationDate) {
    this.modificationDate = modificationDate;
    return this;
  }

  /**
   * The modification date of the document.
   * @return modificationDate The modification date of the document.
   */
  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getModificationDate() {
    return modificationDate;
  }

  /**
   * The modification date of the document.
   *
   * @param modificationDate The modification date of the document.
   */
  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationDate(OffsetDateTime modificationDate) {
    this.modificationDate = modificationDate;
  }

  /**
   * List of document pages
   *
   * @param pages List of document pages
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference pages(List<DocumentPage> pages) {
    this.pages = pages;
    return this;
  }

  public DocumentReference addPagesItem(DocumentPage pagesItem) {
    if (this.pages == null) {
      this.pages = new ArrayList<>();
    }
    this.pages.add(pagesItem);
    return this;
  }

  /**
   * List of document pages
   * @return pages List of document pages
   */
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<DocumentPage> getPages() {
    return pages;
  }

  /**
   * List of document pages
   *
   * @param pages List of document pages
   */
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(List<DocumentPage> pages) {
    this.pages = pages;
  }

  /**
   * Type of document, used when providing an ID number or uploading a document.
   *
   * @param type Type of document, used when providing an ID number or uploading a document.
   * @return the current {@code DocumentReference} instance, allowing for method chaining
   */
  public DocumentReference type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Type of document, used when providing an ID number or uploading a document.
   * @return type Type of document, used when providing an ID number or uploading a document.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * Type of document, used when providing an ID number or uploading a document.
   *
   * @param type Type of document, used when providing an ID number or uploading a document.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Return true if this DocumentReference object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentReference documentReference = (DocumentReference) o;
    return Objects.equals(this.active, documentReference.active) &&
        Objects.equals(this.description, documentReference.description) &&
        Objects.equals(this.fileName, documentReference.fileName) &&
        Objects.equals(this.id, documentReference.id) &&
        Objects.equals(this.modificationDate, documentReference.modificationDate) &&
        Objects.equals(this.pages, documentReference.pages) &&
        Objects.equals(this.type, documentReference.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, description, fileName, id, modificationDate, pages, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentReference {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    modificationDate: ").append(toIndentedString(modificationDate)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DocumentReference given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DocumentReference
   * @throws JsonProcessingException if the JSON string is invalid with respect to DocumentReference
   */
  public static DocumentReference fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DocumentReference.class);
  }
/**
  * Convert an instance of DocumentReference to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
