/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PhoneNumber
 */
@JsonPropertyOrder({
  PhoneNumber.JSON_PROPERTY_NUMBER,
  PhoneNumber.JSON_PROPERTY_PHONE_COUNTRY_CODE,
  PhoneNumber.JSON_PROPERTY_TYPE
})

public class PhoneNumber {
  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_PHONE_COUNTRY_CODE = "phoneCountryCode";
  private String phoneCountryCode;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public PhoneNumber() { 
  }

  @JsonCreator
  public PhoneNumber(
    @JsonProperty(JSON_PROPERTY_PHONE_COUNTRY_CODE) String phoneCountryCode
  ) {
    this();
    this.phoneCountryCode = phoneCountryCode;
  }

  /**
   * The full phone number, including the country code. For example, **+3112345678**.
   *
   * @param number The full phone number, including the country code. For example, **+3112345678**.
   * @return the current {@code PhoneNumber} instance, allowing for method chaining
   */
  public PhoneNumber number(String number) {
    this.number = number;
    return this;
  }

  /**
   * The full phone number, including the country code. For example, **+3112345678**.
   * @return number The full phone number, including the country code. For example, **+3112345678**.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNumber() {
    return number;
  }

  /**
   * The full phone number, including the country code. For example, **+3112345678**.
   *
   * @param number The full phone number, including the country code. For example, **+3112345678**.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }

  /**
   * The two-letter [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code prefix of the phone number. For example, **US** or **NL**.  The value of the &#x60;phoneCountryCode&#x60; is determined by the country code digit(s) of &#x60;phone.number&#x60;
   * @return phoneCountryCode The two-letter [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code prefix of the phone number. For example, **US** or **NL**.  The value of the &#x60;phoneCountryCode&#x60; is determined by the country code digit(s) of &#x60;phone.number&#x60;
   */
  @JsonProperty(JSON_PROPERTY_PHONE_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneCountryCode() {
    return phoneCountryCode;
  }


  /**
   * The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   *
   * @param type The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   * @return the current {@code PhoneNumber} instance, allowing for method chaining
   */
  public PhoneNumber type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   * @return type The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   *
   * @param type The type of phone number.  Possible values: **mobile**, **landline**, **sip**, **fax.** 
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Return true if this PhoneNumber object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PhoneNumber phoneNumber = (PhoneNumber) o;
    return Objects.equals(this.number, phoneNumber.number) &&
        Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) &&
        Objects.equals(this.type, phoneNumber.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, phoneCountryCode, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PhoneNumber {\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    phoneCountryCode: ").append(toIndentedString(phoneCountryCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PhoneNumber given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PhoneNumber
   * @throws JsonProcessingException if the JSON string is invalid with respect to PhoneNumber
   */
  public static PhoneNumber fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PhoneNumber.class);
  }
/**
  * Convert an instance of PhoneNumber to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
