/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AndroidAppError
 */
@JsonPropertyOrder({
  AndroidAppError.JSON_PROPERTY_ERROR_CODE,
  AndroidAppError.JSON_PROPERTY_TERMINAL_MODELS
})

public class AndroidAppError {
  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  private String errorCode;

  public static final String JSON_PROPERTY_TERMINAL_MODELS = "terminalModels";
  private List<String> terminalModels;

  public AndroidAppError() { 
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   *
   * @param errorCode The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   * @return the current {@code AndroidAppError} instance, allowing for method chaining
   */
  public AndroidAppError errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   * @return errorCode The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   */
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   *
   * @param errorCode The error code of the Android app with the &#x60;status&#x60; of either **error** or **invalid**.
   */
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  /**
   * The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   *
   * @param terminalModels The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   * @return the current {@code AndroidAppError} instance, allowing for method chaining
   */
  public AndroidAppError terminalModels(List<String> terminalModels) {
    this.terminalModels = terminalModels;
    return this;
  }

  public AndroidAppError addTerminalModelsItem(String terminalModelsItem) {
    if (this.terminalModels == null) {
      this.terminalModels = new ArrayList<>();
    }
    this.terminalModels.add(terminalModelsItem);
    return this;
  }

  /**
   * The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   * @return terminalModels The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getTerminalModels() {
    return terminalModels;
  }

  /**
   * The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   *
   * @param terminalModels The list of payment terminal models to which the returned &#x60;errorCode&#x60; applies.
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminalModels(List<String> terminalModels) {
    this.terminalModels = terminalModels;
  }

  /**
   * Return true if this AndroidAppError object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AndroidAppError androidAppError = (AndroidAppError) o;
    return Objects.equals(this.errorCode, androidAppError.errorCode) &&
        Objects.equals(this.terminalModels, androidAppError.terminalModels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, terminalModels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AndroidAppError {\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    terminalModels: ").append(toIndentedString(terminalModels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AndroidAppError given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AndroidAppError
   * @throws JsonProcessingException if the JSON string is invalid with respect to AndroidAppError
   */
  public static AndroidAppError fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AndroidAppError.class);
  }
/**
  * Convert an instance of AndroidAppError to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
