/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Gratuity
 */
@JsonPropertyOrder({
  Gratuity.JSON_PROPERTY_ALLOW_CUSTOM_AMOUNT,
  Gratuity.JSON_PROPERTY_CURRENCY,
  Gratuity.JSON_PROPERTY_PREDEFINED_TIP_ENTRIES,
  Gratuity.JSON_PROPERTY_USE_PREDEFINED_TIP_ENTRIES
})

public class Gratuity {
  public static final String JSON_PROPERTY_ALLOW_CUSTOM_AMOUNT = "allowCustomAmount";
  private Boolean allowCustomAmount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_PREDEFINED_TIP_ENTRIES = "predefinedTipEntries";
  private List<String> predefinedTipEntries;

  public static final String JSON_PROPERTY_USE_PREDEFINED_TIP_ENTRIES = "usePredefinedTipEntries";
  private Boolean usePredefinedTipEntries;

  public Gratuity() { 
  }

  /**
   * Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   *
   * @param allowCustomAmount Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   * @return the current {@code Gratuity} instance, allowing for method chaining
   */
  public Gratuity allowCustomAmount(Boolean allowCustomAmount) {
    this.allowCustomAmount = allowCustomAmount;
    return this;
  }

  /**
   * Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   * @return allowCustomAmount Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_CUSTOM_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowCustomAmount() {
    return allowCustomAmount;
  }

  /**
   * Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   *
   * @param allowCustomAmount Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_CUSTOM_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowCustomAmount(Boolean allowCustomAmount) {
    this.allowCustomAmount = allowCustomAmount;
  }

  /**
   * The currency that the tipping settings apply to.
   *
   * @param currency The currency that the tipping settings apply to.
   * @return the current {@code Gratuity} instance, allowing for method chaining
   */
  public Gratuity currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The currency that the tipping settings apply to.
   * @return currency The currency that the tipping settings apply to.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * The currency that the tipping settings apply to.
   *
   * @param currency The currency that the tipping settings apply to.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   *
   * @param predefinedTipEntries Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   * @return the current {@code Gratuity} instance, allowing for method chaining
   */
  public Gratuity predefinedTipEntries(List<String> predefinedTipEntries) {
    this.predefinedTipEntries = predefinedTipEntries;
    return this;
  }

  public Gratuity addPredefinedTipEntriesItem(String predefinedTipEntriesItem) {
    if (this.predefinedTipEntries == null) {
      this.predefinedTipEntries = new ArrayList<>();
    }
    this.predefinedTipEntries.add(predefinedTipEntriesItem);
    return this;
  }

  /**
   * Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   * @return predefinedTipEntries Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   */
  @JsonProperty(JSON_PROPERTY_PREDEFINED_TIP_ENTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getPredefinedTipEntries() {
    return predefinedTipEntries;
  }

  /**
   * Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   *
   * @param predefinedTipEntries Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   */
  @JsonProperty(JSON_PROPERTY_PREDEFINED_TIP_ENTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPredefinedTipEntries(List<String> predefinedTipEntries) {
    this.predefinedTipEntries = predefinedTipEntries;
  }

  /**
   * Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   *
   * @param usePredefinedTipEntries Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   * @return the current {@code Gratuity} instance, allowing for method chaining
   */
  public Gratuity usePredefinedTipEntries(Boolean usePredefinedTipEntries) {
    this.usePredefinedTipEntries = usePredefinedTipEntries;
    return this;
  }

  /**
   * Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   * @return usePredefinedTipEntries Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   */
  @JsonProperty(JSON_PROPERTY_USE_PREDEFINED_TIP_ENTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getUsePredefinedTipEntries() {
    return usePredefinedTipEntries;
  }

  /**
   * Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   *
   * @param usePredefinedTipEntries Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   */
  @JsonProperty(JSON_PROPERTY_USE_PREDEFINED_TIP_ENTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsePredefinedTipEntries(Boolean usePredefinedTipEntries) {
    this.usePredefinedTipEntries = usePredefinedTipEntries;
  }

  /**
   * Return true if this Gratuity object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Gratuity gratuity = (Gratuity) o;
    return Objects.equals(this.allowCustomAmount, gratuity.allowCustomAmount) &&
        Objects.equals(this.currency, gratuity.currency) &&
        Objects.equals(this.predefinedTipEntries, gratuity.predefinedTipEntries) &&
        Objects.equals(this.usePredefinedTipEntries, gratuity.usePredefinedTipEntries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowCustomAmount, currency, predefinedTipEntries, usePredefinedTipEntries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Gratuity {\n");
    sb.append("    allowCustomAmount: ").append(toIndentedString(allowCustomAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    predefinedTipEntries: ").append(toIndentedString(predefinedTipEntries)).append("\n");
    sb.append("    usePredefinedTipEntries: ").append(toIndentedString(usePredefinedTipEntries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Gratuity given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Gratuity
   * @throws JsonProcessingException if the JSON string is invalid with respect to Gratuity
   */
  public static Gratuity fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Gratuity.class);
  }
/**
  * Convert an instance of Gratuity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
