/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PayPalInfo
 */
@JsonPropertyOrder({
  PayPalInfo.JSON_PROPERTY_DIRECT_CAPTURE,
  PayPalInfo.JSON_PROPERTY_PAYER_ID,
  PayPalInfo.JSON_PROPERTY_SUBJECT
})

public class PayPalInfo {
  public static final String JSON_PROPERTY_DIRECT_CAPTURE = "directCapture";
  private Boolean directCapture;

  public static final String JSON_PROPERTY_PAYER_ID = "payerId";
  private String payerId;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject;

  public PayPalInfo() { 
  }

  /**
   * Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   *
   * @param directCapture Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   * @return the current {@code PayPalInfo} instance, allowing for method chaining
   */
  public PayPalInfo directCapture(Boolean directCapture) {
    this.directCapture = directCapture;
    return this;
  }

  /**
   * Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   * @return directCapture Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   */
  @JsonProperty(JSON_PROPERTY_DIRECT_CAPTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDirectCapture() {
    return directCapture;
  }

  /**
   * Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   *
   * @param directCapture Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.
   */
  @JsonProperty(JSON_PROPERTY_DIRECT_CAPTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDirectCapture(Boolean directCapture) {
    this.directCapture = directCapture;
  }

  /**
   * PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   *
   * @param payerId PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   * @return the current {@code PayPalInfo} instance, allowing for method chaining
   */
  public PayPalInfo payerId(String payerId) {
    this.payerId = payerId;
    return this;
  }

  /**
   * PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   * @return payerId PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   */
  @JsonProperty(JSON_PROPERTY_PAYER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayerId() {
    return payerId;
  }

  /**
   * PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   *
   * @param payerId PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.
   */
  @JsonProperty(JSON_PROPERTY_PAYER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayerId(String payerId) {
    this.payerId = payerId;
  }

  /**
   * Your business email address.
   *
   * @param subject Your business email address.
   * @return the current {@code PayPalInfo} instance, allowing for method chaining
   */
  public PayPalInfo subject(String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * Your business email address.
   * @return subject Your business email address.
   */
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSubject() {
    return subject;
  }

  /**
   * Your business email address.
   *
   * @param subject Your business email address.
   */
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }

  /**
   * Return true if this PayPalInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayPalInfo payPalInfo = (PayPalInfo) o;
    return Objects.equals(this.directCapture, payPalInfo.directCapture) &&
        Objects.equals(this.payerId, payPalInfo.payerId) &&
        Objects.equals(this.subject, payPalInfo.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(directCapture, payerId, subject);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayPalInfo {\n");
    sb.append("    directCapture: ").append(toIndentedString(directCapture)).append("\n");
    sb.append("    payerId: ").append(toIndentedString(payerId)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PayPalInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayPalInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to PayPalInfo
   */
  public static PayPalInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayPalInfo.class);
  }
/**
  * Convert an instance of PayPalInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
