/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * RequestActivationResponse
 */
@JsonPropertyOrder({
  RequestActivationResponse.JSON_PROPERTY_COMPANY_ID,
  RequestActivationResponse.JSON_PROPERTY_MERCHANT_ID
})

public class RequestActivationResponse {
  public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
  private String companyId;

  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public RequestActivationResponse() { 
  }

  /**
   * The unique identifier of the company account.
   *
   * @param companyId The unique identifier of the company account.
   * @return the current {@code RequestActivationResponse} instance, allowing for method chaining
   */
  public RequestActivationResponse companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

  /**
   * The unique identifier of the company account.
   * @return companyId The unique identifier of the company account.
   */
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCompanyId() {
    return companyId;
  }

  /**
   * The unique identifier of the company account.
   *
   * @param companyId The unique identifier of the company account.
   */
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  /**
   * The unique identifier of the merchant account you requested to activate.
   *
   * @param merchantId The unique identifier of the merchant account you requested to activate.
   * @return the current {@code RequestActivationResponse} instance, allowing for method chaining
   */
  public RequestActivationResponse merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The unique identifier of the merchant account you requested to activate.
   * @return merchantId The unique identifier of the merchant account you requested to activate.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantId() {
    return merchantId;
  }

  /**
   * The unique identifier of the merchant account you requested to activate.
   *
   * @param merchantId The unique identifier of the merchant account you requested to activate.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }

  /**
   * Return true if this RequestActivationResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestActivationResponse requestActivationResponse = (RequestActivationResponse) o;
    return Objects.equals(this.companyId, requestActivationResponse.companyId) &&
        Objects.equals(this.merchantId, requestActivationResponse.merchantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, merchantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestActivationResponse {\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of RequestActivationResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RequestActivationResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to RequestActivationResponse
   */
  public static RequestActivationResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RequestActivationResponse.class);
  }
/**
  * Convert an instance of RequestActivationResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
