/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.Address;
import com.adyen.model.management.Contact;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ShippingLocation
 */
@JsonPropertyOrder({
  ShippingLocation.JSON_PROPERTY_ADDRESS,
  ShippingLocation.JSON_PROPERTY_CONTACT,
  ShippingLocation.JSON_PROPERTY_ID,
  ShippingLocation.JSON_PROPERTY_NAME
})

public class ShippingLocation {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private Contact contact;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public ShippingLocation() { 
  }

  /**
   * address
   *
   * @param address 
   * @return the current {@code ShippingLocation} instance, allowing for method chaining
   */
  public ShippingLocation address(Address address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   * @return address 
   */
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getAddress() {
    return address;
  }

  /**
   * address
   *
   * @param address 
   */
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }

  /**
   * contact
   *
   * @param contact 
   * @return the current {@code ShippingLocation} instance, allowing for method chaining
   */
  public ShippingLocation contact(Contact contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Get contact
   * @return contact 
   */
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Contact getContact() {
    return contact;
  }

  /**
   * contact
   *
   * @param contact 
   */
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(Contact contact) {
    this.contact = contact;
  }

  /**
   * The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   *
   * @param id The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   * @return the current {@code ShippingLocation} instance, allowing for method chaining
   */
  public ShippingLocation id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   * @return id The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   *
   * @param id The unique identifier of the shipping location, for use as &#x60;shippingLocationId&#x60; when creating an order.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The unique name of the shipping location.
   *
   * @param name The unique name of the shipping location.
   * @return the current {@code ShippingLocation} instance, allowing for method chaining
   */
  public ShippingLocation name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The unique name of the shipping location.
   * @return name The unique name of the shipping location.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The unique name of the shipping location.
   *
   * @param name The unique name of the shipping location.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Return true if this ShippingLocation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShippingLocation shippingLocation = (ShippingLocation) o;
    return Objects.equals(this.address, shippingLocation.address) &&
        Objects.equals(this.contact, shippingLocation.contact) &&
        Objects.equals(this.id, shippingLocation.id) &&
        Objects.equals(this.name, shippingLocation.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, contact, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShippingLocation {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ShippingLocation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ShippingLocation
   * @throws JsonProcessingException if the JSON string is invalid with respect to ShippingLocation
   */
  public static ShippingLocation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ShippingLocation.class);
  }
/**
  * Convert an instance of ShippingLocation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
