/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.TerminalAssignment;
import com.adyen.model.management.TerminalConnectivity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Terminal
 */
@JsonPropertyOrder({
  Terminal.JSON_PROPERTY_ASSIGNMENT,
  Terminal.JSON_PROPERTY_CONNECTIVITY,
  Terminal.JSON_PROPERTY_FIRMWARE_VERSION,
  Terminal.JSON_PROPERTY_ID,
  Terminal.JSON_PROPERTY_LAST_ACTIVITY_AT,
  Terminal.JSON_PROPERTY_LAST_TRANSACTION_AT,
  Terminal.JSON_PROPERTY_MODEL,
  Terminal.JSON_PROPERTY_RESTART_LOCAL_TIME,
  Terminal.JSON_PROPERTY_SERIAL_NUMBER
})

public class Terminal {
  public static final String JSON_PROPERTY_ASSIGNMENT = "assignment";
  private TerminalAssignment assignment;

  public static final String JSON_PROPERTY_CONNECTIVITY = "connectivity";
  private TerminalConnectivity connectivity;

  public static final String JSON_PROPERTY_FIRMWARE_VERSION = "firmwareVersion";
  private String firmwareVersion;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LAST_ACTIVITY_AT = "lastActivityAt";
  private OffsetDateTime lastActivityAt;

  public static final String JSON_PROPERTY_LAST_TRANSACTION_AT = "lastTransactionAt";
  private OffsetDateTime lastTransactionAt;

  public static final String JSON_PROPERTY_MODEL = "model";
  private String model;

  public static final String JSON_PROPERTY_RESTART_LOCAL_TIME = "restartLocalTime";
  private String restartLocalTime;

  public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
  private String serialNumber;

  public Terminal() { 
  }

  /**
   * assignment
   *
   * @param assignment 
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal assignment(TerminalAssignment assignment) {
    this.assignment = assignment;
    return this;
  }

  /**
   * Get assignment
   * @return assignment 
   */
  @JsonProperty(JSON_PROPERTY_ASSIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TerminalAssignment getAssignment() {
    return assignment;
  }

  /**
   * assignment
   *
   * @param assignment 
   */
  @JsonProperty(JSON_PROPERTY_ASSIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignment(TerminalAssignment assignment) {
    this.assignment = assignment;
  }

  /**
   * connectivity
   *
   * @param connectivity 
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal connectivity(TerminalConnectivity connectivity) {
    this.connectivity = connectivity;
    return this;
  }

  /**
   * Get connectivity
   * @return connectivity 
   */
  @JsonProperty(JSON_PROPERTY_CONNECTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TerminalConnectivity getConnectivity() {
    return connectivity;
  }

  /**
   * connectivity
   *
   * @param connectivity 
   */
  @JsonProperty(JSON_PROPERTY_CONNECTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConnectivity(TerminalConnectivity connectivity) {
    this.connectivity = connectivity;
  }

  /**
   * The software release currently in use on the terminal.
   *
   * @param firmwareVersion The software release currently in use on the terminal.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal firmwareVersion(String firmwareVersion) {
    this.firmwareVersion = firmwareVersion;
    return this;
  }

  /**
   * The software release currently in use on the terminal.
   * @return firmwareVersion The software release currently in use on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_FIRMWARE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFirmwareVersion() {
    return firmwareVersion;
  }

  /**
   * The software release currently in use on the terminal.
   *
   * @param firmwareVersion The software release currently in use on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_FIRMWARE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirmwareVersion(String firmwareVersion) {
    this.firmwareVersion = firmwareVersion;
  }

  /**
   * The unique identifier of the terminal.
   *
   * @param id The unique identifier of the terminal.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the terminal.
   * @return id The unique identifier of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the terminal.
   *
   * @param id The unique identifier of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   *
   * @param lastActivityAt Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal lastActivityAt(OffsetDateTime lastActivityAt) {
    this.lastActivityAt = lastActivityAt;
    return this;
  }

  /**
   * Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   * @return lastActivityAt Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   */
  @JsonProperty(JSON_PROPERTY_LAST_ACTIVITY_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLastActivityAt() {
    return lastActivityAt;
  }

  /**
   * Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   *
   * @param lastActivityAt Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   */
  @JsonProperty(JSON_PROPERTY_LAST_ACTIVITY_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastActivityAt(OffsetDateTime lastActivityAt) {
    this.lastActivityAt = lastActivityAt;
  }

  /**
   * Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   *
   * @param lastTransactionAt Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal lastTransactionAt(OffsetDateTime lastTransactionAt) {
    this.lastTransactionAt = lastTransactionAt;
    return this;
  }

  /**
   * Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   * @return lastTransactionAt Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   */
  @JsonProperty(JSON_PROPERTY_LAST_TRANSACTION_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLastTransactionAt() {
    return lastTransactionAt;
  }

  /**
   * Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   *
   * @param lastTransactionAt Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   */
  @JsonProperty(JSON_PROPERTY_LAST_TRANSACTION_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastTransactionAt(OffsetDateTime lastTransactionAt) {
    this.lastTransactionAt = lastTransactionAt;
  }

  /**
   * The model name of the terminal.
   *
   * @param model The model name of the terminal.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal model(String model) {
    this.model = model;
    return this;
  }

  /**
   * The model name of the terminal.
   * @return model The model name of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getModel() {
    return model;
  }

  /**
   * The model name of the terminal.
   *
   * @param model The model name of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModel(String model) {
    this.model = model;
  }

  /**
   * The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   *
   * @param restartLocalTime The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal restartLocalTime(String restartLocalTime) {
    this.restartLocalTime = restartLocalTime;
    return this;
  }

  /**
   * The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   * @return restartLocalTime The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   */
  @JsonProperty(JSON_PROPERTY_RESTART_LOCAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRestartLocalTime() {
    return restartLocalTime;
  }

  /**
   * The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   *
   * @param restartLocalTime The exact time of the terminal reboot, in the timezone of the terminal in **HH:mm** format.
   */
  @JsonProperty(JSON_PROPERTY_RESTART_LOCAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestartLocalTime(String restartLocalTime) {
    this.restartLocalTime = restartLocalTime;
  }

  /**
   * The serial number of the terminal.
   *
   * @param serialNumber The serial number of the terminal.
   * @return the current {@code Terminal} instance, allowing for method chaining
   */
  public Terminal serialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

  /**
   * The serial number of the terminal.
   * @return serialNumber The serial number of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_SERIAL_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSerialNumber() {
    return serialNumber;
  }

  /**
   * The serial number of the terminal.
   *
   * @param serialNumber The serial number of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_SERIAL_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSerialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
  }

  /**
   * Return true if this Terminal object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Terminal terminal = (Terminal) o;
    return Objects.equals(this.assignment, terminal.assignment) &&
        Objects.equals(this.connectivity, terminal.connectivity) &&
        Objects.equals(this.firmwareVersion, terminal.firmwareVersion) &&
        Objects.equals(this.id, terminal.id) &&
        Objects.equals(this.lastActivityAt, terminal.lastActivityAt) &&
        Objects.equals(this.lastTransactionAt, terminal.lastTransactionAt) &&
        Objects.equals(this.model, terminal.model) &&
        Objects.equals(this.restartLocalTime, terminal.restartLocalTime) &&
        Objects.equals(this.serialNumber, terminal.serialNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignment, connectivity, firmwareVersion, id, lastActivityAt, lastTransactionAt, model, restartLocalTime, serialNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Terminal {\n");
    sb.append("    assignment: ").append(toIndentedString(assignment)).append("\n");
    sb.append("    connectivity: ").append(toIndentedString(connectivity)).append("\n");
    sb.append("    firmwareVersion: ").append(toIndentedString(firmwareVersion)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lastActivityAt: ").append(toIndentedString(lastActivityAt)).append("\n");
    sb.append("    lastTransactionAt: ").append(toIndentedString(lastTransactionAt)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    restartLocalTime: ").append(toIndentedString(restartLocalTime)).append("\n");
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Terminal given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Terminal
   * @throws JsonProcessingException if the JSON string is invalid with respect to Terminal
   */
  public static Terminal fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Terminal.class);
  }
/**
  * Convert an instance of Terminal to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
