/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalConnectivityCellular
 */
@JsonPropertyOrder({
  TerminalConnectivityCellular.JSON_PROPERTY_ICCID,
  TerminalConnectivityCellular.JSON_PROPERTY_ICCID2,
  TerminalConnectivityCellular.JSON_PROPERTY_STATUS
})

public class TerminalConnectivityCellular {
  public static final String JSON_PROPERTY_ICCID = "iccid";
  private String iccid;

  public static final String JSON_PROPERTY_ICCID2 = "iccid2";
  private String iccid2;

  /**
   * On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   */
  public enum StatusEnum {
    ACTIVATED(String.valueOf("activated")),
    
    DEACTIVATED(String.valueOf("deactivated")),
    
    DEPRECATED(String.valueOf("deprecated")),
    
    INVENTORY(String.valueOf("inventory")),
    
    READYFORACTIVATION(String.valueOf("readyForActivation"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public TerminalConnectivityCellular() { 
  }

  /**
   * The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   *
   * @param iccid The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   * @return the current {@code TerminalConnectivityCellular} instance, allowing for method chaining
   */
  public TerminalConnectivityCellular iccid(String iccid) {
    this.iccid = iccid;
    return this;
  }

  /**
   * The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   * @return iccid The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   */
  @JsonProperty(JSON_PROPERTY_ICCID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIccid() {
    return iccid;
  }

  /**
   * The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   *
   * @param iccid The integrated circuit card identifier (ICCID) of the primary SIM card in the terminal.
   */
  @JsonProperty(JSON_PROPERTY_ICCID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIccid(String iccid) {
    this.iccid = iccid;
  }

  /**
   * The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   *
   * @param iccid2 The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   * @return the current {@code TerminalConnectivityCellular} instance, allowing for method chaining
   */
  public TerminalConnectivityCellular iccid2(String iccid2) {
    this.iccid2 = iccid2;
    return this;
  }

  /**
   * The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   * @return iccid2 The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   */
  @JsonProperty(JSON_PROPERTY_ICCID2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIccid2() {
    return iccid2;
  }

  /**
   * The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   *
   * @param iccid2 The integrated circuit card identifier (ICCID) of the secondary SIM card in the terminal, typically used for a [third-party SIM card](https://docs.adyen.com/point-of-sale/design-your-integration/network-and-connectivity/cellular-failover/#using-a-third-party-sim-card).
   */
  @JsonProperty(JSON_PROPERTY_ICCID2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIccid2(String iccid2) {
    this.iccid2 = iccid2;
  }

  /**
   * On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   *
   * @param status On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   * @return the current {@code TerminalConnectivityCellular} instance, allowing for method chaining
   */
  public TerminalConnectivityCellular status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   * @return status On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   *
   * @param status On a terminal that supports 3G or 4G connectivity, indicates the status of the primary SIM card in the terminal.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * Return true if this TerminalConnectivityCellular object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalConnectivityCellular terminalConnectivityCellular = (TerminalConnectivityCellular) o;
    return Objects.equals(this.iccid, terminalConnectivityCellular.iccid) &&
        Objects.equals(this.iccid2, terminalConnectivityCellular.iccid2) &&
        Objects.equals(this.status, terminalConnectivityCellular.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(iccid, iccid2, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalConnectivityCellular {\n");
    sb.append("    iccid: ").append(toIndentedString(iccid)).append("\n");
    sb.append("    iccid2: ").append(toIndentedString(iccid2)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalConnectivityCellular given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalConnectivityCellular
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalConnectivityCellular
   */
  public static TerminalConnectivityCellular fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalConnectivityCellular.class);
  }
/**
  * Convert an instance of TerminalConnectivityCellular to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
