/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * VippsInfo
 */
@JsonPropertyOrder({
  VippsInfo.JSON_PROPERTY_LOGO,
  VippsInfo.JSON_PROPERTY_SUBSCRIPTION_CANCEL_URL
})

public class VippsInfo {
  public static final String JSON_PROPERTY_LOGO = "logo";
  private String logo;

  public static final String JSON_PROPERTY_SUBSCRIPTION_CANCEL_URL = "subscriptionCancelUrl";
  private String subscriptionCancelUrl;

  public VippsInfo() { 
  }

  /**
   * Vipps logo. Format: Base64-encoded string.
   *
   * @param logo Vipps logo. Format: Base64-encoded string.
   * @return the current {@code VippsInfo} instance, allowing for method chaining
   */
  public VippsInfo logo(String logo) {
    this.logo = logo;
    return this;
  }

  /**
   * Vipps logo. Format: Base64-encoded string.
   * @return logo Vipps logo. Format: Base64-encoded string.
   */
  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLogo() {
    return logo;
  }

  /**
   * Vipps logo. Format: Base64-encoded string.
   *
   * @param logo Vipps logo. Format: Base64-encoded string.
   */
  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogo(String logo) {
    this.logo = logo;
  }

  /**
   * Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   *
   * @param subscriptionCancelUrl Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   * @return the current {@code VippsInfo} instance, allowing for method chaining
   */
  public VippsInfo subscriptionCancelUrl(String subscriptionCancelUrl) {
    this.subscriptionCancelUrl = subscriptionCancelUrl;
    return this;
  }

  /**
   * Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   * @return subscriptionCancelUrl Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   */
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_CANCEL_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSubscriptionCancelUrl() {
    return subscriptionCancelUrl;
  }

  /**
   * Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   *
   * @param subscriptionCancelUrl Vipps subscription cancel url (required in case of [recurring payments](https://docs.adyen.com/online-payments/tokenization))
   */
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_CANCEL_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionCancelUrl(String subscriptionCancelUrl) {
    this.subscriptionCancelUrl = subscriptionCancelUrl;
  }

  /**
   * Return true if this VippsInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VippsInfo vippsInfo = (VippsInfo) o;
    return Objects.equals(this.logo, vippsInfo.logo) &&
        Objects.equals(this.subscriptionCancelUrl, vippsInfo.subscriptionCancelUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(logo, subscriptionCancelUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VippsInfo {\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    subscriptionCancelUrl: ").append(toIndentedString(subscriptionCancelUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of VippsInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of VippsInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to VippsInfo
   */
  public static VippsInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, VippsInfo.class);
  }
/**
  * Convert an instance of VippsInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
