/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.managementwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing ManagementWebhooks.
 * <p>
 * This class provides functionality to deserialize the payload of ManagementWebhooks events.
 */
public class ManagementWebhooksHandler {

    private static final Logger LOG = Logger.getLogger(ManagementWebhooksHandler.class.getName());

    private final String payload;

    /**
     * Constructs a new handler for the given webhook payload
     *
     * @param payload the raw JSON payload from the webhook
     */
    public ManagementWebhooksHandler(String payload) {
        this.payload = payload;
    }

    /**
     * Attempts to deserialize the webhook payload into a MerchantCreatedNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<MerchantCreatedNotificationRequest> getMerchantCreatedNotificationRequest() {
        return getOptionalField(MerchantCreatedNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a MerchantUpdatedNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<MerchantUpdatedNotificationRequest> getMerchantUpdatedNotificationRequest() {
        return getOptionalField(MerchantUpdatedNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a PaymentMethodCreatedNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<PaymentMethodCreatedNotificationRequest> getPaymentMethodCreatedNotificationRequest() {
        return getOptionalField(PaymentMethodCreatedNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a PaymentMethodRequestRemovedNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<PaymentMethodRequestRemovedNotificationRequest> getPaymentMethodRequestRemovedNotificationRequest() {
        return getOptionalField(PaymentMethodRequestRemovedNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a PaymentMethodScheduledForRemovalNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<PaymentMethodScheduledForRemovalNotificationRequest> getPaymentMethodScheduledForRemovalNotificationRequest() {
        return getOptionalField(PaymentMethodScheduledForRemovalNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a TerminalBoardingNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<TerminalBoardingNotificationRequest> getTerminalBoardingNotificationRequest() {
        return getOptionalField(TerminalBoardingNotificationRequest.class);
    }

    /**
     * Attempts to deserialize the webhook payload into a TerminalSettingsNotificationRequest
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<TerminalSettingsNotificationRequest> getTerminalSettingsNotificationRequest() {
        return getOptionalField(TerminalSettingsNotificationRequest.class);
    }

    /**
     * Deserializes the payload into the specified class type.
     *
     * @param clazz the class to deserialize into
     * @param <T>   the type of the class
     * @return an Optional containing the deserialized object, or empty if an error occurs
    */
    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            T val = JSON.getMapper().readValue(payload, clazz);
            return Optional.ofNullable(val);
        } catch (Exception e) {
            // an error has occurred during deserialization (object not found, deserialization error)
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }

}