/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.managementwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalBoardingData
 */
@JsonPropertyOrder({
  TerminalBoardingData.JSON_PROPERTY_COMPANY_ID,
  TerminalBoardingData.JSON_PROPERTY_MERCHANT_ID,
  TerminalBoardingData.JSON_PROPERTY_STORE_ID,
  TerminalBoardingData.JSON_PROPERTY_UNIQUE_TERMINAL_ID
})

public class TerminalBoardingData {
  public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
  private String companyId;

  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  private String storeId;

  public static final String JSON_PROPERTY_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
  private String uniqueTerminalId;

  public TerminalBoardingData() { 
  }

  /**
   * The unique identifier of the company account.
   *
   * @param companyId The unique identifier of the company account.
   * @return the current {@code TerminalBoardingData} instance, allowing for method chaining
   */
  public TerminalBoardingData companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

  /**
   * The unique identifier of the company account.
   * @return companyId The unique identifier of the company account.
   */
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCompanyId() {
    return companyId;
  }

  /**
   * The unique identifier of the company account.
   *
   * @param companyId The unique identifier of the company account.
   */
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  /**
   * The unique identifier of the merchant account.
   *
   * @param merchantId The unique identifier of the merchant account.
   * @return the current {@code TerminalBoardingData} instance, allowing for method chaining
   */
  public TerminalBoardingData merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The unique identifier of the merchant account.
   * @return merchantId The unique identifier of the merchant account.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantId() {
    return merchantId;
  }

  /**
   * The unique identifier of the merchant account.
   *
   * @param merchantId The unique identifier of the merchant account.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }

  /**
   * The unique identifier of the store.
   *
   * @param storeId The unique identifier of the store.
   * @return the current {@code TerminalBoardingData} instance, allowing for method chaining
   */
  public TerminalBoardingData storeId(String storeId) {
    this.storeId = storeId;
    return this;
  }

  /**
   * The unique identifier of the store.
   * @return storeId The unique identifier of the store.
   */
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoreId() {
    return storeId;
  }

  /**
   * The unique identifier of the store.
   *
   * @param storeId The unique identifier of the store.
   */
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(String storeId) {
    this.storeId = storeId;
  }

  /**
   * The unique identifier of the terminal.
   *
   * @param uniqueTerminalId The unique identifier of the terminal.
   * @return the current {@code TerminalBoardingData} instance, allowing for method chaining
   */
  public TerminalBoardingData uniqueTerminalId(String uniqueTerminalId) {
    this.uniqueTerminalId = uniqueTerminalId;
    return this;
  }

  /**
   * The unique identifier of the terminal.
   * @return uniqueTerminalId The unique identifier of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_UNIQUE_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUniqueTerminalId() {
    return uniqueTerminalId;
  }

  /**
   * The unique identifier of the terminal.
   *
   * @param uniqueTerminalId The unique identifier of the terminal.
   */
  @JsonProperty(JSON_PROPERTY_UNIQUE_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueTerminalId(String uniqueTerminalId) {
    this.uniqueTerminalId = uniqueTerminalId;
  }

  /**
   * Return true if this TerminalBoardingData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalBoardingData terminalBoardingData = (TerminalBoardingData) o;
    return Objects.equals(this.companyId, terminalBoardingData.companyId) &&
        Objects.equals(this.merchantId, terminalBoardingData.merchantId) &&
        Objects.equals(this.storeId, terminalBoardingData.storeId) &&
        Objects.equals(this.uniqueTerminalId, terminalBoardingData.uniqueTerminalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, merchantId, storeId, uniqueTerminalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalBoardingData {\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    uniqueTerminalId: ").append(toIndentedString(uniqueTerminalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalBoardingData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalBoardingData
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalBoardingData
   */
  public static TerminalBoardingData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalBoardingData.class);
  }
/**
  * Convert an instance of TerminalBoardingData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
