/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ThreeDSRequestorAuthenticationInfo
 */
@JsonPropertyOrder({
  ThreeDSRequestorAuthenticationInfo.JSON_PROPERTY_THREE_D_S_REQ_AUTH_DATA,
  ThreeDSRequestorAuthenticationInfo.JSON_PROPERTY_THREE_D_S_REQ_AUTH_METHOD,
  ThreeDSRequestorAuthenticationInfo.JSON_PROPERTY_THREE_D_S_REQ_AUTH_TIMESTAMP
})

public class ThreeDSRequestorAuthenticationInfo {
  public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_DATA = "threeDSReqAuthData";
  private String threeDSReqAuthData;

  /**
   * Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   */
  public enum ThreeDSReqAuthMethodEnum {
    _01(String.valueOf("01")),
    
    _02(String.valueOf("02")),
    
    _03(String.valueOf("03")),
    
    _04(String.valueOf("04")),
    
    _05(String.valueOf("05")),
    
    _06(String.valueOf("06"));

    private String value;

    ThreeDSReqAuthMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ThreeDSReqAuthMethodEnum fromValue(String value) {
      for (ThreeDSReqAuthMethodEnum b : ThreeDSReqAuthMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_METHOD = "threeDSReqAuthMethod";
  private ThreeDSReqAuthMethodEnum threeDSReqAuthMethod;

  public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_TIMESTAMP = "threeDSReqAuthTimestamp";
  private String threeDSReqAuthTimestamp;

  public ThreeDSRequestorAuthenticationInfo() { 
  }

  /**
   * Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   *
   * @param threeDSReqAuthData Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   * @return the current {@code ThreeDSRequestorAuthenticationInfo} instance, allowing for method chaining
   */
  public ThreeDSRequestorAuthenticationInfo threeDSReqAuthData(String threeDSReqAuthData) {
    this.threeDSReqAuthData = threeDSReqAuthData;
    return this;
  }

  /**
   * Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   * @return threeDSReqAuthData Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDSReqAuthData() {
    return threeDSReqAuthData;
  }

  /**
   * Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   *
   * @param threeDSReqAuthData Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSReqAuthData(String threeDSReqAuthData) {
    this.threeDSReqAuthData = threeDSReqAuthData;
  }

  /**
   * Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   *
   * @param threeDSReqAuthMethod Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   * @return the current {@code ThreeDSRequestorAuthenticationInfo} instance, allowing for method chaining
   */
  public ThreeDSRequestorAuthenticationInfo threeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
    this.threeDSReqAuthMethod = threeDSReqAuthMethod;
    return this;
  }

  /**
   * Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   * @return threeDSReqAuthMethod Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDSReqAuthMethodEnum getThreeDSReqAuthMethod() {
    return threeDSReqAuthMethod;
  }

  /**
   * Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   *
   * @param threeDSReqAuthMethod Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** — No 3DS Requestor authentication occurred (for example, cardholder “logged in” as guest). * **02** — Login to the cardholder account at the 3DS Requestor system using 3DS Requestor’s own credentials. * **03** — Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** — Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** — Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** — Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
    this.threeDSReqAuthMethod = threeDSReqAuthMethod;
  }

  /**
   * Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   *
   * @param threeDSReqAuthTimestamp Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   * @return the current {@code ThreeDSRequestorAuthenticationInfo} instance, allowing for method chaining
   */
  public ThreeDSRequestorAuthenticationInfo threeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
    this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
    return this;
  }

  /**
   * Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   * @return threeDSReqAuthTimestamp Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDSReqAuthTimestamp() {
    return threeDSReqAuthTimestamp;
  }

  /**
   * Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   *
   * @param threeDSReqAuthTimestamp Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQ_AUTH_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
    this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
  }

  /**
   * Return true if this ThreeDSRequestorAuthenticationInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo = (ThreeDSRequestorAuthenticationInfo) o;
    return Objects.equals(this.threeDSReqAuthData, threeDSRequestorAuthenticationInfo.threeDSReqAuthData) &&
        Objects.equals(this.threeDSReqAuthMethod, threeDSRequestorAuthenticationInfo.threeDSReqAuthMethod) &&
        Objects.equals(this.threeDSReqAuthTimestamp, threeDSRequestorAuthenticationInfo.threeDSReqAuthTimestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(threeDSReqAuthData, threeDSReqAuthMethod, threeDSReqAuthTimestamp);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDSRequestorAuthenticationInfo {\n");
    sb.append("    threeDSReqAuthData: ").append(toIndentedString(threeDSReqAuthData)).append("\n");
    sb.append("    threeDSReqAuthMethod: ").append(toIndentedString(threeDSReqAuthMethod)).append("\n");
    sb.append("    threeDSReqAuthTimestamp: ").append(toIndentedString(threeDSReqAuthTimestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ThreeDSRequestorAuthenticationInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ThreeDSRequestorAuthenticationInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to ThreeDSRequestorAuthenticationInfo
   */
  public static ThreeDSRequestorAuthenticationInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ThreeDSRequestorAuthenticationInfo.class);
  }
/**
  * Convert an instance of ThreeDSRequestorAuthenticationInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
