/*
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payout;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.payout.FraudCheckResultWrapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * FraudResult
 */
@JsonPropertyOrder({
  FraudResult.JSON_PROPERTY_ACCOUNT_SCORE,
  FraudResult.JSON_PROPERTY_RESULTS
})

public class FraudResult {
  public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
  private Integer accountScore;

  public static final String JSON_PROPERTY_RESULTS = "results";
  private List<FraudCheckResultWrapper> results;

  public FraudResult() { 
  }

  /**
   * The total fraud score generated by the risk checks.
   *
   * @param accountScore The total fraud score generated by the risk checks.
   * @return the current {@code FraudResult} instance, allowing for method chaining
   */
  public FraudResult accountScore(Integer accountScore) {
    this.accountScore = accountScore;
    return this;
  }

  /**
   * The total fraud score generated by the risk checks.
   * @return accountScore The total fraud score generated by the risk checks.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getAccountScore() {
    return accountScore;
  }

  /**
   * The total fraud score generated by the risk checks.
   *
   * @param accountScore The total fraud score generated by the risk checks.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountScore(Integer accountScore) {
    this.accountScore = accountScore;
  }

  /**
   * The result of the individual risk checks.
   *
   * @param results The result of the individual risk checks.
   * @return the current {@code FraudResult} instance, allowing for method chaining
   */
  public FraudResult results(List<FraudCheckResultWrapper> results) {
    this.results = results;
    return this;
  }

  public FraudResult addResultsItem(FraudCheckResultWrapper resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<>();
    }
    this.results.add(resultsItem);
    return this;
  }

  /**
   * The result of the individual risk checks.
   * @return results The result of the individual risk checks.
   */
  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<FraudCheckResultWrapper> getResults() {
    return results;
  }

  /**
   * The result of the individual risk checks.
   *
   * @param results The result of the individual risk checks.
   */
  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResults(List<FraudCheckResultWrapper> results) {
    this.results = results;
  }

  /**
   * Return true if this FraudResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FraudResult fraudResult = (FraudResult) o;
    return Objects.equals(this.accountScore, fraudResult.accountScore) &&
        Objects.equals(this.results, fraudResult.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountScore, results);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FraudResult {\n");
    sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of FraudResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of FraudResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to FraudResult
   */
  public static FraudResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, FraudResult.class);
  }
/**
  * Convert an instance of FraudResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
