/*
 * Adyen Recurring API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.recurring;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.recurring.Card;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ScheduleAccountUpdaterRequest
 */
@JsonPropertyOrder({
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_ADDITIONAL_DATA,
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_CARD,
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_REFERENCE,
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE,
  ScheduleAccountUpdaterRequest.JSON_PROPERTY_SHOPPER_REFERENCE
})

public class ScheduleAccountUpdaterRequest {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_CARD = "card";
  private Card card;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
  private String selectedRecurringDetailReference;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public ScheduleAccountUpdaterRequest() { 
  }

  /**
   * This field contains additional data, which may be required for a particular request.
   *
   * @param additionalData This field contains additional data, which may be required for a particular request.
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public ScheduleAccountUpdaterRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * This field contains additional data, which may be required for a particular request.
   * @return additionalData This field contains additional data, which may be required for a particular request.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * This field contains additional data, which may be required for a particular request.
   *
   * @param additionalData This field contains additional data, which may be required for a particular request.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * card
   *
   * @param card 
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest card(Card card) {
    this.card = card;
    return this;
  }

  /**
   * Get card
   * @return card 
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Card getCard() {
    return card;
  }

  /**
   * card
   *
   * @param card 
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCard(Card card) {
    this.card = card;
  }

  /**
   * Account of the merchant.
   *
   * @param merchantAccount Account of the merchant.
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * Account of the merchant.
   * @return merchantAccount Account of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * Account of the merchant.
   *
   * @param merchantAccount Account of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * A reference that merchants can apply for the call.
   *
   * @param reference A reference that merchants can apply for the call.
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * A reference that merchants can apply for the call.
   * @return reference A reference that merchants can apply for the call.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * A reference that merchants can apply for the call.
   *
   * @param reference A reference that merchants can apply for the call.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   *
   * @param selectedRecurringDetailReference The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
    this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    return this;
  }

  /**
   * The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   * @return selectedRecurringDetailReference The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSelectedRecurringDetailReference() {
    return selectedRecurringDetailReference;
  }

  /**
   * The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   *
   * @param selectedRecurringDetailReference The selected detail recurring reference.  Optional if &#x60;card&#x60; is provided.
   */
  @JsonProperty(JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
    this.selectedRecurringDetailReference = selectedRecurringDetailReference;
  }

  /**
   * The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   *
   * @param shopperReference The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   * @return the current {@code ScheduleAccountUpdaterRequest} instance, allowing for method chaining
   */
  public ScheduleAccountUpdaterRequest shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   * @return shopperReference The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   *
   * @param shopperReference The reference of the shopper that owns the recurring contract.  Optional if &#x60;card&#x60; is provided.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * Return true if this ScheduleAccountUpdaterRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleAccountUpdaterRequest scheduleAccountUpdaterRequest = (ScheduleAccountUpdaterRequest) o;
    return Objects.equals(this.additionalData, scheduleAccountUpdaterRequest.additionalData) &&
        Objects.equals(this.card, scheduleAccountUpdaterRequest.card) &&
        Objects.equals(this.merchantAccount, scheduleAccountUpdaterRequest.merchantAccount) &&
        Objects.equals(this.reference, scheduleAccountUpdaterRequest.reference) &&
        Objects.equals(this.selectedRecurringDetailReference, scheduleAccountUpdaterRequest.selectedRecurringDetailReference) &&
        Objects.equals(this.shopperReference, scheduleAccountUpdaterRequest.shopperReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, card, merchantAccount, reference, selectedRecurringDetailReference, shopperReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleAccountUpdaterRequest {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    selectedRecurringDetailReference: ").append(toIndentedString(selectedRecurringDetailReference)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ScheduleAccountUpdaterRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ScheduleAccountUpdaterRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to ScheduleAccountUpdaterRequest
   */
  public static ScheduleAccountUpdaterRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ScheduleAccountUpdaterRequest.class);
  }
/**
  * Convert an instance of ScheduleAccountUpdaterRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
