/*
 * Transaction webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transactionwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing TransactionWebhooks.
 * <p>
 * This class provides functionality to deserialize the payload of TransactionWebhooks events.
 */
public class TransactionWebhooksHandler {

    private static final Logger LOG = Logger.getLogger(TransactionWebhooksHandler.class.getName());

    private final String payload;

    /**
     * Constructs a new handler for the given webhook payload
     *
     * @param payload the raw JSON payload from the webhook
     */
    public TransactionWebhooksHandler(String payload) {
        this.payload = payload;
    }

    /**
     * Attempts to deserialize the webhook payload into a TransactionNotificationRequestV4
     *
     * @return an Optional containing the deserialized object, or empty if deserialization fails
     */
    public Optional<TransactionNotificationRequestV4> getTransactionNotificationRequestV4() {
        return getOptionalField(TransactionNotificationRequestV4.class);
    }

    /**
     * Deserializes the payload into the specified class type.
     *
     * @param clazz the class to deserialize into
     * @param <T>   the type of the class
     * @return an Optional containing the deserialized object, or empty if an error occurs
    */
    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            T val = JSON.getMapper().readValue(payload, clazz);
            return Optional.ofNullable(val);
        } catch (Exception e) {
            // an error has occurred during deserialization (object not found, deserialization error)
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }

}