/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transfers.BankCategoryData;
import com.adyen.model.transfers.InternalCategoryData;
import com.adyen.model.transfers.IssuedCard;
import com.adyen.model.transfers.PlatformPayment;
import com.adyen.model.transfers.RelayedAuthorisationData;
import com.adyen.model.transfers.TransferNotificationValidationFact;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;

import com.fasterxml.jackson.core.type.TypeReference;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;


@JsonDeserialize(using = TransferCategoryData.TransferCategoryDataDeserializer.class)
@JsonSerialize(using = TransferCategoryData.TransferCategoryDataSerializer.class)
public class TransferCategoryData extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(TransferCategoryData.class.getName());

    public static class TransferCategoryDataSerializer extends StdSerializer<TransferCategoryData> {
        public TransferCategoryDataSerializer(Class<TransferCategoryData> t) {
            super(t);
        }

        public TransferCategoryDataSerializer() {
            this(null);
        }

        @Override
        public void serialize(TransferCategoryData value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }

    public static class TransferCategoryDataDeserializer extends StdDeserializer<TransferCategoryData> {
        public TransferCategoryDataDeserializer() {
            this(TransferCategoryData.class);
        }

        public TransferCategoryDataDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public TransferCategoryData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            // deserialize BankCategoryData
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(BankCategoryData.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(BankCategoryData.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'BankCategoryData'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'BankCategoryData'", e);
            }

            // deserialize InternalCategoryData
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(InternalCategoryData.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(InternalCategoryData.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'InternalCategoryData'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'InternalCategoryData'", e);
            }

            // deserialize IssuedCard
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(IssuedCard.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(IssuedCard.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'IssuedCard'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'IssuedCard'", e);
            }

            // deserialize PlatformPayment
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(PlatformPayment.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(PlatformPayment.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'PlatformPayment'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'PlatformPayment'", e);
            }

            if (match == 1) {
                TransferCategoryData ret = new TransferCategoryData();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for TransferCategoryData: %d classes match result, expected 1", match));
        }

        /**
         * Handle deserialization of the 'null' value.
         */
        @Override
        public TransferCategoryData getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "TransferCategoryData cannot be null");
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, GenericType<?>> schemas = new HashMap<>();

    public TransferCategoryData() {
        super("oneOf", Boolean.FALSE);
    }

    public TransferCategoryData(BankCategoryData o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public TransferCategoryData(InternalCategoryData o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public TransferCategoryData(IssuedCard o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public TransferCategoryData(PlatformPayment o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("BankCategoryData", new GenericType<BankCategoryData>() {
        });
        schemas.put("InternalCategoryData", new GenericType<InternalCategoryData>() {
        });
        schemas.put("IssuedCard", new GenericType<IssuedCard>() {
        });
        schemas.put("PlatformPayment", new GenericType<PlatformPayment>() {
        });
        JSON.registerDescendants(TransferCategoryData.class, Collections.unmodifiableMap(schemas));
    }

    @Override
    public Map<String, GenericType<?>> getSchemas() {
        return TransferCategoryData.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(BankCategoryData.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(InternalCategoryData.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(IssuedCard.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(PlatformPayment.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment");
    }

    /**
     * Get the actual instance, which can be the following:
     * BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment
     *
     * @return The actual instance (BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `BankCategoryData`. If the actual instance is not `BankCategoryData`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `BankCategoryData`
     * @throws ClassCastException if the instance is not `BankCategoryData`
     */
    public BankCategoryData getBankCategoryData() throws ClassCastException {
        return (BankCategoryData)super.getActualInstance();
    }

    /**
     * Get the actual instance of `InternalCategoryData`. If the actual instance is not `InternalCategoryData`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `InternalCategoryData`
     * @throws ClassCastException if the instance is not `InternalCategoryData`
     */
    public InternalCategoryData getInternalCategoryData() throws ClassCastException {
        return (InternalCategoryData)super.getActualInstance();
    }

    /**
     * Get the actual instance of `IssuedCard`. If the actual instance is not `IssuedCard`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `IssuedCard`
     * @throws ClassCastException if the instance is not `IssuedCard`
     */
    public IssuedCard getIssuedCard() throws ClassCastException {
        return (IssuedCard)super.getActualInstance();
    }

    /**
     * Get the actual instance of `PlatformPayment`. If the actual instance is not `PlatformPayment`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `PlatformPayment`
     * @throws ClassCastException if the instance is not `PlatformPayment`
     */
    public PlatformPayment getPlatformPayment() throws ClassCastException {
        return (PlatformPayment)super.getActualInstance();
    }


    /**
    * Create an instance of TransferCategoryData given an JSON string
    *
    * @param jsonString JSON string
    * @return An instance of TransferCategoryData
    * @throws IOException if the JSON string is invalid with respect to TransferCategoryData
    */
    public static TransferCategoryData fromJson(String jsonString) throws IOException {
        return JSON.getMapper().readValue(jsonString, TransferCategoryData.class);
    }

    /**
    * Convert an instance of TransferCategoryData to an JSON string
    *
    * @return JSON string
    */
    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString(this);
    }

}
