/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transfers.ConfirmationTrackingData;
import com.adyen.model.transfers.EstimationTrackingData;
import com.adyen.model.transfers.InternalReviewTrackingData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;

import com.fasterxml.jackson.core.type.TypeReference;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;


@JsonDeserialize(using = TransferDataTracking.TransferDataTrackingDeserializer.class)
@JsonSerialize(using = TransferDataTracking.TransferDataTrackingSerializer.class)
public class TransferDataTracking extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(TransferDataTracking.class.getName());

    public static class TransferDataTrackingSerializer extends StdSerializer<TransferDataTracking> {
        public TransferDataTrackingSerializer(Class<TransferDataTracking> t) {
            super(t);
        }

        public TransferDataTrackingSerializer() {
            this(null);
        }

        @Override
        public void serialize(TransferDataTracking value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }

    public static class TransferDataTrackingDeserializer extends StdDeserializer<TransferDataTracking> {
        public TransferDataTrackingDeserializer() {
            this(TransferDataTracking.class);
        }

        public TransferDataTrackingDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public TransferDataTracking deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            // deserialize ConfirmationTrackingData
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(ConfirmationTrackingData.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(ConfirmationTrackingData.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'ConfirmationTrackingData'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'ConfirmationTrackingData'", e);
            }

            // deserialize EstimationTrackingData
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(EstimationTrackingData.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(EstimationTrackingData.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'EstimationTrackingData'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'EstimationTrackingData'", e);
            }

            // deserialize InternalReviewTrackingData
            try {
                boolean attemptParsing = true;
                if (attemptParsing) {
                    // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
                    boolean typeMatch = Arrays.stream(InternalReviewTrackingData.TypeEnum.values()).anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

                    if(typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(InternalReviewTrackingData.class);
                        // TODO: there is no validation against JSON schema constraints
                        // (min, max, enum, pattern...), this does not perform a strict JSON
                        // validation, which means the 'match' count may be higher than it should be.
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'InternalReviewTrackingData'");
                    }
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'InternalReviewTrackingData'", e);
            }

            if (match == 1) {
                TransferDataTracking ret = new TransferDataTracking();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for TransferDataTracking: %d classes match result, expected 1", match));
        }

        /**
         * Handle deserialization of the 'null' value.
         */
        @Override
        public TransferDataTracking getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "TransferDataTracking cannot be null");
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, GenericType<?>> schemas = new HashMap<>();

    public TransferDataTracking() {
        super("oneOf", Boolean.FALSE);
    }

    public TransferDataTracking(ConfirmationTrackingData o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public TransferDataTracking(EstimationTrackingData o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public TransferDataTracking(InternalReviewTrackingData o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("ConfirmationTrackingData", new GenericType<ConfirmationTrackingData>() {
        });
        schemas.put("EstimationTrackingData", new GenericType<EstimationTrackingData>() {
        });
        schemas.put("InternalReviewTrackingData", new GenericType<InternalReviewTrackingData>() {
        });
        JSON.registerDescendants(TransferDataTracking.class, Collections.unmodifiableMap(schemas));
    }

    @Override
    public Map<String, GenericType<?>> getSchemas() {
        return TransferDataTracking.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * ConfirmationTrackingData, EstimationTrackingData, InternalReviewTrackingData
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(ConfirmationTrackingData.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(EstimationTrackingData.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(InternalReviewTrackingData.class, instance, new HashSet<>())) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be ConfirmationTrackingData, EstimationTrackingData, InternalReviewTrackingData");
    }

    /**
     * Get the actual instance, which can be the following:
     * ConfirmationTrackingData, EstimationTrackingData, InternalReviewTrackingData
     *
     * @return The actual instance (ConfirmationTrackingData, EstimationTrackingData, InternalReviewTrackingData)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `ConfirmationTrackingData`. If the actual instance is not `ConfirmationTrackingData`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `ConfirmationTrackingData`
     * @throws ClassCastException if the instance is not `ConfirmationTrackingData`
     */
    public ConfirmationTrackingData getConfirmationTrackingData() throws ClassCastException {
        return (ConfirmationTrackingData)super.getActualInstance();
    }

    /**
     * Get the actual instance of `EstimationTrackingData`. If the actual instance is not `EstimationTrackingData`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `EstimationTrackingData`
     * @throws ClassCastException if the instance is not `EstimationTrackingData`
     */
    public EstimationTrackingData getEstimationTrackingData() throws ClassCastException {
        return (EstimationTrackingData)super.getActualInstance();
    }

    /**
     * Get the actual instance of `InternalReviewTrackingData`. If the actual instance is not `InternalReviewTrackingData`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `InternalReviewTrackingData`
     * @throws ClassCastException if the instance is not `InternalReviewTrackingData`
     */
    public InternalReviewTrackingData getInternalReviewTrackingData() throws ClassCastException {
        return (InternalReviewTrackingData)super.getActualInstance();
    }


    /**
    * Create an instance of TransferDataTracking given an JSON string
    *
    * @param jsonString JSON string
    * @return An instance of TransferDataTracking
    * @throws IOException if the JSON string is invalid with respect to TransferDataTracking
    */
    public static TransferDataTracking fromJson(String jsonString) throws IOException {
        return JSON.getMapper().readValue(jsonString, TransferDataTracking.class);
    }

    /**
    * Convert an instance of TransferDataTracking to an JSON string
    *
    * @return JSON string
    */
    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString(this);
    }

}
