/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Modification
 */
@JsonPropertyOrder({
  Modification.JSON_PROPERTY_DIRECTION,
  Modification.JSON_PROPERTY_ID,
  Modification.JSON_PROPERTY_REFERENCE,
  Modification.JSON_PROPERTY_STATUS,
  Modification.JSON_PROPERTY_TYPE
})

public class Modification {
  public static final String JSON_PROPERTY_DIRECTION = "direction";
  private String direction;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  /**
   * The status of the transfer event.
   */
  public enum StatusEnum {
    APPROVALPENDING(String.valueOf("approvalPending")),
    
    ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
    
    ATMWITHDRAWALREVERSALPENDING(String.valueOf("atmWithdrawalReversalPending")),
    
    ATMWITHDRAWALREVERSED(String.valueOf("atmWithdrawalReversed")),
    
    AUTHADJUSTMENTAUTHORISED(String.valueOf("authAdjustmentAuthorised")),
    
    AUTHADJUSTMENTERROR(String.valueOf("authAdjustmentError")),
    
    AUTHADJUSTMENTREFUSED(String.valueOf("authAdjustmentRefused")),
    
    AUTHORISED(String.valueOf("authorised")),
    
    BANKTRANSFER(String.valueOf("bankTransfer")),
    
    BANKTRANSFERPENDING(String.valueOf("bankTransferPending")),
    
    BOOKED(String.valueOf("booked")),
    
    BOOKINGPENDING(String.valueOf("bookingPending")),
    
    CANCELLED(String.valueOf("cancelled")),
    
    CAPTUREPENDING(String.valueOf("capturePending")),
    
    CAPTUREREVERSALPENDING(String.valueOf("captureReversalPending")),
    
    CAPTUREREVERSED(String.valueOf("captureReversed")),
    
    CAPTURED(String.valueOf("captured")),
    
    CAPTUREDEXTERNALLY(String.valueOf("capturedExternally")),
    
    CHARGEBACK(String.valueOf("chargeback")),
    
    CHARGEBACKEXTERNALLY(String.valueOf("chargebackExternally")),
    
    CHARGEBACKPENDING(String.valueOf("chargebackPending")),
    
    CHARGEBACKREVERSALPENDING(String.valueOf("chargebackReversalPending")),
    
    CHARGEBACKREVERSED(String.valueOf("chargebackReversed")),
    
    CREDITED(String.valueOf("credited")),
    
    DEPOSITCORRECTION(String.valueOf("depositCorrection")),
    
    DEPOSITCORRECTIONPENDING(String.valueOf("depositCorrectionPending")),
    
    DISPUTE(String.valueOf("dispute")),
    
    DISPUTECLOSED(String.valueOf("disputeClosed")),
    
    DISPUTEEXPIRED(String.valueOf("disputeExpired")),
    
    DISPUTENEEDSREVIEW(String.valueOf("disputeNeedsReview")),
    
    ERROR(String.valueOf("error")),
    
    EXPIRED(String.valueOf("expired")),
    
    FAILED(String.valueOf("failed")),
    
    FEE(String.valueOf("fee")),
    
    FEEPENDING(String.valueOf("feePending")),
    
    INTERNALTRANSFER(String.valueOf("internalTransfer")),
    
    INTERNALTRANSFERPENDING(String.valueOf("internalTransferPending")),
    
    INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
    
    INVOICEDEDUCTIONPENDING(String.valueOf("invoiceDeductionPending")),
    
    MANUALCORRECTIONPENDING(String.valueOf("manualCorrectionPending")),
    
    MANUALLYCORRECTED(String.valueOf("manuallyCorrected")),
    
    MATCHEDSTATEMENT(String.valueOf("matchedStatement")),
    
    MATCHEDSTATEMENTPENDING(String.valueOf("matchedStatementPending")),
    
    MERCHANTPAYIN(String.valueOf("merchantPayin")),
    
    MERCHANTPAYINPENDING(String.valueOf("merchantPayinPending")),
    
    MERCHANTPAYINREVERSED(String.valueOf("merchantPayinReversed")),
    
    MERCHANTPAYINREVERSEDPENDING(String.valueOf("merchantPayinReversedPending")),
    
    MISCCOST(String.valueOf("miscCost")),
    
    MISCCOSTPENDING(String.valueOf("miscCostPending")),
    
    PAYMENTCOST(String.valueOf("paymentCost")),
    
    PAYMENTCOSTPENDING(String.valueOf("paymentCostPending")),
    
    PENDINGAPPROVAL(String.valueOf("pendingApproval")),
    
    PENDINGEXECUTION(String.valueOf("pendingExecution")),
    
    RECEIVED(String.valueOf("received")),
    
    REFUNDPENDING(String.valueOf("refundPending")),
    
    REFUNDREVERSALPENDING(String.valueOf("refundReversalPending")),
    
    REFUNDREVERSED(String.valueOf("refundReversed")),
    
    REFUNDED(String.valueOf("refunded")),
    
    REFUNDEDEXTERNALLY(String.valueOf("refundedExternally")),
    
    REFUSED(String.valueOf("refused")),
    
    REJECTED(String.valueOf("rejected")),
    
    RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
    
    RESERVEADJUSTMENTPENDING(String.valueOf("reserveAdjustmentPending")),
    
    RETURNED(String.valueOf("returned")),
    
    SECONDCHARGEBACK(String.valueOf("secondChargeback")),
    
    SECONDCHARGEBACKPENDING(String.valueOf("secondChargebackPending")),
    
    UNDEFINED(String.valueOf("undefined"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public Modification() { 
  }

  /**
   * The direction of the money movement.
   *
   * @param direction The direction of the money movement.
   * @return the current {@code Modification} instance, allowing for method chaining
   */
  public Modification direction(String direction) {
    this.direction = direction;
    return this;
  }

  /**
   * The direction of the money movement.
   * @return direction The direction of the money movement.
   */
  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDirection() {
    return direction;
  }

  /**
   * The direction of the money movement.
   *
   * @param direction The direction of the money movement.
   */
  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDirection(String direction) {
    this.direction = direction;
  }

  /**
   * Our reference for the modification.
   *
   * @param id Our reference for the modification.
   * @return the current {@code Modification} instance, allowing for method chaining
   */
  public Modification id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Our reference for the modification.
   * @return id Our reference for the modification.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * Our reference for the modification.
   *
   * @param id Our reference for the modification.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * Your reference for the modification, used internally within your platform.
   *
   * @param reference Your reference for the modification, used internally within your platform.
   * @return the current {@code Modification} instance, allowing for method chaining
   */
  public Modification reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the modification, used internally within your platform.
   * @return reference Your reference for the modification, used internally within your platform.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the modification, used internally within your platform.
   *
   * @param reference Your reference for the modification, used internally within your platform.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The status of the transfer event.
   *
   * @param status The status of the transfer event.
   * @return the current {@code Modification} instance, allowing for method chaining
   */
  public Modification status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the transfer event.
   * @return status The status of the transfer event.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the transfer event.
   *
   * @param status The status of the transfer event.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The type of transfer modification.
   *
   * @param type The type of transfer modification.
   * @return the current {@code Modification} instance, allowing for method chaining
   */
  public Modification type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of transfer modification.
   * @return type The type of transfer modification.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of transfer modification.
   *
   * @param type The type of transfer modification.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Return true if this Modification object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Modification modification = (Modification) o;
    return Objects.equals(this.direction, modification.direction) &&
        Objects.equals(this.id, modification.id) &&
        Objects.equals(this.reference, modification.reference) &&
        Objects.equals(this.status, modification.status) &&
        Objects.equals(this.type, modification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(direction, id, reference, status, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Modification {\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Modification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Modification
   * @throws JsonProcessingException if the JSON string is invalid with respect to Modification
   */
  public static Modification fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Modification.class);
  }
/**
  * Convert an instance of Modification to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
