/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transferwebhooks.TransactionEventViolation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TransactionRulesResult
 */
@JsonPropertyOrder({
  TransactionRulesResult.JSON_PROPERTY_ADVICE,
  TransactionRulesResult.JSON_PROPERTY_ALL_HARD_BLOCK_RULES_PASSED,
  TransactionRulesResult.JSON_PROPERTY_SCORE,
  TransactionRulesResult.JSON_PROPERTY_TRIGGERED_TRANSACTION_RULES
})

public class TransactionRulesResult {
  public static final String JSON_PROPERTY_ADVICE = "advice";
  private String advice;

  public static final String JSON_PROPERTY_ALL_HARD_BLOCK_RULES_PASSED = "allHardBlockRulesPassed";
  private Boolean allHardBlockRulesPassed;

  public static final String JSON_PROPERTY_SCORE = "score";
  private Integer score;

  public static final String JSON_PROPERTY_TRIGGERED_TRANSACTION_RULES = "triggeredTransactionRules";
  private List<TransactionEventViolation> triggeredTransactionRules;

  public TransactionRulesResult() { 
  }

  /**
   * The advice given by the Risk analysis.
   *
   * @param advice The advice given by the Risk analysis.
   * @return the current {@code TransactionRulesResult} instance, allowing for method chaining
   */
  public TransactionRulesResult advice(String advice) {
    this.advice = advice;
    return this;
  }

  /**
   * The advice given by the Risk analysis.
   * @return advice The advice given by the Risk analysis.
   */
  @JsonProperty(JSON_PROPERTY_ADVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAdvice() {
    return advice;
  }

  /**
   * The advice given by the Risk analysis.
   *
   * @param advice The advice given by the Risk analysis.
   */
  @JsonProperty(JSON_PROPERTY_ADVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvice(String advice) {
    this.advice = advice;
  }

  /**
   * Indicates whether the transaction passed the evaluation for all hardblock rules
   *
   * @param allHardBlockRulesPassed Indicates whether the transaction passed the evaluation for all hardblock rules
   * @return the current {@code TransactionRulesResult} instance, allowing for method chaining
   */
  public TransactionRulesResult allHardBlockRulesPassed(Boolean allHardBlockRulesPassed) {
    this.allHardBlockRulesPassed = allHardBlockRulesPassed;
    return this;
  }

  /**
   * Indicates whether the transaction passed the evaluation for all hardblock rules
   * @return allHardBlockRulesPassed Indicates whether the transaction passed the evaluation for all hardblock rules
   */
  @JsonProperty(JSON_PROPERTY_ALL_HARD_BLOCK_RULES_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllHardBlockRulesPassed() {
    return allHardBlockRulesPassed;
  }

  /**
   * Indicates whether the transaction passed the evaluation for all hardblock rules
   *
   * @param allHardBlockRulesPassed Indicates whether the transaction passed the evaluation for all hardblock rules
   */
  @JsonProperty(JSON_PROPERTY_ALL_HARD_BLOCK_RULES_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllHardBlockRulesPassed(Boolean allHardBlockRulesPassed) {
    this.allHardBlockRulesPassed = allHardBlockRulesPassed;
  }

  /**
   * The score of the Risk analysis.
   *
   * @param score The score of the Risk analysis.
   * @return the current {@code TransactionRulesResult} instance, allowing for method chaining
   */
  public TransactionRulesResult score(Integer score) {
    this.score = score;
    return this;
  }

  /**
   * The score of the Risk analysis.
   * @return score The score of the Risk analysis.
   */
  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getScore() {
    return score;
  }

  /**
   * The score of the Risk analysis.
   *
   * @param score The score of the Risk analysis.
   */
  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScore(Integer score) {
    this.score = score;
  }

  /**
   * Array containing all the transaction rules that the transaction triggered.
   *
   * @param triggeredTransactionRules Array containing all the transaction rules that the transaction triggered.
   * @return the current {@code TransactionRulesResult} instance, allowing for method chaining
   */
  public TransactionRulesResult triggeredTransactionRules(List<TransactionEventViolation> triggeredTransactionRules) {
    this.triggeredTransactionRules = triggeredTransactionRules;
    return this;
  }

  public TransactionRulesResult addTriggeredTransactionRulesItem(TransactionEventViolation triggeredTransactionRulesItem) {
    if (this.triggeredTransactionRules == null) {
      this.triggeredTransactionRules = new ArrayList<>();
    }
    this.triggeredTransactionRules.add(triggeredTransactionRulesItem);
    return this;
  }

  /**
   * Array containing all the transaction rules that the transaction triggered.
   * @return triggeredTransactionRules Array containing all the transaction rules that the transaction triggered.
   */
  @JsonProperty(JSON_PROPERTY_TRIGGERED_TRANSACTION_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TransactionEventViolation> getTriggeredTransactionRules() {
    return triggeredTransactionRules;
  }

  /**
   * Array containing all the transaction rules that the transaction triggered.
   *
   * @param triggeredTransactionRules Array containing all the transaction rules that the transaction triggered.
   */
  @JsonProperty(JSON_PROPERTY_TRIGGERED_TRANSACTION_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTriggeredTransactionRules(List<TransactionEventViolation> triggeredTransactionRules) {
    this.triggeredTransactionRules = triggeredTransactionRules;
  }

  /**
   * Return true if this TransactionRulesResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionRulesResult transactionRulesResult = (TransactionRulesResult) o;
    return Objects.equals(this.advice, transactionRulesResult.advice) &&
        Objects.equals(this.allHardBlockRulesPassed, transactionRulesResult.allHardBlockRulesPassed) &&
        Objects.equals(this.score, transactionRulesResult.score) &&
        Objects.equals(this.triggeredTransactionRules, transactionRulesResult.triggeredTransactionRules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(advice, allHardBlockRulesPassed, score, triggeredTransactionRules);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionRulesResult {\n");
    sb.append("    advice: ").append(toIndentedString(advice)).append("\n");
    sb.append("    allHardBlockRulesPassed: ").append(toIndentedString(allHardBlockRulesPassed)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("    triggeredTransactionRules: ").append(toIndentedString(triggeredTransactionRules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TransactionRulesResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransactionRulesResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransactionRulesResult
   */
  public static TransactionRulesResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransactionRulesResult.class);
  }
/**
  * Convert an instance of TransactionRulesResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
