/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transferwebhooks.BankAccountV3;
import com.adyen.model.transferwebhooks.Card;
import com.adyen.model.transferwebhooks.TransferNotificationMerchantData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TransferNotificationCounterParty
 */
@JsonPropertyOrder({
  TransferNotificationCounterParty.JSON_PROPERTY_BALANCE_ACCOUNT_ID,
  TransferNotificationCounterParty.JSON_PROPERTY_BANK_ACCOUNT,
  TransferNotificationCounterParty.JSON_PROPERTY_CARD,
  TransferNotificationCounterParty.JSON_PROPERTY_MERCHANT,
  TransferNotificationCounterParty.JSON_PROPERTY_TRANSFER_INSTRUMENT_ID
})

public class TransferNotificationCounterParty {
  public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
  private String balanceAccountId;

  public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
  private BankAccountV3 bankAccount;

  public static final String JSON_PROPERTY_CARD = "card";
  private Card card;

  public static final String JSON_PROPERTY_MERCHANT = "merchant";
  private TransferNotificationMerchantData merchant;

  public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
  private String transferInstrumentId;

  public TransferNotificationCounterParty() { 
  }

  /**
   * The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   *
   * @param balanceAccountId The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   * @return the current {@code TransferNotificationCounterParty} instance, allowing for method chaining
   */
  public TransferNotificationCounterParty balanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
    return this;
  }

  /**
   * The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   * @return balanceAccountId The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalanceAccountId() {
    return balanceAccountId;
  }

  /**
   * The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   *
   * @param balanceAccountId The unique identifier of the counterparty [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
  }

  /**
   * bankAccount
   *
   * @param bankAccount 
   * @return the current {@code TransferNotificationCounterParty} instance, allowing for method chaining
   */
  public TransferNotificationCounterParty bankAccount(BankAccountV3 bankAccount) {
    this.bankAccount = bankAccount;
    return this;
  }

  /**
   * Get bankAccount
   * @return bankAccount 
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BankAccountV3 getBankAccount() {
    return bankAccount;
  }

  /**
   * bankAccount
   *
   * @param bankAccount 
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccount(BankAccountV3 bankAccount) {
    this.bankAccount = bankAccount;
  }

  /**
   * card
   *
   * @param card 
   * @return the current {@code TransferNotificationCounterParty} instance, allowing for method chaining
   */
  public TransferNotificationCounterParty card(Card card) {
    this.card = card;
    return this;
  }

  /**
   * Get card
   * @return card 
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Card getCard() {
    return card;
  }

  /**
   * card
   *
   * @param card 
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCard(Card card) {
    this.card = card;
  }

  /**
   * merchant
   *
   * @param merchant 
   * @return the current {@code TransferNotificationCounterParty} instance, allowing for method chaining
   */
  public TransferNotificationCounterParty merchant(TransferNotificationMerchantData merchant) {
    this.merchant = merchant;
    return this;
  }

  /**
   * Get merchant
   * @return merchant 
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransferNotificationMerchantData getMerchant() {
    return merchant;
  }

  /**
   * merchant
   *
   * @param merchant 
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchant(TransferNotificationMerchantData merchant) {
    this.merchant = merchant;
  }

  /**
   * The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   *
   * @param transferInstrumentId The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   * @return the current {@code TransferNotificationCounterParty} instance, allowing for method chaining
   */
  public TransferNotificationCounterParty transferInstrumentId(String transferInstrumentId) {
    this.transferInstrumentId = transferInstrumentId;
    return this;
  }

  /**
   * The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   * @return transferInstrumentId The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTransferInstrumentId() {
    return transferInstrumentId;
  }

  /**
   * The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   *
   * @param transferInstrumentId The unique identifier of the counterparty [transfer instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments#responses-200-id).
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferInstrumentId(String transferInstrumentId) {
    this.transferInstrumentId = transferInstrumentId;
  }

  /**
   * Return true if this TransferNotificationCounterParty object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferNotificationCounterParty transferNotificationCounterParty = (TransferNotificationCounterParty) o;
    return Objects.equals(this.balanceAccountId, transferNotificationCounterParty.balanceAccountId) &&
        Objects.equals(this.bankAccount, transferNotificationCounterParty.bankAccount) &&
        Objects.equals(this.card, transferNotificationCounterParty.card) &&
        Objects.equals(this.merchant, transferNotificationCounterParty.merchant) &&
        Objects.equals(this.transferInstrumentId, transferNotificationCounterParty.transferInstrumentId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balanceAccountId, bankAccount, card, merchant, transferInstrumentId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferNotificationCounterParty {\n");
    sb.append("    balanceAccountId: ").append(toIndentedString(balanceAccountId)).append("\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    merchant: ").append(toIndentedString(merchant)).append("\n");
    sb.append("    transferInstrumentId: ").append(toIndentedString(transferInstrumentId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TransferNotificationCounterParty given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferNotificationCounterParty
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransferNotificationCounterParty
   */
  public static TransferNotificationCounterParty fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferNotificationCounterParty.class);
  }
/**
  * Convert an instance of TransferNotificationCounterParty to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
