/*
 * Payments App API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.paymentsapp.BoardingTokenRequest;
import com.adyen.model.paymentsapp.BoardingTokenResponse;
import com.adyen.model.paymentsapp.DefaultErrorResponseEntity;
import com.adyen.model.paymentsapp.PaymentsAppResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * The service has been moved to a different package 'com.adyen.service.paymentsapp.PaymentsAppApi'
 * @deprecated Use instead com.adyen.service.paymentsapp.PaymentsAppApi
 *
 */
@Deprecated(since = "v37.0.0", forRemoval = true)
public class PaymentsAppApi extends Service {

    public static final String API_VERSION = "1";

    protected String baseURL;

    /**
    * Default constructor in {@link com.adyen.service package}.
    * @param client {@link Client }  (required)
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-live.adyen.com/v1");
    }

    /**
    * Alternative constructor in {@link com.adyen.service package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client }  (required)
    * @param baseURL {@link String }  (required)
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Create a boarding token - merchant level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @return {@link BoardingTokenResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public BoardingTokenResponse generatePaymentsAppBoardingTokenForMerchant(String merchantId, BoardingTokenRequest boardingTokenRequest) throws ApiException, IOException {
        return generatePaymentsAppBoardingTokenForMerchant(merchantId, boardingTokenRequest, null);
    }

    /**
    * Create a boarding token - merchant level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link BoardingTokenResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public BoardingTokenResponse generatePaymentsAppBoardingTokenForMerchant(String merchantId, BoardingTokenRequest boardingTokenRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);

        String requestBody = boardingTokenRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/generatePaymentsAppBoardingToken", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return BoardingTokenResponse.fromJson(jsonResult);
    }

    /**
    * Create a boarding token - store level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @return {@link BoardingTokenResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public BoardingTokenResponse generatePaymentsAppBoardingTokenForStore(String merchantId, String storeId, BoardingTokenRequest boardingTokenRequest) throws ApiException, IOException {
        return generatePaymentsAppBoardingTokenForStore(merchantId, storeId, boardingTokenRequest, null);
    }

    /**
    * Create a boarding token - store level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param boardingTokenRequest {@link BoardingTokenRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link BoardingTokenResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public BoardingTokenResponse generatePaymentsAppBoardingTokenForStore(String merchantId, String storeId, BoardingTokenRequest boardingTokenRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);

        String requestBody = boardingTokenRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}/generatePaymentsAppBoardingToken", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return BoardingTokenResponse.fromJson(jsonResult);
    }

    /**
    * Get a list of Payments Apps - merchant level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @return {@link PaymentsAppResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppResponse listPaymentsAppForMerchant(String merchantId) throws ApiException, IOException {
        return listPaymentsAppForMerchant(merchantId, null,  null,  null,  null);
    }

    /**
    * Get a list of Payments Apps - merchant level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param statuses {@link String } Query: The status of the Payments App. Comma-separated list of one or more values. If no value is provided, the list returns all statuses.   Possible values:  * **BOARDING**   * **BOARDED**   * **REVOKED** (optional)
    * @param limit {@link Integer } Query: The number of items to return. (optional, default to 10)
    * @param offset {@link Long } Query: The number of items to skip. (optional, default to 0)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentsAppResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppResponse listPaymentsAppForMerchant(String merchantId, String statuses, Integer limit, Long offset, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (statuses != null) {
        queryParams.put("statuses", statuses);
        }
        if (limit != null) {
        queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
        queryParams.put("offset", offset.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentsApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentsAppResponse.fromJson(jsonResult);
    }

    /**
    * Get a list of Payments Apps - store level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @return {@link PaymentsAppResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppResponse listPaymentsAppForStore(String merchantId, String storeId) throws ApiException, IOException {
        return listPaymentsAppForStore(merchantId, storeId, null,  null,  null,  null);
    }

    /**
    * Get a list of Payments Apps - store level
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param storeId {@link String } The unique identifier of the store. (required)
    * @param statuses {@link String } Query: The status of the Payments App. Comma-separated list of one or more values. If no value is provided, the list returns all statuses.   Possible values:  * **BOARDING**   * **BOARDED**   * **REVOKED** (optional)
    * @param limit {@link Integer } Query: The number of items to return. (optional, default to 10)
    * @param offset {@link Long } Query: The number of items to skip. (optional, default to 0)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentsAppResponse }
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public PaymentsAppResponse listPaymentsAppForStore(String merchantId, String storeId, String statuses, Integer limit, Long offset, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (statuses != null) {
        queryParams.put("statuses", statuses);
        }
        if (limit != null) {
        queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
        queryParams.put("offset", offset.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}/paymentsApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentsAppResponse.fromJson(jsonResult);
    }

    /**
    * Revoke Payments App instance authentication
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param installationId {@link String } The unique identifier of the Payments App instance on a device. (required)
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public void revokePaymentsApp(String merchantId, String installationId) throws ApiException, IOException {
        revokePaymentsApp(merchantId, installationId, null);
    }

    /**
    * Revoke Payments App instance authentication
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param installationId {@link String } The unique identifier of the Payments App instance on a device. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    @Deprecated(since = "v37.0.0", forRemoval = true) // Use instead com.adyen.service.paymentsapp.PaymentsAppApi
    public void revokePaymentsApp(String merchantId, String installationId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (installationId == null) {
            throw new IllegalArgumentException("Please provide the installationId path parameter");
        }
        pathParams.put("installationId", installationId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentsApps/{installationId}/revoke", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }
}
