/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.AndroidApp;
import com.adyen.model.management.AndroidAppsResponse;
import com.adyen.model.management.AndroidCertificatesResponse;
import com.adyen.model.management.ReprocessAndroidAppResponse;
import com.adyen.model.management.RestServiceError;
import com.adyen.model.management.UploadAndroidAppResponse;
import com.adyen.model.management.UploadAndroidCertificateResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AndroidFilesCompanyLevelApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Android files - company level constructor in {@link com.adyen.service.management package}.
    * @param client {@link Client } (required)
    */
    public AndroidFilesCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-test.adyen.com/v3");
    }

    /**
    * Android files - company level constructor in {@link com.adyen.service.management package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public AndroidFilesCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Get Android app
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param id {@link String } The unique identifier of the app. (required)
    * @return {@link AndroidApp }
    * @throws ApiException if fails to make API call
    */
    public AndroidApp getAndroidApp(String companyId, String id) throws ApiException, IOException {
        return getAndroidApp(companyId, id, null);
    }

    /**
    * Get Android app
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param id {@link String } The unique identifier of the app. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AndroidApp }
    * @throws ApiException if fails to make API call
    */
    public AndroidApp getAndroidApp(String companyId, String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AndroidApp.fromJson(jsonResult);
    }

    /**
    * Get a list of Android apps
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link AndroidAppsResponse }
    * @throws ApiException if fails to make API call
    */
    public AndroidAppsResponse listAndroidApps(String companyId) throws ApiException, IOException {
        return listAndroidApps(companyId, null,  null,  null,  null,  null);
    }

    /**
    * Get a list of Android apps
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 20 items on a page. (optional)
    * @param packageName {@link String } Query: The package name that uniquely identifies the Android app. (optional)
    * @param versionCode {@link Integer } Query: The version number of the app. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AndroidAppsResponse }
    * @throws ApiException if fails to make API call
    */
    public AndroidAppsResponse listAndroidApps(String companyId, Integer pageNumber, Integer pageSize, String packageName, Integer versionCode, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);

        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }
        if (packageName != null) {
        queryParams.put("packageName", packageName);
        }
        if (versionCode != null) {
        queryParams.put("versionCode", versionCode.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidAppsResponse.fromJson(jsonResult);
    }

    /**
    * Get a list of Android certificates
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link AndroidCertificatesResponse }
    * @throws ApiException if fails to make API call
    */
    public AndroidCertificatesResponse listAndroidCertificates(String companyId) throws ApiException, IOException {
        return listAndroidCertificates(companyId, null,  null,  null,  null);
    }

    /**
    * Get a list of Android certificates
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 20 items on a page. (optional)
    * @param certificateName {@link String } Query: The name of the certificate. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AndroidCertificatesResponse }
    * @throws ApiException if fails to make API call
    */
    public AndroidCertificatesResponse listAndroidCertificates(String companyId, Integer pageNumber, Integer pageSize, String certificateName, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);

        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }
        if (certificateName != null) {
        queryParams.put("certificateName", certificateName);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidCertificates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidCertificatesResponse.fromJson(jsonResult);
    }

    /**
    * Reprocess Android App
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param id {@link String } The unique identifier of the app. (required)
    * @return {@link ReprocessAndroidAppResponse }
    * @throws ApiException if fails to make API call
    */
    public ReprocessAndroidAppResponse reprocessAndroidApp(String companyId, String id) throws ApiException, IOException {
        return reprocessAndroidApp(companyId, id, null);
    }

    /**
    * Reprocess Android App
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param id {@link String } The unique identifier of the app. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ReprocessAndroidAppResponse }
    * @throws ApiException if fails to make API call
    */
    public ReprocessAndroidAppResponse reprocessAndroidApp(String companyId, String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return ReprocessAndroidAppResponse.fromJson(jsonResult);
    }

    /**
    * Upload Android App
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link UploadAndroidAppResponse }
    * @throws ApiException if fails to make API call
    */
    public UploadAndroidAppResponse uploadAndroidApp(String companyId) throws ApiException, IOException {
        return uploadAndroidApp(companyId, null);
    }

    /**
    * Upload Android App
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link UploadAndroidAppResponse }
    * @throws ApiException if fails to make API call
    */
    public UploadAndroidAppResponse uploadAndroidApp(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return UploadAndroidAppResponse.fromJson(jsonResult);
    }

    /**
    * Upload Android Certificate
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link UploadAndroidCertificateResponse }
    * @throws ApiException if fails to make API call
    */
    public UploadAndroidCertificateResponse uploadAndroidCertificate(String companyId) throws ApiException, IOException {
        return uploadAndroidCertificate(companyId, null);
    }

    /**
    * Upload Android Certificate
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link UploadAndroidCertificateResponse }
    * @throws ApiException if fails to make API call
    */
    public UploadAndroidCertificateResponse uploadAndroidCertificate(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidCertificates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return UploadAndroidCertificateResponse.fromJson(jsonResult);
    }
}
