/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.payment;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.payment.AuthenticationResultRequest;
import com.adyen.model.payment.AuthenticationResultResponse;
import com.adyen.model.payment.PaymentRequest;
import com.adyen.model.payment.PaymentRequest3d;
import com.adyen.model.payment.PaymentRequest3ds2;
import com.adyen.model.payment.PaymentResult;
import com.adyen.model.payment.ServiceError;
import com.adyen.model.payment.ThreeDS2ResultRequest;
import com.adyen.model.payment.ThreeDS2ResultResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentsApi extends Service {

    public static final String API_VERSION = "68";

    protected String baseURL;

    /**
    * Payments constructor in {@link com.adyen.service.payment package}.
    * @param client {@link Client } (required)
    */
    public PaymentsApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/Payment/v68");
    }

    /**
    * Payments constructor in {@link com.adyen.service.payment package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public PaymentsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Create an authorisation
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise(PaymentRequest paymentRequest) throws ApiException, IOException {
        return authorise(paymentRequest, null);
    }

    /**
    * Create an authorisation
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Complete a 3DS authorisation
    *
    * @param paymentRequest3d {@link PaymentRequest3d }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d) throws ApiException, IOException {
        return authorise3d(paymentRequest3d, null);
    }

    /**
    * Complete a 3DS authorisation
    *
    * @param paymentRequest3d {@link PaymentRequest3d }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest3d.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3d", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Complete a 3DS2 authorisation
    *
    * @param paymentRequest3ds2 {@link PaymentRequest3ds2 }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2) throws ApiException, IOException {
        return authorise3ds2(paymentRequest3ds2, null);
    }

    /**
    * Complete a 3DS2 authorisation
    *
    * @param paymentRequest3ds2 {@link PaymentRequest3ds2 }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest3ds2.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3ds2", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Get the 3DS authentication result
    *
    * @param authenticationResultRequest {@link AuthenticationResultRequest }  (required)
    * @return {@link AuthenticationResultResponse }
    * @throws ApiException if fails to make API call
    */
    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest) throws ApiException, IOException {
        return getAuthenticationResult(authenticationResultRequest, null);
    }

    /**
    * Get the 3DS authentication result
    *
    * @param authenticationResultRequest {@link AuthenticationResultRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AuthenticationResultResponse }
    * @throws ApiException if fails to make API call
    */
    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = authenticationResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/getAuthenticationResult", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AuthenticationResultResponse.fromJson(jsonResult);
    }

    /**
    * Get the 3DS2 authentication result
    *
    * @param threeDS2ResultRequest {@link ThreeDS2ResultRequest }  (required)
    * @return {@link ThreeDS2ResultResponse }
    * @throws ApiException if fails to make API call
    */
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest) throws ApiException, IOException {
        return retrieve3ds2Result(threeDS2ResultRequest, null);
    }

    /**
    * Get the 3DS2 authentication result
    *
    * @param threeDS2ResultRequest {@link ThreeDS2ResultRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ThreeDS2ResultResponse }
    * @throws ApiException if fails to make API call
    */
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = threeDS2ResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/retrieve3ds2Result", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ThreeDS2ResultResponse.fromJson(jsonResult);
    }
}
