/*
 * Adyen Stored Value API
 *
 * The version of the OpenAPI document: 46
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.storedvalue;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.storedvalue.ServiceError;
import com.adyen.model.storedvalue.StoredValueBalanceCheckRequest;
import com.adyen.model.storedvalue.StoredValueBalanceCheckResponse;
import com.adyen.model.storedvalue.StoredValueBalanceMergeRequest;
import com.adyen.model.storedvalue.StoredValueBalanceMergeResponse;
import com.adyen.model.storedvalue.StoredValueIssueRequest;
import com.adyen.model.storedvalue.StoredValueIssueResponse;
import com.adyen.model.storedvalue.StoredValueLoadRequest;
import com.adyen.model.storedvalue.StoredValueLoadResponse;
import com.adyen.model.storedvalue.StoredValueStatusChangeRequest;
import com.adyen.model.storedvalue.StoredValueStatusChangeResponse;
import com.adyen.model.storedvalue.StoredValueVoidRequest;
import com.adyen.model.storedvalue.StoredValueVoidResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StoredValueApi extends Service {

    public static final String API_VERSION = "46";

    protected String baseURL;

    /**
    * StoredValue constructor in {@link com.adyen.service.storedvalue package}.
    * @param client {@link Client } (required)
    */
    public StoredValueApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/StoredValue/v46");
    }

    /**
    * StoredValue constructor in {@link com.adyen.service.storedvalue package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public StoredValueApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Changes the status of the payment method.
    *
    * @param storedValueStatusChangeRequest {@link StoredValueStatusChangeRequest }  (required)
    * @return {@link StoredValueStatusChangeResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueStatusChangeResponse changeStatus(StoredValueStatusChangeRequest storedValueStatusChangeRequest) throws ApiException, IOException {
        return changeStatus(storedValueStatusChangeRequest, null);
    }

    /**
    * Changes the status of the payment method.
    *
    * @param storedValueStatusChangeRequest {@link StoredValueStatusChangeRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueStatusChangeResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueStatusChangeResponse changeStatus(StoredValueStatusChangeRequest storedValueStatusChangeRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueStatusChangeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/changeStatus", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueStatusChangeResponse.fromJson(jsonResult);
    }

    /**
    * Checks the balance.
    *
    * @param storedValueBalanceCheckRequest {@link StoredValueBalanceCheckRequest }  (required)
    * @return {@link StoredValueBalanceCheckResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueBalanceCheckResponse checkBalance(StoredValueBalanceCheckRequest storedValueBalanceCheckRequest) throws ApiException, IOException {
        return checkBalance(storedValueBalanceCheckRequest, null);
    }

    /**
    * Checks the balance.
    *
    * @param storedValueBalanceCheckRequest {@link StoredValueBalanceCheckRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueBalanceCheckResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueBalanceCheckResponse checkBalance(StoredValueBalanceCheckRequest storedValueBalanceCheckRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueBalanceCheckRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/checkBalance", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueBalanceCheckResponse.fromJson(jsonResult);
    }

    /**
    * Issues a new card.
    *
    * @param storedValueIssueRequest {@link StoredValueIssueRequest }  (required)
    * @return {@link StoredValueIssueResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueIssueResponse issue(StoredValueIssueRequest storedValueIssueRequest) throws ApiException, IOException {
        return issue(storedValueIssueRequest, null);
    }

    /**
    * Issues a new card.
    *
    * @param storedValueIssueRequest {@link StoredValueIssueRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueIssueResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueIssueResponse issue(StoredValueIssueRequest storedValueIssueRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueIssueRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/issue", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueIssueResponse.fromJson(jsonResult);
    }

    /**
    * Loads the payment method.
    *
    * @param storedValueLoadRequest {@link StoredValueLoadRequest }  (required)
    * @return {@link StoredValueLoadResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueLoadResponse load(StoredValueLoadRequest storedValueLoadRequest) throws ApiException, IOException {
        return load(storedValueLoadRequest, null);
    }

    /**
    * Loads the payment method.
    *
    * @param storedValueLoadRequest {@link StoredValueLoadRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueLoadResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueLoadResponse load(StoredValueLoadRequest storedValueLoadRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueLoadRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/load", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueLoadResponse.fromJson(jsonResult);
    }

    /**
    * Merge the balance of two cards.
    *
    * @param storedValueBalanceMergeRequest {@link StoredValueBalanceMergeRequest }  (required)
    * @return {@link StoredValueBalanceMergeResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueBalanceMergeResponse mergeBalance(StoredValueBalanceMergeRequest storedValueBalanceMergeRequest) throws ApiException, IOException {
        return mergeBalance(storedValueBalanceMergeRequest, null);
    }

    /**
    * Merge the balance of two cards.
    *
    * @param storedValueBalanceMergeRequest {@link StoredValueBalanceMergeRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueBalanceMergeResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueBalanceMergeResponse mergeBalance(StoredValueBalanceMergeRequest storedValueBalanceMergeRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueBalanceMergeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/mergeBalance", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueBalanceMergeResponse.fromJson(jsonResult);
    }

    /**
    * Voids a transaction.
    *
    * @param storedValueVoidRequest {@link StoredValueVoidRequest }  (required)
    * @return {@link StoredValueVoidResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueVoidResponse voidTransaction(StoredValueVoidRequest storedValueVoidRequest) throws ApiException, IOException {
        return voidTransaction(storedValueVoidRequest, null);
    }

    /**
    * Voids a transaction.
    *
    * @param storedValueVoidRequest {@link StoredValueVoidRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link StoredValueVoidResponse }
    * @throws ApiException if fails to make API call
    */
    public StoredValueVoidResponse voidTransaction(StoredValueVoidRequest storedValueVoidRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storedValueVoidRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/voidTransaction", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StoredValueVoidResponse.fromJson(jsonResult);
    }
}
