/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Duration */
@JsonPropertyOrder({Duration.JSON_PROPERTY_UNIT, Duration.JSON_PROPERTY_VALUE})
public class Duration {
  /**
   * The unit of time. You can only use **minutes** and **hours** if the &#x60;interval.type&#x60;
   * is **sliding**. Possible values: **minutes**, **hours**, **days**, **weeks**, or **months**
   */
  public enum UnitEnum {
    DAYS(String.valueOf("days")),

    HOURS(String.valueOf("hours")),

    MINUTES(String.valueOf("minutes")),

    MONTHS(String.valueOf("months")),

    WEEKS(String.valueOf("weeks"));

    private String value;

    UnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UnitEnum fromValue(String value) {
      for (UnitEnum b : UnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UNIT = "unit";
  private UnitEnum unit;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Integer value;

  public Duration() {}

  /**
   * The unit of time. You can only use **minutes** and **hours** if the &#x60;interval.type&#x60;
   * is **sliding**. Possible values: **minutes**, **hours**, **days**, **weeks**, or **months**
   *
   * @param unit The unit of time. You can only use **minutes** and **hours** if the
   *     &#x60;interval.type&#x60; is **sliding**. Possible values: **minutes**, **hours**,
   *     **days**, **weeks**, or **months**
   * @return the current {@code Duration} instance, allowing for method chaining
   */
  public Duration unit(UnitEnum unit) {
    this.unit = unit;
    return this;
  }

  /**
   * The unit of time. You can only use **minutes** and **hours** if the &#x60;interval.type&#x60;
   * is **sliding**. Possible values: **minutes**, **hours**, **days**, **weeks**, or **months**
   *
   * @return unit The unit of time. You can only use **minutes** and **hours** if the
   *     &#x60;interval.type&#x60; is **sliding**. Possible values: **minutes**, **hours**,
   *     **days**, **weeks**, or **months**
   */
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public UnitEnum getUnit() {
    return unit;
  }

  /**
   * The unit of time. You can only use **minutes** and **hours** if the &#x60;interval.type&#x60;
   * is **sliding**. Possible values: **minutes**, **hours**, **days**, **weeks**, or **months**
   *
   * @param unit The unit of time. You can only use **minutes** and **hours** if the
   *     &#x60;interval.type&#x60; is **sliding**. Possible values: **minutes**, **hours**,
   *     **days**, **weeks**, or **months**
   */
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(UnitEnum unit) {
    this.unit = unit;
  }

  /**
   * The length of time by the unit. For example, 5 days. The maximum duration is 90 days or an
   * equivalent in other units. For example, 3 months.
   *
   * @param value The length of time by the unit. For example, 5 days. The maximum duration is 90
   *     days or an equivalent in other units. For example, 3 months.
   * @return the current {@code Duration} instance, allowing for method chaining
   */
  public Duration value(Integer value) {
    this.value = value;
    return this;
  }

  /**
   * The length of time by the unit. For example, 5 days. The maximum duration is 90 days or an
   * equivalent in other units. For example, 3 months.
   *
   * @return value The length of time by the unit. For example, 5 days. The maximum duration is 90
   *     days or an equivalent in other units. For example, 3 months.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getValue() {
    return value;
  }

  /**
   * The length of time by the unit. For example, 5 days. The maximum duration is 90 days or an
   * equivalent in other units. For example, 3 months.
   *
   * @param value The length of time by the unit. For example, 5 days. The maximum duration is 90
   *     days or an equivalent in other units. For example, 3 months.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Integer value) {
    this.value = value;
  }

  /** Return true if this Duration object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Duration duration = (Duration) o;
    return Objects.equals(this.unit, duration.unit) && Objects.equals(this.value, duration.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(unit, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Duration {\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Duration given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Duration
   * @throws JsonProcessingException if the JSON string is invalid with respect to Duration
   */
  public static Duration fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Duration.class);
  }

  /**
   * Convert an instance of Duration to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
