/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Phone */
@JsonPropertyOrder({Phone.JSON_PROPERTY_NUMBER, Phone.JSON_PROPERTY_TYPE})
public class Phone {
  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  /** Type of phone number. Possible values: **Landline**, **Mobile**. */
  public enum TypeEnum {
    LANDLINE(String.valueOf("landline")),

    MOBILE(String.valueOf("mobile"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public Phone() {}

  /**
   * The full phone number provided as a single string. For example, **\&quot;0031 6 11 22 33
   * 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031) 611223344\&quot;**.
   *
   * @param number The full phone number provided as a single string. For example, **\&quot;0031 6
   *     11 22 33 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031)
   *     611223344\&quot;**.
   * @return the current {@code Phone} instance, allowing for method chaining
   */
  public Phone number(String number) {
    this.number = number;
    return this;
  }

  /**
   * The full phone number provided as a single string. For example, **\&quot;0031 6 11 22 33
   * 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031) 611223344\&quot;**.
   *
   * @return number The full phone number provided as a single string. For example, **\&quot;0031 6
   *     11 22 33 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031)
   *     611223344\&quot;**.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNumber() {
    return number;
  }

  /**
   * The full phone number provided as a single string. For example, **\&quot;0031 6 11 22 33
   * 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031) 611223344\&quot;**.
   *
   * @param number The full phone number provided as a single string. For example, **\&quot;0031 6
   *     11 22 33 44\&quot;**, **\&quot;+316/1122-3344\&quot;**, or **\&quot;(0031)
   *     611223344\&quot;**.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }

  /**
   * Type of phone number. Possible values: **Landline**, **Mobile**.
   *
   * @param type Type of phone number. Possible values: **Landline**, **Mobile**.
   * @return the current {@code Phone} instance, allowing for method chaining
   */
  public Phone type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of phone number. Possible values: **Landline**, **Mobile**.
   *
   * @return type Type of phone number. Possible values: **Landline**, **Mobile**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of phone number. Possible values: **Landline**, **Mobile**.
   *
   * @param type Type of phone number. Possible values: **Landline**, **Mobile**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this Phone object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Phone phone = (Phone) o;
    return Objects.equals(this.number, phone.number) && Objects.equals(this.type, phone.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Phone {\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Phone given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Phone
   * @throws JsonProcessingException if the JSON string is invalid with respect to Phone
   */
  public static Phone fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Phone.class);
  }

  /**
   * Convert an instance of Phone to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
