/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(
    using = TransferRouteRequirementsInner.TransferRouteRequirementsInnerDeserializer.class)
@JsonSerialize(
    using = TransferRouteRequirementsInner.TransferRouteRequirementsInnerSerializer.class)
public class TransferRouteRequirementsInner extends AbstractOpenApiSchema {
  private static final Logger log =
      Logger.getLogger(TransferRouteRequirementsInner.class.getName());

  public static class TransferRouteRequirementsInnerSerializer
      extends StdSerializer<TransferRouteRequirementsInner> {
    public TransferRouteRequirementsInnerSerializer(Class<TransferRouteRequirementsInner> t) {
      super(t);
    }

    public TransferRouteRequirementsInnerSerializer() {
      this(null);
    }

    @Override
    public void serialize(
        TransferRouteRequirementsInner value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.getActualInstance());
    }
  }

  public static class TransferRouteRequirementsInnerDeserializer
      extends StdDeserializer<TransferRouteRequirementsInner> {
    public TransferRouteRequirementsInnerDeserializer() {
      this(TransferRouteRequirementsInner.class);
    }

    public TransferRouteRequirementsInnerDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public TransferRouteRequirementsInner deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {
      JsonNode tree = jp.readValueAsTree();
      Object deserialized = null;
      boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
      int match = 0;
      JsonToken token = tree.traverse(jp.getCodec()).nextToken();
      // deserialize AddressRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(AddressRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(AddressRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'AddressRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'AddressRequirement'", e);
      }

      // deserialize AmountMinMaxRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(AmountMinMaxRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(AmountMinMaxRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'AmountMinMaxRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'AmountMinMaxRequirement'", e);
      }

      // deserialize AmountNonZeroDecimalsRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(AmountNonZeroDecimalsRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec()).readValueAs(AmountNonZeroDecimalsRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'AmountNonZeroDecimalsRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER, "Input data does not match schema 'AmountNonZeroDecimalsRequirement'", e);
      }

      // deserialize BankAccountIdentificationTypeRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(BankAccountIdentificationTypeRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec())
                    .readValueAs(BankAccountIdentificationTypeRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(
                Level.FINER,
                "Input data matches schema 'BankAccountIdentificationTypeRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'BankAccountIdentificationTypeRequirement'",
            e);
      }

      // deserialize IbanAccountIdentificationRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(IbanAccountIdentificationRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec())
                    .readValueAs(IbanAccountIdentificationRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(
                Level.FINER, "Input data matches schema 'IbanAccountIdentificationRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'IbanAccountIdentificationRequirement'",
            e);
      }

      // deserialize PaymentInstrumentRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(PaymentInstrumentRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec()).readValueAs(PaymentInstrumentRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'PaymentInstrumentRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'PaymentInstrumentRequirement'", e);
      }

      // deserialize USInstantPayoutAddressRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(USInstantPayoutAddressRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec()).readValueAs(USInstantPayoutAddressRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'USInstantPayoutAddressRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER, "Input data does not match schema 'USInstantPayoutAddressRequirement'", e);
      }

      // deserialize USInternationalAchAddressRequirement
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(USInternationalAchAddressRequirement.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized =
                tree.traverse(jp.getCodec())
                    .readValueAs(USInternationalAchAddressRequirement.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(
                Level.FINER, "Input data matches schema 'USInternationalAchAddressRequirement'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'USInternationalAchAddressRequirement'",
            e);
      }

      if (match == 1) {
        TransferRouteRequirementsInner ret = new TransferRouteRequirementsInner();
        ret.setActualInstance(deserialized);
        return ret;
      }
      throw new IOException(
          String.format(
              "Failed deserialization for TransferRouteRequirementsInner: %d classes match result, expected 1",
              match));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public TransferRouteRequirementsInner getNullValue(DeserializationContext ctxt)
        throws JsonMappingException {
      throw new JsonMappingException(
          ctxt.getParser(), "TransferRouteRequirementsInner cannot be null");
    }
  }

  // store a list of schema names defined in oneOf
  public static final Map<String, GenericType<?>> schemas = new HashMap<>();

  public TransferRouteRequirementsInner() {
    super("oneOf", Boolean.FALSE);
  }

  public TransferRouteRequirementsInner(AddressRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(AmountMinMaxRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(AmountNonZeroDecimalsRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(BankAccountIdentificationTypeRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(IbanAccountIdentificationRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(PaymentInstrumentRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(USInstantPayoutAddressRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferRouteRequirementsInner(USInternationalAchAddressRequirement o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  static {
    schemas.put("AddressRequirement", new GenericType<AddressRequirement>() {});
    schemas.put("AmountMinMaxRequirement", new GenericType<AmountMinMaxRequirement>() {});
    schemas.put(
        "AmountNonZeroDecimalsRequirement", new GenericType<AmountNonZeroDecimalsRequirement>() {});
    schemas.put(
        "BankAccountIdentificationTypeRequirement",
        new GenericType<BankAccountIdentificationTypeRequirement>() {});
    schemas.put(
        "IbanAccountIdentificationRequirement",
        new GenericType<IbanAccountIdentificationRequirement>() {});
    schemas.put("PaymentInstrumentRequirement", new GenericType<PaymentInstrumentRequirement>() {});
    schemas.put(
        "USInstantPayoutAddressRequirement",
        new GenericType<USInstantPayoutAddressRequirement>() {});
    schemas.put(
        "USInternationalAchAddressRequirement",
        new GenericType<USInternationalAchAddressRequirement>() {});
    JSON.registerDescendants(
        TransferRouteRequirementsInner.class, Collections.unmodifiableMap(schemas));
  }

  @Override
  public Map<String, GenericType<?>> getSchemas() {
    return TransferRouteRequirementsInner.schemas;
  }

  /**
   * Set the instance that matches the oneOf child schema, check the instance parameter is valid
   * against the oneOf child schemas: AddressRequirement, AmountMinMaxRequirement,
   * AmountNonZeroDecimalsRequirement, BankAccountIdentificationTypeRequirement,
   * IbanAccountIdentificationRequirement, PaymentInstrumentRequirement,
   * USInstantPayoutAddressRequirement, USInternationalAchAddressRequirement
   *
   * <p>It could be an instance of the 'oneOf' schemas. The oneOf child schemas may themselves be a
   * composed schema (allOf, anyOf, oneOf).
   */
  @Override
  public void setActualInstance(Object instance) {
    if (JSON.isInstanceOf(AddressRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(AmountMinMaxRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(AmountNonZeroDecimalsRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(
        BankAccountIdentificationTypeRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(IbanAccountIdentificationRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(PaymentInstrumentRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(USInstantPayoutAddressRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(USInternationalAchAddressRequirement.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    throw new RuntimeException(
        "Invalid instance type. Must be AddressRequirement, AmountMinMaxRequirement, AmountNonZeroDecimalsRequirement, BankAccountIdentificationTypeRequirement, IbanAccountIdentificationRequirement, PaymentInstrumentRequirement, USInstantPayoutAddressRequirement, USInternationalAchAddressRequirement");
  }

  /**
   * Get the actual instance, which can be the following: AddressRequirement,
   * AmountMinMaxRequirement, AmountNonZeroDecimalsRequirement,
   * BankAccountIdentificationTypeRequirement, IbanAccountIdentificationRequirement,
   * PaymentInstrumentRequirement, USInstantPayoutAddressRequirement,
   * USInternationalAchAddressRequirement
   *
   * @return The actual instance (AddressRequirement, AmountMinMaxRequirement,
   *     AmountNonZeroDecimalsRequirement, BankAccountIdentificationTypeRequirement,
   *     IbanAccountIdentificationRequirement, PaymentInstrumentRequirement,
   *     USInstantPayoutAddressRequirement, USInternationalAchAddressRequirement)
   */
  @Override
  public Object getActualInstance() {
    return super.getActualInstance();
  }

  /**
   * Get the actual instance of `AddressRequirement`. If the actual instance is not
   * `AddressRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `AddressRequirement`
   * @throws ClassCastException if the instance is not `AddressRequirement`
   */
  public AddressRequirement getAddressRequirement() throws ClassCastException {
    return (AddressRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `AmountMinMaxRequirement`. If the actual instance is not
   * `AmountMinMaxRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `AmountMinMaxRequirement`
   * @throws ClassCastException if the instance is not `AmountMinMaxRequirement`
   */
  public AmountMinMaxRequirement getAmountMinMaxRequirement() throws ClassCastException {
    return (AmountMinMaxRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `AmountNonZeroDecimalsRequirement`. If the actual instance is not
   * `AmountNonZeroDecimalsRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `AmountNonZeroDecimalsRequirement`
   * @throws ClassCastException if the instance is not `AmountNonZeroDecimalsRequirement`
   */
  public AmountNonZeroDecimalsRequirement getAmountNonZeroDecimalsRequirement()
      throws ClassCastException {
    return (AmountNonZeroDecimalsRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `BankAccountIdentificationTypeRequirement`. If the actual instance
   * is not `BankAccountIdentificationTypeRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `BankAccountIdentificationTypeRequirement`
   * @throws ClassCastException if the instance is not `BankAccountIdentificationTypeRequirement`
   */
  public BankAccountIdentificationTypeRequirement getBankAccountIdentificationTypeRequirement()
      throws ClassCastException {
    return (BankAccountIdentificationTypeRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `IbanAccountIdentificationRequirement`. If the actual instance is
   * not `IbanAccountIdentificationRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `IbanAccountIdentificationRequirement`
   * @throws ClassCastException if the instance is not `IbanAccountIdentificationRequirement`
   */
  public IbanAccountIdentificationRequirement getIbanAccountIdentificationRequirement()
      throws ClassCastException {
    return (IbanAccountIdentificationRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `PaymentInstrumentRequirement`. If the actual instance is not
   * `PaymentInstrumentRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `PaymentInstrumentRequirement`
   * @throws ClassCastException if the instance is not `PaymentInstrumentRequirement`
   */
  public PaymentInstrumentRequirement getPaymentInstrumentRequirement() throws ClassCastException {
    return (PaymentInstrumentRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `USInstantPayoutAddressRequirement`. If the actual instance is not
   * `USInstantPayoutAddressRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `USInstantPayoutAddressRequirement`
   * @throws ClassCastException if the instance is not `USInstantPayoutAddressRequirement`
   */
  public USInstantPayoutAddressRequirement getUSInstantPayoutAddressRequirement()
      throws ClassCastException {
    return (USInstantPayoutAddressRequirement) super.getActualInstance();
  }

  /**
   * Get the actual instance of `USInternationalAchAddressRequirement`. If the actual instance is
   * not `USInternationalAchAddressRequirement`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `USInternationalAchAddressRequirement`
   * @throws ClassCastException if the instance is not `USInternationalAchAddressRequirement`
   */
  public USInternationalAchAddressRequirement getUSInternationalAchAddressRequirement()
      throws ClassCastException {
    return (USInternationalAchAddressRequirement) super.getActualInstance();
  }

  /**
   * Create an instance of TransferRouteRequirementsInner given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferRouteRequirementsInner
   * @throws IOException if the JSON string is invalid with respect to
   *     TransferRouteRequirementsInner
   */
  public static TransferRouteRequirementsInner fromJson(String jsonString) throws IOException {
    return JSON.getMapper().readValue(jsonString, TransferRouteRequirementsInner.class);
  }

  /**
   * Convert an instance of TransferRouteRequirementsInner to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
