/*
 * Balance webhook
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balancewebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** BalanceNotificationData */
@JsonPropertyOrder({
  BalanceNotificationData.JSON_PROPERTY_BALANCE_ACCOUNT_ID,
  BalanceNotificationData.JSON_PROPERTY_BALANCE_PLATFORM,
  BalanceNotificationData.JSON_PROPERTY_BALANCES,
  BalanceNotificationData.JSON_PROPERTY_CREATION_DATE,
  BalanceNotificationData.JSON_PROPERTY_CURRENCY,
  BalanceNotificationData.JSON_PROPERTY_ID,
  BalanceNotificationData.JSON_PROPERTY_SETTING_IDS
})
public class BalanceNotificationData {
  public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
  private String balanceAccountId;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_BALANCES = "balances";
  private Balances balances;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_SETTING_IDS = "settingIds";
  private List<String> settingIds;

  public BalanceNotificationData() {}

  @JsonCreator
  public BalanceNotificationData(@JsonProperty(JSON_PROPERTY_ID) String id) {
    this();
    this.id = id;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @param balanceAccountId The unique identifier of the balance account.
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData balanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
    return this;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @return balanceAccountId The unique identifier of the balance account.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalanceAccountId() {
    return balanceAccountId;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @param balanceAccountId The unique identifier of the balance account.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @return balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalancePlatform() {
    return balancePlatform;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }

  /**
   * balances
   *
   * @param balances
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData balances(Balances balances) {
    this.balances = balances;
    return this;
  }

  /**
   * Get balances
   *
   * @return balances
   */
  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Balances getBalances() {
    return balances;
  }

  /**
   * balances
   *
   * @param balances
   */
  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalances(Balances balances) {
    this.balances = balances;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData creationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @return creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreationDate() {
    return creationDate;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }

  /**
   * TThe three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param currency TThe three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes).
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * TThe three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @return currency TThe three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes).
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * TThe three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes).
   *
   * @param currency TThe three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes).
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * The ID of the resource.
   *
   * @return id The ID of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the balance webhook setting.
   *
   * @param settingIds The unique identifier of the balance webhook setting.
   * @return the current {@code BalanceNotificationData} instance, allowing for method chaining
   */
  public BalanceNotificationData settingIds(List<String> settingIds) {
    this.settingIds = settingIds;
    return this;
  }

  public BalanceNotificationData addSettingIdsItem(String settingIdsItem) {
    if (this.settingIds == null) {
      this.settingIds = new ArrayList<>();
    }
    this.settingIds.add(settingIdsItem);
    return this;
  }

  /**
   * The unique identifier of the balance webhook setting.
   *
   * @return settingIds The unique identifier of the balance webhook setting.
   */
  @JsonProperty(JSON_PROPERTY_SETTING_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getSettingIds() {
    return settingIds;
  }

  /**
   * The unique identifier of the balance webhook setting.
   *
   * @param settingIds The unique identifier of the balance webhook setting.
   */
  @JsonProperty(JSON_PROPERTY_SETTING_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettingIds(List<String> settingIds) {
    this.settingIds = settingIds;
  }

  /** Return true if this BalanceNotificationData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceNotificationData balanceNotificationData = (BalanceNotificationData) o;
    return Objects.equals(this.balanceAccountId, balanceNotificationData.balanceAccountId)
        && Objects.equals(this.balancePlatform, balanceNotificationData.balancePlatform)
        && Objects.equals(this.balances, balanceNotificationData.balances)
        && Objects.equals(this.creationDate, balanceNotificationData.creationDate)
        && Objects.equals(this.currency, balanceNotificationData.currency)
        && Objects.equals(this.id, balanceNotificationData.id)
        && Objects.equals(this.settingIds, balanceNotificationData.settingIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        balanceAccountId, balancePlatform, balances, creationDate, currency, id, settingIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceNotificationData {\n");
    sb.append("    balanceAccountId: ").append(toIndentedString(balanceAccountId)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    settingIds: ").append(toIndentedString(settingIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BalanceNotificationData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceNotificationData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     BalanceNotificationData
   */
  public static BalanceNotificationData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceNotificationData.class);
  }

  /**
   * Convert an instance of BalanceNotificationData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
