/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** CardDetails */
@JsonPropertyOrder({
  CardDetails.JSON_PROPERTY_BRAND,
  CardDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  CardDetails.JSON_PROPERTY_CUPSECUREPLUS_SMSCODE,
  CardDetails.JSON_PROPERTY_CVC,
  CardDetails.JSON_PROPERTY_ENCRYPTED_CARD,
  CardDetails.JSON_PROPERTY_ENCRYPTED_CARD_NUMBER,
  CardDetails.JSON_PROPERTY_ENCRYPTED_EXPIRY_MONTH,
  CardDetails.JSON_PROPERTY_ENCRYPTED_EXPIRY_YEAR,
  CardDetails.JSON_PROPERTY_ENCRYPTED_SECURITY_CODE,
  CardDetails.JSON_PROPERTY_EXPIRY_MONTH,
  CardDetails.JSON_PROPERTY_EXPIRY_YEAR,
  CardDetails.JSON_PROPERTY_FASTLANE_DATA,
  CardDetails.JSON_PROPERTY_FUNDING_SOURCE,
  CardDetails.JSON_PROPERTY_HOLDER_NAME,
  CardDetails.JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE,
  CardDetails.JSON_PROPERTY_NUMBER,
  CardDetails.JSON_PROPERTY_RECURRING_DETAIL_REFERENCE,
  CardDetails.JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE,
  CardDetails.JSON_PROPERTY_SRC_CORRELATION_ID,
  CardDetails.JSON_PROPERTY_SRC_DIGITAL_CARD_ID,
  CardDetails.JSON_PROPERTY_SRC_SCHEME,
  CardDetails.JSON_PROPERTY_SRC_TOKEN_REFERENCE,
  CardDetails.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID,
  CardDetails.JSON_PROPERTY_THREE_D_S2_SDK_VERSION,
  CardDetails.JSON_PROPERTY_TYPE
})
public class CardDetails {
  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_CUPSECUREPLUS_SMSCODE = "cupsecureplus.smscode";
  @Deprecated // deprecated
  private String cupsecureplusSmscode;

  public static final String JSON_PROPERTY_CVC = "cvc";
  private String cvc;

  public static final String JSON_PROPERTY_ENCRYPTED_CARD = "encryptedCard";
  private String encryptedCard;

  public static final String JSON_PROPERTY_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
  private String encryptedCardNumber;

  public static final String JSON_PROPERTY_ENCRYPTED_EXPIRY_MONTH = "encryptedExpiryMonth";
  private String encryptedExpiryMonth;

  public static final String JSON_PROPERTY_ENCRYPTED_EXPIRY_YEAR = "encryptedExpiryYear";
  private String encryptedExpiryYear;

  public static final String JSON_PROPERTY_ENCRYPTED_SECURITY_CODE = "encryptedSecurityCode";
  private String encryptedSecurityCode;

  public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
  private String expiryMonth;

  public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
  private String expiryYear;

  public static final String JSON_PROPERTY_FASTLANE_DATA = "fastlaneData";
  private String fastlaneData;

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo
   * cards, by default the funding source is credit. To use debit, set this value to **debit**.
   */
  public enum FundingSourceEnum {
    CREDIT(String.valueOf("credit")),

    DEBIT(String.valueOf("debit"));

    private String value;

    FundingSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingSourceEnum fromValue(String value) {
      for (FundingSourceEnum b : FundingSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
  private FundingSourceEnum fundingSource;

  public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
  private String holderName;

  public static final String JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE = "networkPaymentReference";
  private String networkPaymentReference;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  private String recurringDetailReference;

  public static final String JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE =
      "shopperNotificationReference";
  private String shopperNotificationReference;

  public static final String JSON_PROPERTY_SRC_CORRELATION_ID = "srcCorrelationId";
  private String srcCorrelationId;

  public static final String JSON_PROPERTY_SRC_DIGITAL_CARD_ID = "srcDigitalCardId";
  private String srcDigitalCardId;

  public static final String JSON_PROPERTY_SRC_SCHEME = "srcScheme";
  private String srcScheme;

  public static final String JSON_PROPERTY_SRC_TOKEN_REFERENCE = "srcTokenReference";
  private String srcTokenReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  public static final String JSON_PROPERTY_THREE_D_S2_SDK_VERSION = "threeDS2SdkVersion";
  private String threeDS2SdkVersion;

  /**
   * Default payment method details. Common for scheme payment methods, and for simple payment
   * method details.
   */
  public enum TypeEnum {
    BCMC(String.valueOf("bcmc")),

    SCHEME(String.valueOf("scheme")),

    NETWORKTOKEN(String.valueOf("networkToken")),

    GIFTCARD(String.valueOf("giftcard")),

    CARD(String.valueOf("card")),

    CLICKTOPAY(String.valueOf("clicktopay"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.SCHEME;

  public CardDetails() {}

  /**
   * Secondary brand of the card. For example: **plastix**, **hmclub**.
   *
   * @param brand Secondary brand of the card. For example: **plastix**, **hmclub**.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails brand(String brand) {
    this.brand = brand;
    return this;
  }

  /**
   * Secondary brand of the card. For example: **plastix**, **hmclub**.
   *
   * @return brand Secondary brand of the card. For example: **plastix**, **hmclub**.
   */
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBrand() {
    return brand;
  }

  /**
   * Secondary brand of the card. For example: **plastix**, **hmclub**.
   *
   * @param brand Secondary brand of the card. For example: **plastix**, **hmclub**.
   */
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   *
   * @return checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * cupsecureplusSmscode
   *
   * @param cupsecureplusSmscode
   * @return the current {@code CardDetails} instance, allowing for method chaining
   * @deprecated
   */
  @Deprecated // deprecated
  public CardDetails cupsecureplusSmscode(String cupsecureplusSmscode) {
    this.cupsecureplusSmscode = cupsecureplusSmscode;
    return this;
  }

  /**
   * Get cupsecureplusSmscode
   *
   * @return cupsecureplusSmscode
   * @deprecated // deprecated
   */
  @Deprecated // deprecated
  @JsonProperty(JSON_PROPERTY_CUPSECUREPLUS_SMSCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCupsecureplusSmscode() {
    return cupsecureplusSmscode;
  }

  /**
   * cupsecureplusSmscode
   *
   * @param cupsecureplusSmscode
   * @deprecated
   */
  @Deprecated // deprecated
  @JsonProperty(JSON_PROPERTY_CUPSECUREPLUS_SMSCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCupsecureplusSmscode(String cupsecureplusSmscode) {
    this.cupsecureplusSmscode = cupsecureplusSmscode;
  }

  /**
   * The card verification code. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param cvc The card verification code. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails cvc(String cvc) {
    this.cvc = cvc;
    return this;
  }

  /**
   * The card verification code. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @return cvc The card verification code. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_CVC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCvc() {
    return cvc;
  }

  /**
   * The card verification code. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param cvc The card verification code. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_CVC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCvc(String cvc) {
    this.cvc = cvc;
  }

  /**
   * Only include this for JSON Web Encryption (JWE) implementations. The JWE-encrypted card
   * details.
   *
   * @param encryptedCard Only include this for JSON Web Encryption (JWE) implementations. The
   *     JWE-encrypted card details.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails encryptedCard(String encryptedCard) {
    this.encryptedCard = encryptedCard;
    return this;
  }

  /**
   * Only include this for JSON Web Encryption (JWE) implementations. The JWE-encrypted card
   * details.
   *
   * @return encryptedCard Only include this for JSON Web Encryption (JWE) implementations. The
   *     JWE-encrypted card details.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedCard() {
    return encryptedCard;
  }

  /**
   * Only include this for JSON Web Encryption (JWE) implementations. The JWE-encrypted card
   * details.
   *
   * @param encryptedCard Only include this for JSON Web Encryption (JWE) implementations. The
   *     JWE-encrypted card details.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedCard(String encryptedCard) {
    this.encryptedCard = encryptedCard;
  }

  /**
   * The encrypted card number.
   *
   * @param encryptedCardNumber The encrypted card number.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails encryptedCardNumber(String encryptedCardNumber) {
    this.encryptedCardNumber = encryptedCardNumber;
    return this;
  }

  /**
   * The encrypted card number.
   *
   * @return encryptedCardNumber The encrypted card number.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedCardNumber() {
    return encryptedCardNumber;
  }

  /**
   * The encrypted card number.
   *
   * @param encryptedCardNumber The encrypted card number.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedCardNumber(String encryptedCardNumber) {
    this.encryptedCardNumber = encryptedCardNumber;
  }

  /**
   * The encrypted card expiry month.
   *
   * @param encryptedExpiryMonth The encrypted card expiry month.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails encryptedExpiryMonth(String encryptedExpiryMonth) {
    this.encryptedExpiryMonth = encryptedExpiryMonth;
    return this;
  }

  /**
   * The encrypted card expiry month.
   *
   * @return encryptedExpiryMonth The encrypted card expiry month.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedExpiryMonth() {
    return encryptedExpiryMonth;
  }

  /**
   * The encrypted card expiry month.
   *
   * @param encryptedExpiryMonth The encrypted card expiry month.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedExpiryMonth(String encryptedExpiryMonth) {
    this.encryptedExpiryMonth = encryptedExpiryMonth;
  }

  /**
   * The encrypted card expiry year.
   *
   * @param encryptedExpiryYear The encrypted card expiry year.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails encryptedExpiryYear(String encryptedExpiryYear) {
    this.encryptedExpiryYear = encryptedExpiryYear;
    return this;
  }

  /**
   * The encrypted card expiry year.
   *
   * @return encryptedExpiryYear The encrypted card expiry year.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedExpiryYear() {
    return encryptedExpiryYear;
  }

  /**
   * The encrypted card expiry year.
   *
   * @param encryptedExpiryYear The encrypted card expiry year.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedExpiryYear(String encryptedExpiryYear) {
    this.encryptedExpiryYear = encryptedExpiryYear;
  }

  /**
   * The encrypted card verification code.
   *
   * @param encryptedSecurityCode The encrypted card verification code.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails encryptedSecurityCode(String encryptedSecurityCode) {
    this.encryptedSecurityCode = encryptedSecurityCode;
    return this;
  }

  /**
   * The encrypted card verification code.
   *
   * @return encryptedSecurityCode The encrypted card verification code.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_SECURITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedSecurityCode() {
    return encryptedSecurityCode;
  }

  /**
   * The encrypted card verification code.
   *
   * @param encryptedSecurityCode The encrypted card verification code.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_SECURITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedSecurityCode(String encryptedSecurityCode) {
    this.encryptedSecurityCode = encryptedSecurityCode;
  }

  /**
   * The card expiry month. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param expiryMonth The card expiry month. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails expiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }

  /**
   * The card expiry month. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @return expiryMonth The card expiry month. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiryMonth() {
    return expiryMonth;
  }

  /**
   * The card expiry month. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param expiryMonth The card expiry month. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
  }

  /**
   * The card expiry year. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param expiryYear The card expiry year. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails expiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }

  /**
   * The card expiry year. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @return expiryYear The card expiry year. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiryYear() {
    return expiryYear;
  }

  /**
   * The card expiry year. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param expiryYear The card expiry year. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
  }

  /**
   * The encoded fastlane data blob
   *
   * @param fastlaneData The encoded fastlane data blob
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails fastlaneData(String fastlaneData) {
    this.fastlaneData = fastlaneData;
    return this;
  }

  /**
   * The encoded fastlane data blob
   *
   * @return fastlaneData The encoded fastlane data blob
   */
  @JsonProperty(JSON_PROPERTY_FASTLANE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFastlaneData() {
    return fastlaneData;
  }

  /**
   * The encoded fastlane data blob
   *
   * @param fastlaneData The encoded fastlane data blob
   */
  @JsonProperty(JSON_PROPERTY_FASTLANE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFastlaneData(String fastlaneData) {
    this.fastlaneData = fastlaneData;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo
   * cards, by default the funding source is credit. To use debit, set this value to **debit**.
   *
   * @param fundingSource The funding source that should be used when multiple sources are
   *     available. For Brazilian combo cards, by default the funding source is credit. To use
   *     debit, set this value to **debit**.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails fundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
    return this;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo
   * cards, by default the funding source is credit. To use debit, set this value to **debit**.
   *
   * @return fundingSource The funding source that should be used when multiple sources are
   *     available. For Brazilian combo cards, by default the funding source is credit. To use
   *     debit, set this value to **debit**.
   */
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FundingSourceEnum getFundingSource() {
    return fundingSource;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo
   * cards, by default the funding source is credit. To use debit, set this value to **debit**.
   *
   * @param fundingSource The funding source that should be used when multiple sources are
   *     available. For Brazilian combo cards, by default the funding source is credit. To use
   *     debit, set this value to **debit**.
   */
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
  }

  /**
   * The name of the card holder.
   *
   * @param holderName The name of the card holder.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails holderName(String holderName) {
    this.holderName = holderName;
    return this;
  }

  /**
   * The name of the card holder.
   *
   * @return holderName The name of the card holder.
   */
  @JsonProperty(JSON_PROPERTY_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getHolderName() {
    return holderName;
  }

  /**
   * The name of the card holder.
   *
   * @param holderName The name of the card holder.
   */
  @JsonProperty(JSON_PROPERTY_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHolderName(String holderName) {
    this.holderName = holderName;
  }

  /**
   * The transaction identifier from card schemes. This is the
   * [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   * from the response to the first payment.
   *
   * @param networkPaymentReference The transaction identifier from card schemes. This is the
   *     [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   *     from the response to the first payment.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails networkPaymentReference(String networkPaymentReference) {
    this.networkPaymentReference = networkPaymentReference;
    return this;
  }

  /**
   * The transaction identifier from card schemes. This is the
   * [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   * from the response to the first payment.
   *
   * @return networkPaymentReference The transaction identifier from card schemes. This is the
   *     [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   *     from the response to the first payment.
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNetworkPaymentReference() {
    return networkPaymentReference;
  }

  /**
   * The transaction identifier from card schemes. This is the
   * [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   * from the response to the first payment.
   *
   * @param networkPaymentReference The transaction identifier from card schemes. This is the
   *     [&#x60;networkTxReference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference)
   *     from the response to the first payment.
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkPaymentReference(String networkPaymentReference) {
    this.networkPaymentReference = networkPaymentReference;
  }

  /**
   * The card number. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param number The card number. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails number(String number) {
    this.number = number;
    return this;
  }

  /**
   * The card number. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @return number The card number. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNumber() {
    return number;
  }

  /**
   * The card number. Only collect raw card data if you are [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   *
   * @param number The card number. Only collect raw card data if you are [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   * @deprecated since Adyen Checkout API v49 Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  public CardDetails recurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @return recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @deprecated since Adyen Checkout API v49 Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }

  /**
   * The &#x60;shopperNotificationReference&#x60; returned in the response when you requested to
   * notify the shopper. Used only for recurring payments in India.
   *
   * @param shopperNotificationReference The &#x60;shopperNotificationReference&#x60; returned in
   *     the response when you requested to notify the shopper. Used only for recurring payments in
   *     India.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails shopperNotificationReference(String shopperNotificationReference) {
    this.shopperNotificationReference = shopperNotificationReference;
    return this;
  }

  /**
   * The &#x60;shopperNotificationReference&#x60; returned in the response when you requested to
   * notify the shopper. Used only for recurring payments in India.
   *
   * @return shopperNotificationReference The &#x60;shopperNotificationReference&#x60; returned in
   *     the response when you requested to notify the shopper. Used only for recurring payments in
   *     India.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperNotificationReference() {
    return shopperNotificationReference;
  }

  /**
   * The &#x60;shopperNotificationReference&#x60; returned in the response when you requested to
   * notify the shopper. Used only for recurring payments in India.
   *
   * @param shopperNotificationReference The &#x60;shopperNotificationReference&#x60; returned in
   *     the response when you requested to notify the shopper. Used only for recurring payments in
   *     India.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperNotificationReference(String shopperNotificationReference) {
    this.shopperNotificationReference = shopperNotificationReference;
  }

  /**
   * An identifier used for the Click to Pay transaction.
   *
   * @param srcCorrelationId An identifier used for the Click to Pay transaction.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails srcCorrelationId(String srcCorrelationId) {
    this.srcCorrelationId = srcCorrelationId;
    return this;
  }

  /**
   * An identifier used for the Click to Pay transaction.
   *
   * @return srcCorrelationId An identifier used for the Click to Pay transaction.
   */
  @JsonProperty(JSON_PROPERTY_SRC_CORRELATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSrcCorrelationId() {
    return srcCorrelationId;
  }

  /**
   * An identifier used for the Click to Pay transaction.
   *
   * @param srcCorrelationId An identifier used for the Click to Pay transaction.
   */
  @JsonProperty(JSON_PROPERTY_SRC_CORRELATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSrcCorrelationId(String srcCorrelationId) {
    this.srcCorrelationId = srcCorrelationId;
  }

  /**
   * The SRC reference for the Click to Pay token.
   *
   * @param srcDigitalCardId The SRC reference for the Click to Pay token.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails srcDigitalCardId(String srcDigitalCardId) {
    this.srcDigitalCardId = srcDigitalCardId;
    return this;
  }

  /**
   * The SRC reference for the Click to Pay token.
   *
   * @return srcDigitalCardId The SRC reference for the Click to Pay token.
   */
  @JsonProperty(JSON_PROPERTY_SRC_DIGITAL_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSrcDigitalCardId() {
    return srcDigitalCardId;
  }

  /**
   * The SRC reference for the Click to Pay token.
   *
   * @param srcDigitalCardId The SRC reference for the Click to Pay token.
   */
  @JsonProperty(JSON_PROPERTY_SRC_DIGITAL_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSrcDigitalCardId(String srcDigitalCardId) {
    this.srcDigitalCardId = srcDigitalCardId;
  }

  /**
   * The scheme that is being used for Click to Pay.
   *
   * @param srcScheme The scheme that is being used for Click to Pay.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails srcScheme(String srcScheme) {
    this.srcScheme = srcScheme;
    return this;
  }

  /**
   * The scheme that is being used for Click to Pay.
   *
   * @return srcScheme The scheme that is being used for Click to Pay.
   */
  @JsonProperty(JSON_PROPERTY_SRC_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSrcScheme() {
    return srcScheme;
  }

  /**
   * The scheme that is being used for Click to Pay.
   *
   * @param srcScheme The scheme that is being used for Click to Pay.
   */
  @JsonProperty(JSON_PROPERTY_SRC_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSrcScheme(String srcScheme) {
    this.srcScheme = srcScheme;
  }

  /**
   * The reference for the Click to Pay token.
   *
   * @param srcTokenReference The reference for the Click to Pay token.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails srcTokenReference(String srcTokenReference) {
    this.srcTokenReference = srcTokenReference;
    return this;
  }

  /**
   * The reference for the Click to Pay token.
   *
   * @return srcTokenReference The reference for the Click to Pay token.
   */
  @JsonProperty(JSON_PROPERTY_SRC_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSrcTokenReference() {
    return srcTokenReference;
  }

  /**
   * The reference for the Click to Pay token.
   *
   * @param srcTokenReference The reference for the Click to Pay token.
   */
  @JsonProperty(JSON_PROPERTY_SRC_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSrcTokenReference(String srcTokenReference) {
    this.srcTokenReference = srcTokenReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @return storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   *
   * @param threeDS2SdkVersion Required for mobile integrations. Version of the 3D Secure 2 mobile
   *     SDK.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails threeDS2SdkVersion(String threeDS2SdkVersion) {
    this.threeDS2SdkVersion = threeDS2SdkVersion;
    return this;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   *
   * @return threeDS2SdkVersion Required for mobile integrations. Version of the 3D Secure 2 mobile
   *     SDK.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDS2SdkVersion() {
    return threeDS2SdkVersion;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   *
   * @param threeDS2SdkVersion Required for mobile integrations. Version of the 3D Secure 2 mobile
   *     SDK.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2SdkVersion(String threeDS2SdkVersion) {
    this.threeDS2SdkVersion = threeDS2SdkVersion;
  }

  /**
   * Default payment method details. Common for scheme payment methods, and for simple payment
   * method details.
   *
   * @param type Default payment method details. Common for scheme payment methods, and for simple
   *     payment method details.
   * @return the current {@code CardDetails} instance, allowing for method chaining
   */
  public CardDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Default payment method details. Common for scheme payment methods, and for simple payment
   * method details.
   *
   * @return type Default payment method details. Common for scheme payment methods, and for simple
   *     payment method details.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Default payment method details. Common for scheme payment methods, and for simple payment
   * method details.
   *
   * @param type Default payment method details. Common for scheme payment methods, and for simple
   *     payment method details.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this CardDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardDetails cardDetails = (CardDetails) o;
    return Objects.equals(this.brand, cardDetails.brand)
        && Objects.equals(this.checkoutAttemptId, cardDetails.checkoutAttemptId)
        && Objects.equals(this.cupsecureplusSmscode, cardDetails.cupsecureplusSmscode)
        && Objects.equals(this.cvc, cardDetails.cvc)
        && Objects.equals(this.encryptedCard, cardDetails.encryptedCard)
        && Objects.equals(this.encryptedCardNumber, cardDetails.encryptedCardNumber)
        && Objects.equals(this.encryptedExpiryMonth, cardDetails.encryptedExpiryMonth)
        && Objects.equals(this.encryptedExpiryYear, cardDetails.encryptedExpiryYear)
        && Objects.equals(this.encryptedSecurityCode, cardDetails.encryptedSecurityCode)
        && Objects.equals(this.expiryMonth, cardDetails.expiryMonth)
        && Objects.equals(this.expiryYear, cardDetails.expiryYear)
        && Objects.equals(this.fastlaneData, cardDetails.fastlaneData)
        && Objects.equals(this.fundingSource, cardDetails.fundingSource)
        && Objects.equals(this.holderName, cardDetails.holderName)
        && Objects.equals(this.networkPaymentReference, cardDetails.networkPaymentReference)
        && Objects.equals(this.number, cardDetails.number)
        && Objects.equals(this.recurringDetailReference, cardDetails.recurringDetailReference)
        && Objects.equals(
            this.shopperNotificationReference, cardDetails.shopperNotificationReference)
        && Objects.equals(this.srcCorrelationId, cardDetails.srcCorrelationId)
        && Objects.equals(this.srcDigitalCardId, cardDetails.srcDigitalCardId)
        && Objects.equals(this.srcScheme, cardDetails.srcScheme)
        && Objects.equals(this.srcTokenReference, cardDetails.srcTokenReference)
        && Objects.equals(this.storedPaymentMethodId, cardDetails.storedPaymentMethodId)
        && Objects.equals(this.threeDS2SdkVersion, cardDetails.threeDS2SdkVersion)
        && Objects.equals(this.type, cardDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        brand,
        checkoutAttemptId,
        cupsecureplusSmscode,
        cvc,
        encryptedCard,
        encryptedCardNumber,
        encryptedExpiryMonth,
        encryptedExpiryYear,
        encryptedSecurityCode,
        expiryMonth,
        expiryYear,
        fastlaneData,
        fundingSource,
        holderName,
        networkPaymentReference,
        number,
        recurringDetailReference,
        shopperNotificationReference,
        srcCorrelationId,
        srcDigitalCardId,
        srcScheme,
        srcTokenReference,
        storedPaymentMethodId,
        threeDS2SdkVersion,
        type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardDetails {\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    cupsecureplusSmscode: ")
        .append(toIndentedString(cupsecureplusSmscode))
        .append("\n");
    sb.append("    cvc: ").append(toIndentedString(cvc)).append("\n");
    sb.append("    encryptedCard: ").append(toIndentedString(encryptedCard)).append("\n");
    sb.append("    encryptedCardNumber: ")
        .append(toIndentedString(encryptedCardNumber))
        .append("\n");
    sb.append("    encryptedExpiryMonth: ")
        .append(toIndentedString(encryptedExpiryMonth))
        .append("\n");
    sb.append("    encryptedExpiryYear: ")
        .append(toIndentedString(encryptedExpiryYear))
        .append("\n");
    sb.append("    encryptedSecurityCode: ")
        .append(toIndentedString(encryptedSecurityCode))
        .append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    fastlaneData: ").append(toIndentedString(fastlaneData)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    holderName: ").append(toIndentedString(holderName)).append("\n");
    sb.append("    networkPaymentReference: ")
        .append(toIndentedString(networkPaymentReference))
        .append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    recurringDetailReference: ")
        .append(toIndentedString(recurringDetailReference))
        .append("\n");
    sb.append("    shopperNotificationReference: ")
        .append(toIndentedString(shopperNotificationReference))
        .append("\n");
    sb.append("    srcCorrelationId: ").append(toIndentedString(srcCorrelationId)).append("\n");
    sb.append("    srcDigitalCardId: ").append(toIndentedString(srcDigitalCardId)).append("\n");
    sb.append("    srcScheme: ").append(toIndentedString(srcScheme)).append("\n");
    sb.append("    srcTokenReference: ").append(toIndentedString(srcTokenReference)).append("\n");
    sb.append("    storedPaymentMethodId: ")
        .append(toIndentedString(storedPaymentMethodId))
        .append("\n");
    sb.append("    threeDS2SdkVersion: ").append(toIndentedString(threeDS2SdkVersion)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CardDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to CardDetails
   */
  public static CardDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardDetails.class);
  }

  /**
   * Convert an instance of CardDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
