/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** DokuDetails */
@JsonPropertyOrder({
  DokuDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  DokuDetails.JSON_PROPERTY_FIRST_NAME,
  DokuDetails.JSON_PROPERTY_LAST_NAME,
  DokuDetails.JSON_PROPERTY_SHOPPER_EMAIL,
  DokuDetails.JSON_PROPERTY_TYPE
})
public class DokuDetails {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  /** **doku** */
  public enum TypeEnum {
    DOKU_MANDIRI_VA(String.valueOf("doku_mandiri_va")),

    DOKU_CIMB_VA(String.valueOf("doku_cimb_va")),

    DOKU_DANAMON_VA(String.valueOf("doku_danamon_va")),

    DOKU_BNI_VA(String.valueOf("doku_bni_va")),

    DOKU_PERMATA_LITE_ATM(String.valueOf("doku_permata_lite_atm")),

    DOKU_BRI_VA(String.valueOf("doku_bri_va")),

    DOKU_BCA_VA(String.valueOf("doku_bca_va")),

    DOKU_ALFAMART(String.valueOf("doku_alfamart")),

    DOKU_INDOMARET(String.valueOf("doku_indomaret")),

    DOKU_WALLET(String.valueOf("doku_wallet")),

    DOKU_OVO(String.valueOf("doku_ovo"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public DokuDetails() {}

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   * @return the current {@code DokuDetails} instance, allowing for method chaining
   */
  public DokuDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   *
   * @return checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The shopper&#39;s first name.
   *
   * @param firstName The shopper&#39;s first name.
   * @return the current {@code DokuDetails} instance, allowing for method chaining
   */
  public DokuDetails firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * The shopper&#39;s first name.
   *
   * @return firstName The shopper&#39;s first name.
   */
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFirstName() {
    return firstName;
  }

  /**
   * The shopper&#39;s first name.
   *
   * @param firstName The shopper&#39;s first name.
   */
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * The shopper&#39;s last name.
   *
   * @param lastName The shopper&#39;s last name.
   * @return the current {@code DokuDetails} instance, allowing for method chaining
   */
  public DokuDetails lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * The shopper&#39;s last name.
   *
   * @return lastName The shopper&#39;s last name.
   */
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastName() {
    return lastName;
  }

  /**
   * The shopper&#39;s last name.
   *
   * @param lastName The shopper&#39;s last name.
   */
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * The shopper&#39;s email.
   *
   * @param shopperEmail The shopper&#39;s email.
   * @return the current {@code DokuDetails} instance, allowing for method chaining
   */
  public DokuDetails shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

  /**
   * The shopper&#39;s email.
   *
   * @return shopperEmail The shopper&#39;s email.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperEmail() {
    return shopperEmail;
  }

  /**
   * The shopper&#39;s email.
   *
   * @param shopperEmail The shopper&#39;s email.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }

  /**
   * **doku**
   *
   * @param type **doku**
   * @return the current {@code DokuDetails} instance, allowing for method chaining
   */
  public DokuDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **doku**
   *
   * @return type **doku**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **doku**
   *
   * @param type **doku**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this DokuDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DokuDetails dokuDetails = (DokuDetails) o;
    return Objects.equals(this.checkoutAttemptId, dokuDetails.checkoutAttemptId)
        && Objects.equals(this.firstName, dokuDetails.firstName)
        && Objects.equals(this.lastName, dokuDetails.lastName)
        && Objects.equals(this.shopperEmail, dokuDetails.shopperEmail)
        && Objects.equals(this.type, dokuDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutAttemptId, firstName, lastName, shopperEmail, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DokuDetails {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of DokuDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DokuDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to DokuDetails
   */
  public static DokuDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DokuDetails.class);
  }

  /**
   * Convert an instance of DokuDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
