/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** DonationCampaign */
@JsonPropertyOrder({
  DonationCampaign.JSON_PROPERTY_AMOUNTS,
  DonationCampaign.JSON_PROPERTY_BANNER_URL,
  DonationCampaign.JSON_PROPERTY_CAMPAIGN_NAME,
  DonationCampaign.JSON_PROPERTY_CAUSE_NAME,
  DonationCampaign.JSON_PROPERTY_DONATION,
  DonationCampaign.JSON_PROPERTY_ID,
  DonationCampaign.JSON_PROPERTY_LOGO_URL,
  DonationCampaign.JSON_PROPERTY_NONPROFIT_DESCRIPTION,
  DonationCampaign.JSON_PROPERTY_NONPROFIT_NAME,
  DonationCampaign.JSON_PROPERTY_NONPROFIT_URL,
  DonationCampaign.JSON_PROPERTY_TERMS_AND_CONDITIONS_URL
})
public class DonationCampaign {
  public static final String JSON_PROPERTY_AMOUNTS = "amounts";
  private Amounts amounts;

  public static final String JSON_PROPERTY_BANNER_URL = "bannerUrl";
  private String bannerUrl;

  public static final String JSON_PROPERTY_CAMPAIGN_NAME = "campaignName";
  private String campaignName;

  public static final String JSON_PROPERTY_CAUSE_NAME = "causeName";
  private String causeName;

  public static final String JSON_PROPERTY_DONATION = "donation";
  private Donation donation;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LOGO_URL = "logoUrl";
  private String logoUrl;

  public static final String JSON_PROPERTY_NONPROFIT_DESCRIPTION = "nonprofitDescription";
  private String nonprofitDescription;

  public static final String JSON_PROPERTY_NONPROFIT_NAME = "nonprofitName";
  private String nonprofitName;

  public static final String JSON_PROPERTY_NONPROFIT_URL = "nonprofitUrl";
  private String nonprofitUrl;

  public static final String JSON_PROPERTY_TERMS_AND_CONDITIONS_URL = "termsAndConditionsUrl";
  private String termsAndConditionsUrl;

  public DonationCampaign() {}

  /**
   * amounts
   *
   * @param amounts
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign amounts(Amounts amounts) {
    this.amounts = amounts;
    return this;
  }

  /**
   * Get amounts
   *
   * @return amounts
   */
  @JsonProperty(JSON_PROPERTY_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amounts getAmounts() {
    return amounts;
  }

  /**
   * amounts
   *
   * @param amounts
   */
  @JsonProperty(JSON_PROPERTY_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmounts(Amounts amounts) {
    this.amounts = amounts;
  }

  /**
   * The URL for the banner of the nonprofit or campaign.
   *
   * @param bannerUrl The URL for the banner of the nonprofit or campaign.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign bannerUrl(String bannerUrl) {
    this.bannerUrl = bannerUrl;
    return this;
  }

  /**
   * The URL for the banner of the nonprofit or campaign.
   *
   * @return bannerUrl The URL for the banner of the nonprofit or campaign.
   */
  @JsonProperty(JSON_PROPERTY_BANNER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBannerUrl() {
    return bannerUrl;
  }

  /**
   * The URL for the banner of the nonprofit or campaign.
   *
   * @param bannerUrl The URL for the banner of the nonprofit or campaign.
   */
  @JsonProperty(JSON_PROPERTY_BANNER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBannerUrl(String bannerUrl) {
    this.bannerUrl = bannerUrl;
  }

  /**
   * The name of the donation campaign..
   *
   * @param campaignName The name of the donation campaign..
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign campaignName(String campaignName) {
    this.campaignName = campaignName;
    return this;
  }

  /**
   * The name of the donation campaign..
   *
   * @return campaignName The name of the donation campaign..
   */
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCampaignName() {
    return campaignName;
  }

  /**
   * The name of the donation campaign..
   *
   * @param campaignName The name of the donation campaign..
   */
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignName(String campaignName) {
    this.campaignName = campaignName;
  }

  /**
   * The cause of the nonprofit.
   *
   * @param causeName The cause of the nonprofit.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign causeName(String causeName) {
    this.causeName = causeName;
    return this;
  }

  /**
   * The cause of the nonprofit.
   *
   * @return causeName The cause of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_CAUSE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCauseName() {
    return causeName;
  }

  /**
   * The cause of the nonprofit.
   *
   * @param causeName The cause of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_CAUSE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCauseName(String causeName) {
    this.causeName = causeName;
  }

  /**
   * donation
   *
   * @param donation
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign donation(Donation donation) {
    this.donation = donation;
    return this;
  }

  /**
   * Get donation
   *
   * @return donation
   */
  @JsonProperty(JSON_PROPERTY_DONATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Donation getDonation() {
    return donation;
  }

  /**
   * donation
   *
   * @param donation
   */
  @JsonProperty(JSON_PROPERTY_DONATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDonation(Donation donation) {
    this.donation = donation;
  }

  /**
   * The unique campaign ID of the donation campaign.
   *
   * @param id The unique campaign ID of the donation campaign.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique campaign ID of the donation campaign.
   *
   * @return id The unique campaign ID of the donation campaign.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique campaign ID of the donation campaign.
   *
   * @param id The unique campaign ID of the donation campaign.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The URL for the logo of the nonprofit.
   *
   * @param logoUrl The URL for the logo of the nonprofit.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign logoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
    return this;
  }

  /**
   * The URL for the logo of the nonprofit.
   *
   * @return logoUrl The URL for the logo of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLogoUrl() {
    return logoUrl;
  }

  /**
   * The URL for the logo of the nonprofit.
   *
   * @param logoUrl The URL for the logo of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoUrl(String logoUrl) {
    this.logoUrl = logoUrl;
  }

  /**
   * The description of the nonprofit.
   *
   * @param nonprofitDescription The description of the nonprofit.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign nonprofitDescription(String nonprofitDescription) {
    this.nonprofitDescription = nonprofitDescription;
    return this;
  }

  /**
   * The description of the nonprofit.
   *
   * @return nonprofitDescription The description of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNonprofitDescription() {
    return nonprofitDescription;
  }

  /**
   * The description of the nonprofit.
   *
   * @param nonprofitDescription The description of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonprofitDescription(String nonprofitDescription) {
    this.nonprofitDescription = nonprofitDescription;
  }

  /**
   * The name of the nonprofit organization that receives the donation.
   *
   * @param nonprofitName The name of the nonprofit organization that receives the donation.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign nonprofitName(String nonprofitName) {
    this.nonprofitName = nonprofitName;
    return this;
  }

  /**
   * The name of the nonprofit organization that receives the donation.
   *
   * @return nonprofitName The name of the nonprofit organization that receives the donation.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNonprofitName() {
    return nonprofitName;
  }

  /**
   * The name of the nonprofit organization that receives the donation.
   *
   * @param nonprofitName The name of the nonprofit organization that receives the donation.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonprofitName(String nonprofitName) {
    this.nonprofitName = nonprofitName;
  }

  /**
   * The website URL of the nonprofit.
   *
   * @param nonprofitUrl The website URL of the nonprofit.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign nonprofitUrl(String nonprofitUrl) {
    this.nonprofitUrl = nonprofitUrl;
    return this;
  }

  /**
   * The website URL of the nonprofit.
   *
   * @return nonprofitUrl The website URL of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNonprofitUrl() {
    return nonprofitUrl;
  }

  /**
   * The website URL of the nonprofit.
   *
   * @param nonprofitUrl The website URL of the nonprofit.
   */
  @JsonProperty(JSON_PROPERTY_NONPROFIT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonprofitUrl(String nonprofitUrl) {
    this.nonprofitUrl = nonprofitUrl;
  }

  /**
   * The URL of the terms and conditions page of the nonprofit and the campaign.
   *
   * @param termsAndConditionsUrl The URL of the terms and conditions page of the nonprofit and the
   *     campaign.
   * @return the current {@code DonationCampaign} instance, allowing for method chaining
   */
  public DonationCampaign termsAndConditionsUrl(String termsAndConditionsUrl) {
    this.termsAndConditionsUrl = termsAndConditionsUrl;
    return this;
  }

  /**
   * The URL of the terms and conditions page of the nonprofit and the campaign.
   *
   * @return termsAndConditionsUrl The URL of the terms and conditions page of the nonprofit and the
   *     campaign.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_AND_CONDITIONS_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTermsAndConditionsUrl() {
    return termsAndConditionsUrl;
  }

  /**
   * The URL of the terms and conditions page of the nonprofit and the campaign.
   *
   * @param termsAndConditionsUrl The URL of the terms and conditions page of the nonprofit and the
   *     campaign.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_AND_CONDITIONS_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTermsAndConditionsUrl(String termsAndConditionsUrl) {
    this.termsAndConditionsUrl = termsAndConditionsUrl;
  }

  /** Return true if this DonationCampaign object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DonationCampaign donationCampaign = (DonationCampaign) o;
    return Objects.equals(this.amounts, donationCampaign.amounts)
        && Objects.equals(this.bannerUrl, donationCampaign.bannerUrl)
        && Objects.equals(this.campaignName, donationCampaign.campaignName)
        && Objects.equals(this.causeName, donationCampaign.causeName)
        && Objects.equals(this.donation, donationCampaign.donation)
        && Objects.equals(this.id, donationCampaign.id)
        && Objects.equals(this.logoUrl, donationCampaign.logoUrl)
        && Objects.equals(this.nonprofitDescription, donationCampaign.nonprofitDescription)
        && Objects.equals(this.nonprofitName, donationCampaign.nonprofitName)
        && Objects.equals(this.nonprofitUrl, donationCampaign.nonprofitUrl)
        && Objects.equals(this.termsAndConditionsUrl, donationCampaign.termsAndConditionsUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        amounts,
        bannerUrl,
        campaignName,
        causeName,
        donation,
        id,
        logoUrl,
        nonprofitDescription,
        nonprofitName,
        nonprofitUrl,
        termsAndConditionsUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DonationCampaign {\n");
    sb.append("    amounts: ").append(toIndentedString(amounts)).append("\n");
    sb.append("    bannerUrl: ").append(toIndentedString(bannerUrl)).append("\n");
    sb.append("    campaignName: ").append(toIndentedString(campaignName)).append("\n");
    sb.append("    causeName: ").append(toIndentedString(causeName)).append("\n");
    sb.append("    donation: ").append(toIndentedString(donation)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logoUrl: ").append(toIndentedString(logoUrl)).append("\n");
    sb.append("    nonprofitDescription: ")
        .append(toIndentedString(nonprofitDescription))
        .append("\n");
    sb.append("    nonprofitName: ").append(toIndentedString(nonprofitName)).append("\n");
    sb.append("    nonprofitUrl: ").append(toIndentedString(nonprofitUrl)).append("\n");
    sb.append("    termsAndConditionsUrl: ")
        .append(toIndentedString(termsAndConditionsUrl))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of DonationCampaign given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DonationCampaign
   * @throws JsonProcessingException if the JSON string is invalid with respect to DonationCampaign
   */
  public static DonationCampaign fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DonationCampaign.class);
  }

  /**
   * Convert an instance of DonationCampaign to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
