/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** PaypalUpdateOrderResponse */
@JsonPropertyOrder({
  PaypalUpdateOrderResponse.JSON_PROPERTY_PAYMENT_DATA,
  PaypalUpdateOrderResponse.JSON_PROPERTY_STATUS
})
public class PaypalUpdateOrderResponse {
  public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
  private String paymentData;

  /**
   * The status of the request. This indicates whether the order was successfully updated with
   * PayPal.
   */
  public enum StatusEnum {
    ERROR(String.valueOf("error")),

    SUCCESS(String.valueOf("success"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public PaypalUpdateOrderResponse() {}

  /**
   * The updated paymentData.
   *
   * @param paymentData The updated paymentData.
   * @return the current {@code PaypalUpdateOrderResponse} instance, allowing for method chaining
   */
  public PaypalUpdateOrderResponse paymentData(String paymentData) {
    this.paymentData = paymentData;
    return this;
  }

  /**
   * The updated paymentData.
   *
   * @return paymentData The updated paymentData.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentData() {
    return paymentData;
  }

  /**
   * The updated paymentData.
   *
   * @param paymentData The updated paymentData.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentData(String paymentData) {
    this.paymentData = paymentData;
  }

  /**
   * The status of the request. This indicates whether the order was successfully updated with
   * PayPal.
   *
   * @param status The status of the request. This indicates whether the order was successfully
   *     updated with PayPal.
   * @return the current {@code PaypalUpdateOrderResponse} instance, allowing for method chaining
   */
  public PaypalUpdateOrderResponse status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the request. This indicates whether the order was successfully updated with
   * PayPal.
   *
   * @return status The status of the request. This indicates whether the order was successfully
   *     updated with PayPal.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the request. This indicates whether the order was successfully updated with
   * PayPal.
   *
   * @param status The status of the request. This indicates whether the order was successfully
   *     updated with PayPal.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /** Return true if this PaypalUpdateOrderResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaypalUpdateOrderResponse paypalUpdateOrderResponse = (PaypalUpdateOrderResponse) o;
    return Objects.equals(this.paymentData, paypalUpdateOrderResponse.paymentData)
        && Objects.equals(this.status, paypalUpdateOrderResponse.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentData, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaypalUpdateOrderResponse {\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaypalUpdateOrderResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaypalUpdateOrderResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaypalUpdateOrderResponse
   */
  public static PaypalUpdateOrderResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaypalUpdateOrderResponse.class);
  }

  /**
   * Convert an instance of PaypalUpdateOrderResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
