/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Objects;

/** Ticket */
@JsonPropertyOrder({
  Ticket.JSON_PROPERTY_ISSUE_ADDRESS,
  Ticket.JSON_PROPERTY_ISSUE_DATE,
  Ticket.JSON_PROPERTY_NUMBER
})
public class Ticket {
  public static final String JSON_PROPERTY_ISSUE_ADDRESS = "issueAddress";
  private String issueAddress;

  public static final String JSON_PROPERTY_ISSUE_DATE = "issueDate";
  private LocalDate issueDate;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public Ticket() {}

  /**
   * The address of the organization that issued the ticket. * minLength: 0 characters * maxLength:
   * 16 characters
   *
   * @param issueAddress The address of the organization that issued the ticket. * minLength: 0
   *     characters * maxLength: 16 characters
   * @return the current {@code Ticket} instance, allowing for method chaining
   */
  public Ticket issueAddress(String issueAddress) {
    this.issueAddress = issueAddress;
    return this;
  }

  /**
   * The address of the organization that issued the ticket. * minLength: 0 characters * maxLength:
   * 16 characters
   *
   * @return issueAddress The address of the organization that issued the ticket. * minLength: 0
   *     characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_ISSUE_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssueAddress() {
    return issueAddress;
  }

  /**
   * The address of the organization that issued the ticket. * minLength: 0 characters * maxLength:
   * 16 characters
   *
   * @param issueAddress The address of the organization that issued the ticket. * minLength: 0
   *     characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_ISSUE_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssueAddress(String issueAddress) {
    this.issueAddress = issueAddress;
  }

  /**
   * The date that the ticket was issued to the passenger. * minLength: 10 characters * maxLength:
   * 10 characters * Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   *
   * @param issueDate The date that the ticket was issued to the passenger. * minLength: 10
   *     characters * maxLength: 10 characters * Format [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   * @return the current {@code Ticket} instance, allowing for method chaining
   */
  public Ticket issueDate(LocalDate issueDate) {
    this.issueDate = issueDate;
    return this;
  }

  /**
   * The date that the ticket was issued to the passenger. * minLength: 10 characters * maxLength:
   * 10 characters * Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   *
   * @return issueDate The date that the ticket was issued to the passenger. * minLength: 10
   *     characters * maxLength: 10 characters * Format [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   */
  @JsonProperty(JSON_PROPERTY_ISSUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getIssueDate() {
    return issueDate;
  }

  /**
   * The date that the ticket was issued to the passenger. * minLength: 10 characters * maxLength:
   * 10 characters * Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   *
   * @param issueDate The date that the ticket was issued to the passenger. * minLength: 10
   *     characters * maxLength: 10 characters * Format [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime): yyyy-MM-dd
   */
  @JsonProperty(JSON_PROPERTY_ISSUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssueDate(LocalDate issueDate) {
    this.issueDate = issueDate;
  }

  /**
   * The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15 characters * Must
   * not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param number The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15
   *     characters * Must not start with a space or be all spaces. * Must not be all zeros.
   * @return the current {@code Ticket} instance, allowing for method chaining
   */
  public Ticket number(String number) {
    this.number = number;
    return this;
  }

  /**
   * The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15 characters * Must
   * not start with a space or be all spaces. * Must not be all zeros.
   *
   * @return number The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15
   *     characters * Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNumber() {
    return number;
  }

  /**
   * The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15 characters * Must
   * not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param number The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15
   *     characters * Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }

  /** Return true if this Ticket object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Ticket ticket = (Ticket) o;
    return Objects.equals(this.issueAddress, ticket.issueAddress)
        && Objects.equals(this.issueDate, ticket.issueDate)
        && Objects.equals(this.number, ticket.number);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issueAddress, issueDate, number);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Ticket {\n");
    sb.append("    issueAddress: ").append(toIndentedString(issueAddress)).append("\n");
    sb.append("    issueDate: ").append(toIndentedString(issueDate)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Ticket given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Ticket
   * @throws JsonProcessingException if the JSON string is invalid with respect to Ticket
   */
  public static Ticket fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Ticket.class);
  }

  /**
   * Convert an instance of Ticket to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
