/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** TravelAgency */
@JsonPropertyOrder({TravelAgency.JSON_PROPERTY_CODE, TravelAgency.JSON_PROPERTY_NAME})
public class TravelAgency {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public TravelAgency() {}

  /**
   * The unique identifier from IATA or ARC for the travel agency that issues the ticket. *
   * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not start with a
   * space or be all spaces. * Must not be all zeros.
   *
   * @param code The unique identifier from IATA or ARC for the travel agency that issues the
   *     ticket. * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not
   *     start with a space or be all spaces. * Must not be all zeros.
   * @return the current {@code TravelAgency} instance, allowing for method chaining
   */
  public TravelAgency code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The unique identifier from IATA or ARC for the travel agency that issues the ticket. *
   * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not start with a
   * space or be all spaces. * Must not be all zeros.
   *
   * @return code The unique identifier from IATA or ARC for the travel agency that issues the
   *     ticket. * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not
   *     start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The unique identifier from IATA or ARC for the travel agency that issues the ticket. *
   * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not start with a
   * space or be all spaces. * Must not be all zeros.
   *
   * @param code The unique identifier from IATA or ARC for the travel agency that issues the
   *     ticket. * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not
   *     start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * The name of the travel agency. * Encoding: ASCII * minLength: 1 character * maxLength: 25
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param name The name of the travel agency. * Encoding: ASCII * minLength: 1 character *
   *     maxLength: 25 characters * Must not start with a space or be all spaces. * Must not be all
   *     zeros.
   * @return the current {@code TravelAgency} instance, allowing for method chaining
   */
  public TravelAgency name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the travel agency. * Encoding: ASCII * minLength: 1 character * maxLength: 25
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @return name The name of the travel agency. * Encoding: ASCII * minLength: 1 character *
   *     maxLength: 25 characters * Must not start with a space or be all spaces. * Must not be all
   *     zeros.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The name of the travel agency. * Encoding: ASCII * minLength: 1 character * maxLength: 25
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param name The name of the travel agency. * Encoding: ASCII * minLength: 1 character *
   *     maxLength: 25 characters * Must not start with a space or be all spaces. * Must not be all
   *     zeros.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /** Return true if this TravelAgency object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TravelAgency travelAgency = (TravelAgency) o;
    return Objects.equals(this.code, travelAgency.code)
        && Objects.equals(this.name, travelAgency.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TravelAgency {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TravelAgency given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TravelAgency
   * @throws JsonProcessingException if the JSON string is invalid with respect to TravelAgency
   */
  public static TravelAgency fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TravelAgency.class);
  }

  /**
   * Convert an instance of TravelAgency to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
