/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** GetTermsOfServiceDocumentRequest */
@JsonPropertyOrder({
  GetTermsOfServiceDocumentRequest.JSON_PROPERTY_LANGUAGE,
  GetTermsOfServiceDocumentRequest.JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT,
  GetTermsOfServiceDocumentRequest.JSON_PROPERTY_TYPE
})
public class GetTermsOfServiceDocumentRequest {
  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT =
      "termsOfServiceDocumentFormat";
  private String termsOfServiceDocumentFormat;

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  public enum TypeEnum {
    ADYENACCOUNT(String.valueOf("adyenAccount")),

    ADYENCAPITAL(String.valueOf("adyenCapital")),

    ADYENCARD(String.valueOf("adyenCard")),

    ADYENCHARGECARD(String.valueOf("adyenChargeCard")),

    ADYENFORPLATFORMSADVANCED(String.valueOf("adyenForPlatformsAdvanced")),

    ADYENFORPLATFORMSMANAGE(String.valueOf("adyenForPlatformsManage")),

    ADYENFRANCHISEE(String.valueOf("adyenFranchisee")),

    ADYENISSUING(String.valueOf("adyenIssuing")),

    ADYENPCCR(String.valueOf("adyenPccr")),

    KYCONINVITE(String.valueOf("kycOnInvite"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public GetTermsOfServiceDocumentRequest() {}

  /**
   * The language to be used for the Terms of Service document, specified by the two-letter [ISO
   * 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. Possible value:
   * **en** for English.
   *
   * @param language The language to be used for the Terms of Service document, specified by the
   *     two-letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language
   *     code. Possible value: **en** for English.
   * @return the current {@code GetTermsOfServiceDocumentRequest} instance, allowing for method
   *     chaining
   */
  public GetTermsOfServiceDocumentRequest language(String language) {
    this.language = language;
    return this;
  }

  /**
   * The language to be used for the Terms of Service document, specified by the two-letter [ISO
   * 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. Possible value:
   * **en** for English.
   *
   * @return language The language to be used for the Terms of Service document, specified by the
   *     two-letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language
   *     code. Possible value: **en** for English.
   */
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLanguage() {
    return language;
  }

  /**
   * The language to be used for the Terms of Service document, specified by the two-letter [ISO
   * 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. Possible value:
   * **en** for English.
   *
   * @param language The language to be used for the Terms of Service document, specified by the
   *     two-letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language
   *     code. Possible value: **en** for English.
   */
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }

  /**
   * The requested format for the Terms of Service document. Default value: JSON. Possible values:
   * **JSON**, **PDF**, or **TXT**.
   *
   * @param termsOfServiceDocumentFormat The requested format for the Terms of Service document.
   *     Default value: JSON. Possible values: **JSON**, **PDF**, or **TXT**.
   * @return the current {@code GetTermsOfServiceDocumentRequest} instance, allowing for method
   *     chaining
   */
  public GetTermsOfServiceDocumentRequest termsOfServiceDocumentFormat(
      String termsOfServiceDocumentFormat) {
    this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
    return this;
  }

  /**
   * The requested format for the Terms of Service document. Default value: JSON. Possible values:
   * **JSON**, **PDF**, or **TXT**.
   *
   * @return termsOfServiceDocumentFormat The requested format for the Terms of Service document.
   *     Default value: JSON. Possible values: **JSON**, **PDF**, or **TXT**.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTermsOfServiceDocumentFormat() {
    return termsOfServiceDocumentFormat;
  }

  /**
   * The requested format for the Terms of Service document. Default value: JSON. Possible values:
   * **JSON**, **PDF**, or **TXT**.
   *
   * @param termsOfServiceDocumentFormat The requested format for the Terms of Service document.
   *     Default value: JSON. Possible values: **JSON**, **PDF**, or **TXT**.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTermsOfServiceDocumentFormat(String termsOfServiceDocumentFormat) {
    this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @param type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   * @return the current {@code GetTermsOfServiceDocumentRequest} instance, allowing for method
   *     chaining
   */
  public GetTermsOfServiceDocumentRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @return type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @param type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this GetTermsOfServiceDocumentRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetTermsOfServiceDocumentRequest getTermsOfServiceDocumentRequest =
        (GetTermsOfServiceDocumentRequest) o;
    return Objects.equals(this.language, getTermsOfServiceDocumentRequest.language)
        && Objects.equals(
            this.termsOfServiceDocumentFormat,
            getTermsOfServiceDocumentRequest.termsOfServiceDocumentFormat)
        && Objects.equals(this.type, getTermsOfServiceDocumentRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(language, termsOfServiceDocumentFormat, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTermsOfServiceDocumentRequest {\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    termsOfServiceDocumentFormat: ")
        .append(toIndentedString(termsOfServiceDocumentFormat))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of GetTermsOfServiceDocumentRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetTermsOfServiceDocumentRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     GetTermsOfServiceDocumentRequest
   */
  public static GetTermsOfServiceDocumentRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetTermsOfServiceDocumentRequest.class);
  }

  /**
   * Convert an instance of GetTermsOfServiceDocumentRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
