/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** OnboardingLinkSettings */
@JsonPropertyOrder({
  OnboardingLinkSettings.JSON_PROPERTY_ACCEPTED_COUNTRIES,
  OnboardingLinkSettings.JSON_PROPERTY_ALLOW_BANK_ACCOUNT_FORMAT_SELECTION,
  OnboardingLinkSettings.JSON_PROPERTY_ALLOW_DEBUG_UI,
  OnboardingLinkSettings.JSON_PROPERTY_ALLOW_INTRA_REGION_CROSS_BORDER_PAYOUT,
  OnboardingLinkSettings.JSON_PROPERTY_CHANGE_LEGAL_ENTITY_TYPE,
  OnboardingLinkSettings.JSON_PROPERTY_EDIT_PREFILLED_COUNTRY,
  OnboardingLinkSettings.JSON_PROPERTY_ENFORCE_LEGAL_AGE,
  OnboardingLinkSettings.JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_INDIVIDUAL,
  OnboardingLinkSettings.JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_ORGANIZATION,
  OnboardingLinkSettings.JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_SOLE_PROPRIETOR,
  OnboardingLinkSettings.JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_TRUST,
  OnboardingLinkSettings.JSON_PROPERTY_INSTANT_BANK_VERIFICATION,
  OnboardingLinkSettings.JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOM_MOTO,
  OnboardingLinkSettings.JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOMMERCE,
  OnboardingLinkSettings.JSON_PROPERTY_REQUIRE_PCI_SIGN_POS,
  OnboardingLinkSettings.JSON_PROPERTY_REQUIRE_PCI_SIGN_POS_MOTO,
  OnboardingLinkSettings.JSON_PROPERTY_TRANSFER_INSTRUMENT_LIMIT
})
public class OnboardingLinkSettings {
  public static final String JSON_PROPERTY_ACCEPTED_COUNTRIES = "acceptedCountries";
  private List<String> acceptedCountries;

  public static final String JSON_PROPERTY_ALLOW_BANK_ACCOUNT_FORMAT_SELECTION =
      "allowBankAccountFormatSelection";
  private Boolean allowBankAccountFormatSelection;

  public static final String JSON_PROPERTY_ALLOW_DEBUG_UI = "allowDebugUi";
  private Boolean allowDebugUi;

  public static final String JSON_PROPERTY_ALLOW_INTRA_REGION_CROSS_BORDER_PAYOUT =
      "allowIntraRegionCrossBorderPayout";
  private Boolean allowIntraRegionCrossBorderPayout;

  public static final String JSON_PROPERTY_CHANGE_LEGAL_ENTITY_TYPE = "changeLegalEntityType";
  private Boolean changeLegalEntityType;

  public static final String JSON_PROPERTY_EDIT_PREFILLED_COUNTRY = "editPrefilledCountry";
  private Boolean editPrefilledCountry;

  public static final String JSON_PROPERTY_ENFORCE_LEGAL_AGE = "enforceLegalAge";
  private Boolean enforceLegalAge;

  public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_INDIVIDUAL =
      "hideOnboardingIntroductionIndividual";
  private Boolean hideOnboardingIntroductionIndividual;

  public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_ORGANIZATION =
      "hideOnboardingIntroductionOrganization";
  private Boolean hideOnboardingIntroductionOrganization;

  public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_SOLE_PROPRIETOR =
      "hideOnboardingIntroductionSoleProprietor";
  private Boolean hideOnboardingIntroductionSoleProprietor;

  public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_TRUST =
      "hideOnboardingIntroductionTrust";
  private Boolean hideOnboardingIntroductionTrust;

  public static final String JSON_PROPERTY_INSTANT_BANK_VERIFICATION = "instantBankVerification";
  private Boolean instantBankVerification;

  public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOM_MOTO = "requirePciSignEcomMoto";
  private Boolean requirePciSignEcomMoto;

  public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOMMERCE = "requirePciSignEcommerce";
  private Boolean requirePciSignEcommerce;

  public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_POS = "requirePciSignPos";
  private Boolean requirePciSignPos;

  public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_POS_MOTO = "requirePciSignPosMoto";
  private Boolean requirePciSignPosMoto;

  public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_LIMIT = "transferInstrumentLimit";
  private Integer transferInstrumentLimit;

  public OnboardingLinkSettings() {}

  /**
   * The list of countries the user can choose from in hosted onboarding when
   * &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format. The array is
   * empty by default, allowing all [countries and regions supported by hosted
   * onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   *
   * @param acceptedCountries The list of countries the user can choose from in hosted onboarding
   *     when &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character
   *     [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format.
   *     The array is empty by default, allowing all [countries and regions supported by hosted
   *     onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings acceptedCountries(List<String> acceptedCountries) {
    this.acceptedCountries = acceptedCountries;
    return this;
  }

  public OnboardingLinkSettings addAcceptedCountriesItem(String acceptedCountriesItem) {
    if (this.acceptedCountries == null) {
      this.acceptedCountries = new ArrayList<>();
    }
    this.acceptedCountries.add(acceptedCountriesItem);
    return this;
  }

  /**
   * The list of countries the user can choose from in hosted onboarding when
   * &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format. The array is
   * empty by default, allowing all [countries and regions supported by hosted
   * onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   *
   * @return acceptedCountries The list of countries the user can choose from in hosted onboarding
   *     when &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character
   *     [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format.
   *     The array is empty by default, allowing all [countries and regions supported by hosted
   *     onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAcceptedCountries() {
    return acceptedCountries;
  }

  /**
   * The list of countries the user can choose from in hosted onboarding when
   * &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format. The array is
   * empty by default, allowing all [countries and regions supported by hosted
   * onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   *
   * @param acceptedCountries The list of countries the user can choose from in hosted onboarding
   *     when &#x60;editPrefilledCountry&#x60; is allowed. The value must be in the two-character
   *     [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format.
   *     The array is empty by default, allowing all [countries and regions supported by hosted
   *     onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcceptedCountries(List<String> acceptedCountries) {
    this.acceptedCountries = acceptedCountries;
  }

  /**
   * Default value: **false** Indicates if the user can select the format for their payout account
   * (if applicable).
   *
   * @param allowBankAccountFormatSelection Default value: **false** Indicates if the user can
   *     select the format for their payout account (if applicable).
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings allowBankAccountFormatSelection(
      Boolean allowBankAccountFormatSelection) {
    this.allowBankAccountFormatSelection = allowBankAccountFormatSelection;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user can select the format for their payout account
   * (if applicable).
   *
   * @return allowBankAccountFormatSelection Default value: **false** Indicates if the user can
   *     select the format for their payout account (if applicable).
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_BANK_ACCOUNT_FORMAT_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowBankAccountFormatSelection() {
    return allowBankAccountFormatSelection;
  }

  /**
   * Default value: **false** Indicates if the user can select the format for their payout account
   * (if applicable).
   *
   * @param allowBankAccountFormatSelection Default value: **false** Indicates if the user can
   *     select the format for their payout account (if applicable).
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_BANK_ACCOUNT_FORMAT_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowBankAccountFormatSelection(Boolean allowBankAccountFormatSelection) {
    this.allowBankAccountFormatSelection = allowBankAccountFormatSelection;
  }

  /**
   * Default value: **true** Indicates whether the debug user interface (UI) is enabled. The debug
   * UI provides information for your support staff to diagnose and resolve user issues during
   * onboarding. It can be accessed using a keyboard shortcut.
   *
   * @param allowDebugUi Default value: **true** Indicates whether the debug user interface (UI) is
   *     enabled. The debug UI provides information for your support staff to diagnose and resolve
   *     user issues during onboarding. It can be accessed using a keyboard shortcut.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings allowDebugUi(Boolean allowDebugUi) {
    this.allowDebugUi = allowDebugUi;
    return this;
  }

  /**
   * Default value: **true** Indicates whether the debug user interface (UI) is enabled. The debug
   * UI provides information for your support staff to diagnose and resolve user issues during
   * onboarding. It can be accessed using a keyboard shortcut.
   *
   * @return allowDebugUi Default value: **true** Indicates whether the debug user interface (UI) is
   *     enabled. The debug UI provides information for your support staff to diagnose and resolve
   *     user issues during onboarding. It can be accessed using a keyboard shortcut.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_DEBUG_UI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowDebugUi() {
    return allowDebugUi;
  }

  /**
   * Default value: **true** Indicates whether the debug user interface (UI) is enabled. The debug
   * UI provides information for your support staff to diagnose and resolve user issues during
   * onboarding. It can be accessed using a keyboard shortcut.
   *
   * @param allowDebugUi Default value: **true** Indicates whether the debug user interface (UI) is
   *     enabled. The debug UI provides information for your support staff to diagnose and resolve
   *     user issues during onboarding. It can be accessed using a keyboard shortcut.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_DEBUG_UI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowDebugUi(Boolean allowDebugUi) {
    this.allowDebugUi = allowDebugUi;
  }

  /**
   * Default value: **false** Indicates if the user can select a payout account in a different
   * EU/EEA location (including Switzerland and the UK) than the location of their legal entity.
   *
   * @param allowIntraRegionCrossBorderPayout Default value: **false** Indicates if the user can
   *     select a payout account in a different EU/EEA location (including Switzerland and the UK)
   *     than the location of their legal entity.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings allowIntraRegionCrossBorderPayout(
      Boolean allowIntraRegionCrossBorderPayout) {
    this.allowIntraRegionCrossBorderPayout = allowIntraRegionCrossBorderPayout;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user can select a payout account in a different
   * EU/EEA location (including Switzerland and the UK) than the location of their legal entity.
   *
   * @return allowIntraRegionCrossBorderPayout Default value: **false** Indicates if the user can
   *     select a payout account in a different EU/EEA location (including Switzerland and the UK)
   *     than the location of their legal entity.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_INTRA_REGION_CROSS_BORDER_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowIntraRegionCrossBorderPayout() {
    return allowIntraRegionCrossBorderPayout;
  }

  /**
   * Default value: **false** Indicates if the user can select a payout account in a different
   * EU/EEA location (including Switzerland and the UK) than the location of their legal entity.
   *
   * @param allowIntraRegionCrossBorderPayout Default value: **false** Indicates if the user can
   *     select a payout account in a different EU/EEA location (including Switzerland and the UK)
   *     than the location of their legal entity.
   */
  @JsonProperty(JSON_PROPERTY_ALLOW_INTRA_REGION_CROSS_BORDER_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowIntraRegionCrossBorderPayout(Boolean allowIntraRegionCrossBorderPayout) {
    this.allowIntraRegionCrossBorderPayout = allowIntraRegionCrossBorderPayout;
  }

  /**
   * Default value: **true** Indicates if the user can change their legal entity type.
   *
   * @param changeLegalEntityType Default value: **true** Indicates if the user can change their
   *     legal entity type.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings changeLegalEntityType(Boolean changeLegalEntityType) {
    this.changeLegalEntityType = changeLegalEntityType;
    return this;
  }

  /**
   * Default value: **true** Indicates if the user can change their legal entity type.
   *
   * @return changeLegalEntityType Default value: **true** Indicates if the user can change their
   *     legal entity type.
   */
  @JsonProperty(JSON_PROPERTY_CHANGE_LEGAL_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getChangeLegalEntityType() {
    return changeLegalEntityType;
  }

  /**
   * Default value: **true** Indicates if the user can change their legal entity type.
   *
   * @param changeLegalEntityType Default value: **true** Indicates if the user can change their
   *     legal entity type.
   */
  @JsonProperty(JSON_PROPERTY_CHANGE_LEGAL_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeLegalEntityType(Boolean changeLegalEntityType) {
    this.changeLegalEntityType = changeLegalEntityType;
  }

  /**
   * Default value: **true** Indicates if the user can change the country of their legal
   * entity&#39;s address, for example the registered address of an organization.
   *
   * @param editPrefilledCountry Default value: **true** Indicates if the user can change the
   *     country of their legal entity&#39;s address, for example the registered address of an
   *     organization.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings editPrefilledCountry(Boolean editPrefilledCountry) {
    this.editPrefilledCountry = editPrefilledCountry;
    return this;
  }

  /**
   * Default value: **true** Indicates if the user can change the country of their legal
   * entity&#39;s address, for example the registered address of an organization.
   *
   * @return editPrefilledCountry Default value: **true** Indicates if the user can change the
   *     country of their legal entity&#39;s address, for example the registered address of an
   *     organization.
   */
  @JsonProperty(JSON_PROPERTY_EDIT_PREFILLED_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEditPrefilledCountry() {
    return editPrefilledCountry;
  }

  /**
   * Default value: **true** Indicates if the user can change the country of their legal
   * entity&#39;s address, for example the registered address of an organization.
   *
   * @param editPrefilledCountry Default value: **true** Indicates if the user can change the
   *     country of their legal entity&#39;s address, for example the registered address of an
   *     organization.
   */
  @JsonProperty(JSON_PROPERTY_EDIT_PREFILLED_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditPrefilledCountry(Boolean editPrefilledCountry) {
    this.editPrefilledCountry = editPrefilledCountry;
  }

  /**
   * Default value: **false** Indicates if only users above the age of 18 can be onboarded.
   *
   * @param enforceLegalAge Default value: **false** Indicates if only users above the age of 18 can
   *     be onboarded.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings enforceLegalAge(Boolean enforceLegalAge) {
    this.enforceLegalAge = enforceLegalAge;
    return this;
  }

  /**
   * Default value: **false** Indicates if only users above the age of 18 can be onboarded.
   *
   * @return enforceLegalAge Default value: **false** Indicates if only users above the age of 18
   *     can be onboarded.
   */
  @JsonProperty(JSON_PROPERTY_ENFORCE_LEGAL_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnforceLegalAge() {
    return enforceLegalAge;
  }

  /**
   * Default value: **false** Indicates if only users above the age of 18 can be onboarded.
   *
   * @param enforceLegalAge Default value: **false** Indicates if only users above the age of 18 can
   *     be onboarded.
   */
  @JsonProperty(JSON_PROPERTY_ENFORCE_LEGAL_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnforceLegalAge(Boolean enforceLegalAge) {
    this.enforceLegalAge = enforceLegalAge;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * individual legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionIndividual Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the individual legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings hideOnboardingIntroductionIndividual(
      Boolean hideOnboardingIntroductionIndividual) {
    this.hideOnboardingIntroductionIndividual = hideOnboardingIntroductionIndividual;
    return this;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * individual legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @return hideOnboardingIntroductionIndividual Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the individual legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_INDIVIDUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHideOnboardingIntroductionIndividual() {
    return hideOnboardingIntroductionIndividual;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * individual legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionIndividual Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the individual legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_INDIVIDUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideOnboardingIntroductionIndividual(
      Boolean hideOnboardingIntroductionIndividual) {
    this.hideOnboardingIntroductionIndividual = hideOnboardingIntroductionIndividual;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * organization legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionOrganization Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the organization legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings hideOnboardingIntroductionOrganization(
      Boolean hideOnboardingIntroductionOrganization) {
    this.hideOnboardingIntroductionOrganization = hideOnboardingIntroductionOrganization;
    return this;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * organization legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @return hideOnboardingIntroductionOrganization Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the organization legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_ORGANIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHideOnboardingIntroductionOrganization() {
    return hideOnboardingIntroductionOrganization;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * organization legal entity type. The introduction screen provides brief instructions for the
   * subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionOrganization Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the organization legal entity type. The
   *     introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_ORGANIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideOnboardingIntroductionOrganization(
      Boolean hideOnboardingIntroductionOrganization) {
    this.hideOnboardingIntroductionOrganization = hideOnboardingIntroductionOrganization;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * sole proprietorship legal entity type. The introduction screen provides brief instructions for
   * the subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionSoleProprietor Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the sole proprietorship legal entity type.
   *     The introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings hideOnboardingIntroductionSoleProprietor(
      Boolean hideOnboardingIntroductionSoleProprietor) {
    this.hideOnboardingIntroductionSoleProprietor = hideOnboardingIntroductionSoleProprietor;
    return this;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * sole proprietorship legal entity type. The introduction screen provides brief instructions for
   * the subsequent steps in the hosted onboarding process.
   *
   * @return hideOnboardingIntroductionSoleProprietor Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the sole proprietorship legal entity type.
   *     The introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_SOLE_PROPRIETOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHideOnboardingIntroductionSoleProprietor() {
    return hideOnboardingIntroductionSoleProprietor;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * sole proprietorship legal entity type. The introduction screen provides brief instructions for
   * the subsequent steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionSoleProprietor Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the sole proprietorship legal entity type.
   *     The introduction screen provides brief instructions for the subsequent steps in the hosted
   *     onboarding process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_SOLE_PROPRIETOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideOnboardingIntroductionSoleProprietor(
      Boolean hideOnboardingIntroductionSoleProprietor) {
    this.hideOnboardingIntroductionSoleProprietor = hideOnboardingIntroductionSoleProprietor;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * trust legal entity type. The introduction screen provides brief instructions for the subsequent
   * steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionTrust Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the trust legal entity type. The introduction
   *     screen provides brief instructions for the subsequent steps in the hosted onboarding
   *     process.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings hideOnboardingIntroductionTrust(
      Boolean hideOnboardingIntroductionTrust) {
    this.hideOnboardingIntroductionTrust = hideOnboardingIntroductionTrust;
    return this;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * trust legal entity type. The introduction screen provides brief instructions for the subsequent
   * steps in the hosted onboarding process.
   *
   * @return hideOnboardingIntroductionTrust Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the trust legal entity type. The introduction
   *     screen provides brief instructions for the subsequent steps in the hosted onboarding
   *     process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_TRUST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHideOnboardingIntroductionTrust() {
    return hideOnboardingIntroductionTrust;
  }

  /**
   * Default value: **true** Indicates whether the introduction screen is hidden for the user of the
   * trust legal entity type. The introduction screen provides brief instructions for the subsequent
   * steps in the hosted onboarding process.
   *
   * @param hideOnboardingIntroductionTrust Default value: **true** Indicates whether the
   *     introduction screen is hidden for the user of the trust legal entity type. The introduction
   *     screen provides brief instructions for the subsequent steps in the hosted onboarding
   *     process.
   */
  @JsonProperty(JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_TRUST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideOnboardingIntroductionTrust(Boolean hideOnboardingIntroductionTrust) {
    this.hideOnboardingIntroductionTrust = hideOnboardingIntroductionTrust;
  }

  /**
   * Default value: **true** Indicates if the user can initiate the verification process through
   * open banking providers, like Plaid or Tink.
   *
   * @param instantBankVerification Default value: **true** Indicates if the user can initiate the
   *     verification process through open banking providers, like Plaid or Tink.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings instantBankVerification(Boolean instantBankVerification) {
    this.instantBankVerification = instantBankVerification;
    return this;
  }

  /**
   * Default value: **true** Indicates if the user can initiate the verification process through
   * open banking providers, like Plaid or Tink.
   *
   * @return instantBankVerification Default value: **true** Indicates if the user can initiate the
   *     verification process through open banking providers, like Plaid or Tink.
   */
  @JsonProperty(JSON_PROPERTY_INSTANT_BANK_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getInstantBankVerification() {
    return instantBankVerification;
  }

  /**
   * Default value: **true** Indicates if the user can initiate the verification process through
   * open banking providers, like Plaid or Tink.
   *
   * @param instantBankVerification Default value: **true** Indicates if the user can initiate the
   *     verification process through open banking providers, like Plaid or Tink.
   */
  @JsonProperty(JSON_PROPERTY_INSTANT_BANK_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstantBankVerification(Boolean instantBankVerification) {
    this.instantBankVerification = instantBankVerification;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **ecomMoto** sales channel type.
   *
   * @param requirePciSignEcomMoto Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **ecomMoto** sales channel type.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings requirePciSignEcomMoto(Boolean requirePciSignEcomMoto) {
    this.requirePciSignEcomMoto = requirePciSignEcomMoto;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **ecomMoto** sales channel type.
   *
   * @return requirePciSignEcomMoto Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **ecomMoto** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOM_MOTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequirePciSignEcomMoto() {
    return requirePciSignEcomMoto;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **ecomMoto** sales channel type.
   *
   * @param requirePciSignEcomMoto Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **ecomMoto** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOM_MOTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequirePciSignEcomMoto(Boolean requirePciSignEcomMoto) {
    this.requirePciSignEcomMoto = requirePciSignEcomMoto;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **eCommerce** sales channel type.
   *
   * @param requirePciSignEcommerce Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **eCommerce** sales channel type.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings requirePciSignEcommerce(Boolean requirePciSignEcommerce) {
    this.requirePciSignEcommerce = requirePciSignEcommerce;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **eCommerce** sales channel type.
   *
   * @return requirePciSignEcommerce Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **eCommerce** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOMMERCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequirePciSignEcommerce() {
    return requirePciSignEcommerce;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **eCommerce** sales channel type.
   *
   * @param requirePciSignEcommerce Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **eCommerce** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOMMERCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequirePciSignEcommerce(Boolean requirePciSignEcommerce) {
    this.requirePciSignEcommerce = requirePciSignEcommerce;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **pos** sales channel type.
   *
   * @param requirePciSignPos Default value: **false** Indicates if the user is required to sign a
   *     PCI questionnaires for the **pos** sales channel type.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings requirePciSignPos(Boolean requirePciSignPos) {
    this.requirePciSignPos = requirePciSignPos;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **pos** sales channel type.
   *
   * @return requirePciSignPos Default value: **false** Indicates if the user is required to sign a
   *     PCI questionnaires for the **pos** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequirePciSignPos() {
    return requirePciSignPos;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **pos** sales channel type.
   *
   * @param requirePciSignPos Default value: **false** Indicates if the user is required to sign a
   *     PCI questionnaires for the **pos** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequirePciSignPos(Boolean requirePciSignPos) {
    this.requirePciSignPos = requirePciSignPos;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **posMoto** sales channel type.
   *
   * @param requirePciSignPosMoto Default value: **false** Indicates if the user is required to sign
   *     a PCI questionnaires for the **posMoto** sales channel type.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings requirePciSignPosMoto(Boolean requirePciSignPosMoto) {
    this.requirePciSignPosMoto = requirePciSignPosMoto;
    return this;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **posMoto** sales channel type.
   *
   * @return requirePciSignPosMoto Default value: **false** Indicates if the user is required to
   *     sign a PCI questionnaires for the **posMoto** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_POS_MOTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequirePciSignPosMoto() {
    return requirePciSignPosMoto;
  }

  /**
   * Default value: **false** Indicates if the user is required to sign a PCI questionnaires for the
   * **posMoto** sales channel type.
   *
   * @param requirePciSignPosMoto Default value: **false** Indicates if the user is required to sign
   *     a PCI questionnaires for the **posMoto** sales channel type.
   */
  @JsonProperty(JSON_PROPERTY_REQUIRE_PCI_SIGN_POS_MOTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequirePciSignPosMoto(Boolean requirePciSignPosMoto) {
    this.requirePciSignPosMoto = requirePciSignPosMoto;
  }

  /**
   * The maximum number of transfer instruments the user can create.
   *
   * @param transferInstrumentLimit The maximum number of transfer instruments the user can create.
   * @return the current {@code OnboardingLinkSettings} instance, allowing for method chaining
   */
  public OnboardingLinkSettings transferInstrumentLimit(Integer transferInstrumentLimit) {
    this.transferInstrumentLimit = transferInstrumentLimit;
    return this;
  }

  /**
   * The maximum number of transfer instruments the user can create.
   *
   * @return transferInstrumentLimit The maximum number of transfer instruments the user can create.
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTransferInstrumentLimit() {
    return transferInstrumentLimit;
  }

  /**
   * The maximum number of transfer instruments the user can create.
   *
   * @param transferInstrumentLimit The maximum number of transfer instruments the user can create.
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferInstrumentLimit(Integer transferInstrumentLimit) {
    this.transferInstrumentLimit = transferInstrumentLimit;
  }

  /** Return true if this OnboardingLinkSettings object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OnboardingLinkSettings onboardingLinkSettings = (OnboardingLinkSettings) o;
    return Objects.equals(this.acceptedCountries, onboardingLinkSettings.acceptedCountries)
        && Objects.equals(
            this.allowBankAccountFormatSelection,
            onboardingLinkSettings.allowBankAccountFormatSelection)
        && Objects.equals(this.allowDebugUi, onboardingLinkSettings.allowDebugUi)
        && Objects.equals(
            this.allowIntraRegionCrossBorderPayout,
            onboardingLinkSettings.allowIntraRegionCrossBorderPayout)
        && Objects.equals(this.changeLegalEntityType, onboardingLinkSettings.changeLegalEntityType)
        && Objects.equals(this.editPrefilledCountry, onboardingLinkSettings.editPrefilledCountry)
        && Objects.equals(this.enforceLegalAge, onboardingLinkSettings.enforceLegalAge)
        && Objects.equals(
            this.hideOnboardingIntroductionIndividual,
            onboardingLinkSettings.hideOnboardingIntroductionIndividual)
        && Objects.equals(
            this.hideOnboardingIntroductionOrganization,
            onboardingLinkSettings.hideOnboardingIntroductionOrganization)
        && Objects.equals(
            this.hideOnboardingIntroductionSoleProprietor,
            onboardingLinkSettings.hideOnboardingIntroductionSoleProprietor)
        && Objects.equals(
            this.hideOnboardingIntroductionTrust,
            onboardingLinkSettings.hideOnboardingIntroductionTrust)
        && Objects.equals(
            this.instantBankVerification, onboardingLinkSettings.instantBankVerification)
        && Objects.equals(
            this.requirePciSignEcomMoto, onboardingLinkSettings.requirePciSignEcomMoto)
        && Objects.equals(
            this.requirePciSignEcommerce, onboardingLinkSettings.requirePciSignEcommerce)
        && Objects.equals(this.requirePciSignPos, onboardingLinkSettings.requirePciSignPos)
        && Objects.equals(this.requirePciSignPosMoto, onboardingLinkSettings.requirePciSignPosMoto)
        && Objects.equals(
            this.transferInstrumentLimit, onboardingLinkSettings.transferInstrumentLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        acceptedCountries,
        allowBankAccountFormatSelection,
        allowDebugUi,
        allowIntraRegionCrossBorderPayout,
        changeLegalEntityType,
        editPrefilledCountry,
        enforceLegalAge,
        hideOnboardingIntroductionIndividual,
        hideOnboardingIntroductionOrganization,
        hideOnboardingIntroductionSoleProprietor,
        hideOnboardingIntroductionTrust,
        instantBankVerification,
        requirePciSignEcomMoto,
        requirePciSignEcommerce,
        requirePciSignPos,
        requirePciSignPosMoto,
        transferInstrumentLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OnboardingLinkSettings {\n");
    sb.append("    acceptedCountries: ").append(toIndentedString(acceptedCountries)).append("\n");
    sb.append("    allowBankAccountFormatSelection: ")
        .append(toIndentedString(allowBankAccountFormatSelection))
        .append("\n");
    sb.append("    allowDebugUi: ").append(toIndentedString(allowDebugUi)).append("\n");
    sb.append("    allowIntraRegionCrossBorderPayout: ")
        .append(toIndentedString(allowIntraRegionCrossBorderPayout))
        .append("\n");
    sb.append("    changeLegalEntityType: ")
        .append(toIndentedString(changeLegalEntityType))
        .append("\n");
    sb.append("    editPrefilledCountry: ")
        .append(toIndentedString(editPrefilledCountry))
        .append("\n");
    sb.append("    enforceLegalAge: ").append(toIndentedString(enforceLegalAge)).append("\n");
    sb.append("    hideOnboardingIntroductionIndividual: ")
        .append(toIndentedString(hideOnboardingIntroductionIndividual))
        .append("\n");
    sb.append("    hideOnboardingIntroductionOrganization: ")
        .append(toIndentedString(hideOnboardingIntroductionOrganization))
        .append("\n");
    sb.append("    hideOnboardingIntroductionSoleProprietor: ")
        .append(toIndentedString(hideOnboardingIntroductionSoleProprietor))
        .append("\n");
    sb.append("    hideOnboardingIntroductionTrust: ")
        .append(toIndentedString(hideOnboardingIntroductionTrust))
        .append("\n");
    sb.append("    instantBankVerification: ")
        .append(toIndentedString(instantBankVerification))
        .append("\n");
    sb.append("    requirePciSignEcomMoto: ")
        .append(toIndentedString(requirePciSignEcomMoto))
        .append("\n");
    sb.append("    requirePciSignEcommerce: ")
        .append(toIndentedString(requirePciSignEcommerce))
        .append("\n");
    sb.append("    requirePciSignPos: ").append(toIndentedString(requirePciSignPos)).append("\n");
    sb.append("    requirePciSignPosMoto: ")
        .append(toIndentedString(requirePciSignPosMoto))
        .append("\n");
    sb.append("    transferInstrumentLimit: ")
        .append(toIndentedString(transferInstrumentLimit))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of OnboardingLinkSettings given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of OnboardingLinkSettings
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     OnboardingLinkSettings
   */
  public static OnboardingLinkSettings fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, OnboardingLinkSettings.class);
  }

  /**
   * Convert an instance of OnboardingLinkSettings to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
