/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Organization */
@JsonPropertyOrder({
  Organization.JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW,
  Organization.JSON_PROPERTY_DATE_OF_INCORPORATION,
  Organization.JSON_PROPERTY_DESCRIPTION,
  Organization.JSON_PROPERTY_DOING_BUSINESS_AS,
  Organization.JSON_PROPERTY_EMAIL,
  Organization.JSON_PROPERTY_FINANCIAL_REPORTS,
  Organization.JSON_PROPERTY_LEGAL_NAME,
  Organization.JSON_PROPERTY_PHONE,
  Organization.JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS,
  Organization.JSON_PROPERTY_REGISTERED_ADDRESS,
  Organization.JSON_PROPERTY_REGISTRATION_NUMBER,
  Organization.JSON_PROPERTY_STOCK_DATA,
  Organization.JSON_PROPERTY_TAX_INFORMATION,
  Organization.JSON_PROPERTY_TAX_REPORTING_CLASSIFICATION,
  Organization.JSON_PROPERTY_TYPE,
  Organization.JSON_PROPERTY_VAT_ABSENCE_REASON,
  Organization.JSON_PROPERTY_VAT_NUMBER,
  Organization.JSON_PROPERTY_WEB_DATA
})
public class Organization {
  public static final String JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW = "countryOfGoverningLaw";
  private String countryOfGoverningLaw;

  public static final String JSON_PROPERTY_DATE_OF_INCORPORATION = "dateOfIncorporation";
  private String dateOfIncorporation;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DOING_BUSINESS_AS = "doingBusinessAs";
  private String doingBusinessAs;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FINANCIAL_REPORTS = "financialReports";
  private List<FinancialReport> financialReports;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private PhoneNumber phone;

  public static final String JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS = "principalPlaceOfBusiness";
  private Address principalPlaceOfBusiness;

  public static final String JSON_PROPERTY_REGISTERED_ADDRESS = "registeredAddress";
  private Address registeredAddress;

  public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
  private String registrationNumber;

  public static final String JSON_PROPERTY_STOCK_DATA = "stockData";
  private StockData stockData;

  public static final String JSON_PROPERTY_TAX_INFORMATION = "taxInformation";
  private List<TaxInformation> taxInformation;

  public static final String JSON_PROPERTY_TAX_REPORTING_CLASSIFICATION =
      "taxReportingClassification";
  private TaxReportingClassification taxReportingClassification;

  /**
   * Type of organization. Possible values: **associationIncorporated**,
   * **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   * **partnershipIncorporated**, **privateCompany**.
   */
  public enum TypeEnum {
    ASSOCIATIONINCORPORATED(String.valueOf("associationIncorporated")),

    GOVERNMENTALORGANIZATION(String.valueOf("governmentalOrganization")),

    LISTEDPUBLICCOMPANY(String.valueOf("listedPublicCompany")),

    NONPROFIT(String.valueOf("nonProfit")),

    PARTNERSHIPINCORPORATED(String.valueOf("partnershipIncorporated")),

    PRIVATECOMPANY(String.valueOf("privateCompany"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * The reason the organization has not provided a VAT number. Possible values:
   * **industryExemption**, **belowTaxThreshold**.
   */
  public enum VatAbsenceReasonEnum {
    INDUSTRYEXEMPTION(String.valueOf("industryExemption")),

    BELOWTAXTHRESHOLD(String.valueOf("belowTaxThreshold"));

    private String value;

    VatAbsenceReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VatAbsenceReasonEnum fromValue(String value) {
      for (VatAbsenceReasonEnum b : VatAbsenceReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VAT_ABSENCE_REASON = "vatAbsenceReason";
  private VatAbsenceReasonEnum vatAbsenceReason;

  public static final String JSON_PROPERTY_VAT_NUMBER = "vatNumber";
  private String vatNumber;

  public static final String JSON_PROPERTY_WEB_DATA = "webData";
  private WebData webData;

  public Organization() {}

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code of the governing country.
   *
   * @param countryOfGoverningLaw The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the governing
   *     country.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization countryOfGoverningLaw(String countryOfGoverningLaw) {
    this.countryOfGoverningLaw = countryOfGoverningLaw;
    return this;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code of the governing country.
   *
   * @return countryOfGoverningLaw The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the governing
   *     country.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountryOfGoverningLaw() {
    return countryOfGoverningLaw;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code of the governing country.
   *
   * @param countryOfGoverningLaw The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the governing
   *     country.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryOfGoverningLaw(String countryOfGoverningLaw) {
    this.countryOfGoverningLaw = countryOfGoverningLaw;
  }

  /**
   * The date when the organization was incorporated in YYYY-MM-DD format.
   *
   * @param dateOfIncorporation The date when the organization was incorporated in YYYY-MM-DD
   *     format.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization dateOfIncorporation(String dateOfIncorporation) {
    this.dateOfIncorporation = dateOfIncorporation;
    return this;
  }

  /**
   * The date when the organization was incorporated in YYYY-MM-DD format.
   *
   * @return dateOfIncorporation The date when the organization was incorporated in YYYY-MM-DD
   *     format.
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDateOfIncorporation() {
    return dateOfIncorporation;
  }

  /**
   * The date when the organization was incorporated in YYYY-MM-DD format.
   *
   * @param dateOfIncorporation The date when the organization was incorporated in YYYY-MM-DD
   *     format.
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfIncorporation(String dateOfIncorporation) {
    this.dateOfIncorporation = dateOfIncorporation;
  }

  /**
   * Your description for the organization.
   *
   * @param description Your description for the organization.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Your description for the organization.
   *
   * @return description Your description for the organization.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Your description for the organization.
   *
   * @param description Your description for the organization.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The organization&#39;s trading name, if different from the registered legal name.
   *
   * @param doingBusinessAs The organization&#39;s trading name, if different from the registered
   *     legal name.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization doingBusinessAs(String doingBusinessAs) {
    this.doingBusinessAs = doingBusinessAs;
    return this;
  }

  /**
   * The organization&#39;s trading name, if different from the registered legal name.
   *
   * @return doingBusinessAs The organization&#39;s trading name, if different from the registered
   *     legal name.
   */
  @JsonProperty(JSON_PROPERTY_DOING_BUSINESS_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDoingBusinessAs() {
    return doingBusinessAs;
  }

  /**
   * The organization&#39;s trading name, if different from the registered legal name.
   *
   * @param doingBusinessAs The organization&#39;s trading name, if different from the registered
   *     legal name.
   */
  @JsonProperty(JSON_PROPERTY_DOING_BUSINESS_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDoingBusinessAs(String doingBusinessAs) {
    this.doingBusinessAs = doingBusinessAs;
  }

  /**
   * The email address of the legal entity.
   *
   * @param email The email address of the legal entity.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address of the legal entity.
   *
   * @return email The email address of the legal entity.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  /**
   * The email address of the legal entity.
   *
   * @param email The email address of the legal entity.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * The financial report information of the organization.
   *
   * @param financialReports The financial report information of the organization.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization financialReports(List<FinancialReport> financialReports) {
    this.financialReports = financialReports;
    return this;
  }

  public Organization addFinancialReportsItem(FinancialReport financialReportsItem) {
    if (this.financialReports == null) {
      this.financialReports = new ArrayList<>();
    }
    this.financialReports.add(financialReportsItem);
    return this;
  }

  /**
   * The financial report information of the organization.
   *
   * @return financialReports The financial report information of the organization.
   */
  @JsonProperty(JSON_PROPERTY_FINANCIAL_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<FinancialReport> getFinancialReports() {
    return financialReports;
  }

  /**
   * The financial report information of the organization.
   *
   * @param financialReports The financial report information of the organization.
   */
  @JsonProperty(JSON_PROPERTY_FINANCIAL_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFinancialReports(List<FinancialReport> financialReports) {
    this.financialReports = financialReports;
  }

  /**
   * The organization&#39;s legal name.
   *
   * @param legalName The organization&#39;s legal name.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization legalName(String legalName) {
    this.legalName = legalName;
    return this;
  }

  /**
   * The organization&#39;s legal name.
   *
   * @return legalName The organization&#39;s legal name.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalName() {
    return legalName;
  }

  /**
   * The organization&#39;s legal name.
   *
   * @param legalName The organization&#39;s legal name.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }

  /**
   * phone
   *
   * @param phone
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization phone(PhoneNumber phone) {
    this.phone = phone;
    return this;
  }

  /**
   * Get phone
   *
   * @return phone
   */
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PhoneNumber getPhone() {
    return phone;
  }

  /**
   * phone
   *
   * @param phone
   */
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(PhoneNumber phone) {
    this.phone = phone;
  }

  /**
   * principalPlaceOfBusiness
   *
   * @param principalPlaceOfBusiness
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization principalPlaceOfBusiness(Address principalPlaceOfBusiness) {
    this.principalPlaceOfBusiness = principalPlaceOfBusiness;
    return this;
  }

  /**
   * Get principalPlaceOfBusiness
   *
   * @return principalPlaceOfBusiness
   */
  @JsonProperty(JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getPrincipalPlaceOfBusiness() {
    return principalPlaceOfBusiness;
  }

  /**
   * principalPlaceOfBusiness
   *
   * @param principalPlaceOfBusiness
   */
  @JsonProperty(JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrincipalPlaceOfBusiness(Address principalPlaceOfBusiness) {
    this.principalPlaceOfBusiness = principalPlaceOfBusiness;
  }

  /**
   * registeredAddress
   *
   * @param registeredAddress
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization registeredAddress(Address registeredAddress) {
    this.registeredAddress = registeredAddress;
    return this;
  }

  /**
   * Get registeredAddress
   *
   * @return registeredAddress
   */
  @JsonProperty(JSON_PROPERTY_REGISTERED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getRegisteredAddress() {
    return registeredAddress;
  }

  /**
   * registeredAddress
   *
   * @param registeredAddress
   */
  @JsonProperty(JSON_PROPERTY_REGISTERED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegisteredAddress(Address registeredAddress) {
    this.registeredAddress = registeredAddress;
  }

  /**
   * The organization&#39;s registration number.
   *
   * @param registrationNumber The organization&#39;s registration number.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization registrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
    return this;
  }

  /**
   * The organization&#39;s registration number.
   *
   * @return registrationNumber The organization&#39;s registration number.
   */
  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRegistrationNumber() {
    return registrationNumber;
  }

  /**
   * The organization&#39;s registration number.
   *
   * @param registrationNumber The organization&#39;s registration number.
   */
  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegistrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
  }

  /**
   * stockData
   *
   * @param stockData
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization stockData(StockData stockData) {
    this.stockData = stockData;
    return this;
  }

  /**
   * Get stockData
   *
   * @return stockData
   */
  @JsonProperty(JSON_PROPERTY_STOCK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StockData getStockData() {
    return stockData;
  }

  /**
   * stockData
   *
   * @param stockData
   */
  @JsonProperty(JSON_PROPERTY_STOCK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockData(StockData stockData) {
    this.stockData = stockData;
  }

  /**
   * The tax information of the organization.
   *
   * @param taxInformation The tax information of the organization.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization taxInformation(List<TaxInformation> taxInformation) {
    this.taxInformation = taxInformation;
    return this;
  }

  public Organization addTaxInformationItem(TaxInformation taxInformationItem) {
    if (this.taxInformation == null) {
      this.taxInformation = new ArrayList<>();
    }
    this.taxInformation.add(taxInformationItem);
    return this;
  }

  /**
   * The tax information of the organization.
   *
   * @return taxInformation The tax information of the organization.
   */
  @JsonProperty(JSON_PROPERTY_TAX_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TaxInformation> getTaxInformation() {
    return taxInformation;
  }

  /**
   * The tax information of the organization.
   *
   * @param taxInformation The tax information of the organization.
   */
  @JsonProperty(JSON_PROPERTY_TAX_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxInformation(List<TaxInformation> taxInformation) {
    this.taxInformation = taxInformation;
  }

  /**
   * taxReportingClassification
   *
   * @param taxReportingClassification
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization taxReportingClassification(
      TaxReportingClassification taxReportingClassification) {
    this.taxReportingClassification = taxReportingClassification;
    return this;
  }

  /**
   * Get taxReportingClassification
   *
   * @return taxReportingClassification
   */
  @JsonProperty(JSON_PROPERTY_TAX_REPORTING_CLASSIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TaxReportingClassification getTaxReportingClassification() {
    return taxReportingClassification;
  }

  /**
   * taxReportingClassification
   *
   * @param taxReportingClassification
   */
  @JsonProperty(JSON_PROPERTY_TAX_REPORTING_CLASSIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxReportingClassification(TaxReportingClassification taxReportingClassification) {
    this.taxReportingClassification = taxReportingClassification;
  }

  /**
   * Type of organization. Possible values: **associationIncorporated**,
   * **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   * **partnershipIncorporated**, **privateCompany**.
   *
   * @param type Type of organization. Possible values: **associationIncorporated**,
   *     **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   *     **partnershipIncorporated**, **privateCompany**.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of organization. Possible values: **associationIncorporated**,
   * **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   * **partnershipIncorporated**, **privateCompany**.
   *
   * @return type Type of organization. Possible values: **associationIncorporated**,
   *     **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   *     **partnershipIncorporated**, **privateCompany**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of organization. Possible values: **associationIncorporated**,
   * **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   * **partnershipIncorporated**, **privateCompany**.
   *
   * @param type Type of organization. Possible values: **associationIncorporated**,
   *     **governmentalOrganization**, **listedPublicCompany**, **nonProfit**,
   *     **partnershipIncorporated**, **privateCompany**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The reason the organization has not provided a VAT number. Possible values:
   * **industryExemption**, **belowTaxThreshold**.
   *
   * @param vatAbsenceReason The reason the organization has not provided a VAT number. Possible
   *     values: **industryExemption**, **belowTaxThreshold**.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization vatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
    this.vatAbsenceReason = vatAbsenceReason;
    return this;
  }

  /**
   * The reason the organization has not provided a VAT number. Possible values:
   * **industryExemption**, **belowTaxThreshold**.
   *
   * @return vatAbsenceReason The reason the organization has not provided a VAT number. Possible
   *     values: **industryExemption**, **belowTaxThreshold**.
   */
  @JsonProperty(JSON_PROPERTY_VAT_ABSENCE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VatAbsenceReasonEnum getVatAbsenceReason() {
    return vatAbsenceReason;
  }

  /**
   * The reason the organization has not provided a VAT number. Possible values:
   * **industryExemption**, **belowTaxThreshold**.
   *
   * @param vatAbsenceReason The reason the organization has not provided a VAT number. Possible
   *     values: **industryExemption**, **belowTaxThreshold**.
   */
  @JsonProperty(JSON_PROPERTY_VAT_ABSENCE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
    this.vatAbsenceReason = vatAbsenceReason;
  }

  /**
   * The organization&#39;s VAT number.
   *
   * @param vatNumber The organization&#39;s VAT number.
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization vatNumber(String vatNumber) {
    this.vatNumber = vatNumber;
    return this;
  }

  /**
   * The organization&#39;s VAT number.
   *
   * @return vatNumber The organization&#39;s VAT number.
   */
  @JsonProperty(JSON_PROPERTY_VAT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVatNumber() {
    return vatNumber;
  }

  /**
   * The organization&#39;s VAT number.
   *
   * @param vatNumber The organization&#39;s VAT number.
   */
  @JsonProperty(JSON_PROPERTY_VAT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVatNumber(String vatNumber) {
    this.vatNumber = vatNumber;
  }

  /**
   * webData
   *
   * @param webData
   * @return the current {@code Organization} instance, allowing for method chaining
   */
  public Organization webData(WebData webData) {
    this.webData = webData;
    return this;
  }

  /**
   * Get webData
   *
   * @return webData
   */
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WebData getWebData() {
    return webData;
  }

  /**
   * webData
   *
   * @param webData
   */
  @JsonProperty(JSON_PROPERTY_WEB_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebData(WebData webData) {
    this.webData = webData;
  }

  /** Return true if this Organization object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Organization organization = (Organization) o;
    return Objects.equals(this.countryOfGoverningLaw, organization.countryOfGoverningLaw)
        && Objects.equals(this.dateOfIncorporation, organization.dateOfIncorporation)
        && Objects.equals(this.description, organization.description)
        && Objects.equals(this.doingBusinessAs, organization.doingBusinessAs)
        && Objects.equals(this.email, organization.email)
        && Objects.equals(this.financialReports, organization.financialReports)
        && Objects.equals(this.legalName, organization.legalName)
        && Objects.equals(this.phone, organization.phone)
        && Objects.equals(this.principalPlaceOfBusiness, organization.principalPlaceOfBusiness)
        && Objects.equals(this.registeredAddress, organization.registeredAddress)
        && Objects.equals(this.registrationNumber, organization.registrationNumber)
        && Objects.equals(this.stockData, organization.stockData)
        && Objects.equals(this.taxInformation, organization.taxInformation)
        && Objects.equals(this.taxReportingClassification, organization.taxReportingClassification)
        && Objects.equals(this.type, organization.type)
        && Objects.equals(this.vatAbsenceReason, organization.vatAbsenceReason)
        && Objects.equals(this.vatNumber, organization.vatNumber)
        && Objects.equals(this.webData, organization.webData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        countryOfGoverningLaw,
        dateOfIncorporation,
        description,
        doingBusinessAs,
        email,
        financialReports,
        legalName,
        phone,
        principalPlaceOfBusiness,
        registeredAddress,
        registrationNumber,
        stockData,
        taxInformation,
        taxReportingClassification,
        type,
        vatAbsenceReason,
        vatNumber,
        webData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Organization {\n");
    sb.append("    countryOfGoverningLaw: ")
        .append(toIndentedString(countryOfGoverningLaw))
        .append("\n");
    sb.append("    dateOfIncorporation: ")
        .append(toIndentedString(dateOfIncorporation))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    doingBusinessAs: ").append(toIndentedString(doingBusinessAs)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    financialReports: ").append(toIndentedString(financialReports)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    principalPlaceOfBusiness: ")
        .append(toIndentedString(principalPlaceOfBusiness))
        .append("\n");
    sb.append("    registeredAddress: ").append(toIndentedString(registeredAddress)).append("\n");
    sb.append("    registrationNumber: ").append(toIndentedString(registrationNumber)).append("\n");
    sb.append("    stockData: ").append(toIndentedString(stockData)).append("\n");
    sb.append("    taxInformation: ").append(toIndentedString(taxInformation)).append("\n");
    sb.append("    taxReportingClassification: ")
        .append(toIndentedString(taxReportingClassification))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vatAbsenceReason: ").append(toIndentedString(vatAbsenceReason)).append("\n");
    sb.append("    vatNumber: ").append(toIndentedString(vatNumber)).append("\n");
    sb.append("    webData: ").append(toIndentedString(webData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Organization given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Organization
   * @throws JsonProcessingException if the JSON string is invalid with respect to Organization
   */
  public static Organization fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Organization.class);
  }

  /**
   * Convert an instance of Organization to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
