/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** WebData */
@JsonPropertyOrder({WebData.JSON_PROPERTY_WEB_ADDRESS, WebData.JSON_PROPERTY_WEB_ADDRESS_ID})
public class WebData {
  public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
  private String webAddress;

  public static final String JSON_PROPERTY_WEB_ADDRESS_ID = "webAddressId";
  private String webAddressId;

  public WebData() {}

  @JsonCreator
  public WebData(@JsonProperty(JSON_PROPERTY_WEB_ADDRESS_ID) String webAddressId) {
    this();
    this.webAddressId = webAddressId;
  }

  /**
   * The URL of the website or the app store URL.
   *
   * @param webAddress The URL of the website or the app store URL.
   * @return the current {@code WebData} instance, allowing for method chaining
   */
  public WebData webAddress(String webAddress) {
    this.webAddress = webAddress;
    return this;
  }

  /**
   * The URL of the website or the app store URL.
   *
   * @return webAddress The URL of the website or the app store URL.
   */
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebAddress() {
    return webAddress;
  }

  /**
   * The URL of the website or the app store URL.
   *
   * @param webAddress The URL of the website or the app store URL.
   */
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebAddress(String webAddress) {
    this.webAddress = webAddress;
  }

  /**
   * The unique identifier of the web address.
   *
   * @return webAddressId The unique identifier of the web address.
   */
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebAddressId() {
    return webAddressId;
  }

  /** Return true if this WebData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebData webData = (WebData) o;
    return Objects.equals(this.webAddress, webData.webAddress)
        && Objects.equals(this.webAddressId, webData.webAddressId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(webAddress, webAddressId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebData {\n");
    sb.append("    webAddress: ").append(toIndentedString(webAddress)).append("\n");
    sb.append("    webAddressId: ").append(toIndentedString(webAddressId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of WebData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of WebData
   * @throws JsonProcessingException if the JSON string is invalid with respect to WebData
   */
  public static WebData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, WebData.class);
  }

  /**
   * Convert an instance of WebData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
