/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** AndroidApp */
@JsonPropertyOrder({
  AndroidApp.JSON_PROPERTY_DESCRIPTION,
  AndroidApp.JSON_PROPERTY_ERROR_CODE,
  AndroidApp.JSON_PROPERTY_ERRORS,
  AndroidApp.JSON_PROPERTY_ID,
  AndroidApp.JSON_PROPERTY_LABEL,
  AndroidApp.JSON_PROPERTY_PACKAGE_NAME,
  AndroidApp.JSON_PROPERTY_STATUS,
  AndroidApp.JSON_PROPERTY_VERSION_CODE,
  AndroidApp.JSON_PROPERTY_VERSION_NAME
})
public class AndroidApp {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  @Deprecated // deprecated since Management API v3: Use `errors` instead.
  private String errorCode;

  public static final String JSON_PROPERTY_ERRORS = "errors";
  private List<AndroidAppError> errors;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LABEL = "label";
  private String label;

  public static final String JSON_PROPERTY_PACKAGE_NAME = "packageName";
  private String packageName;

  /**
   * The status of the app. Possible values: * &#x60;processing&#x60;: the app is being signed and
   * converted to a format that the terminal can handle. * &#x60;error&#x60;: something went wrong.
   * Check that the app matches the
   * [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   * &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   * &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app is no
   * longer available.
   */
  public enum StatusEnum {
    ARCHIVED(String.valueOf("archived")),

    ERROR(String.valueOf("error")),

    INVALID(String.valueOf("invalid")),

    PROCESSING(String.valueOf("processing")),

    READY(String.valueOf("ready"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_VERSION_CODE = "versionCode";
  private Integer versionCode;

  public static final String JSON_PROPERTY_VERSION_NAME = "versionName";
  private String versionName;

  public AndroidApp() {}

  /**
   * The description that was provided when uploading the app. The description is not shown on the
   * terminal.
   *
   * @param description The description that was provided when uploading the app. The description is
   *     not shown on the terminal.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description that was provided when uploading the app. The description is not shown on the
   * terminal.
   *
   * @return description The description that was provided when uploading the app. The description
   *     is not shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * The description that was provided when uploading the app. The description is not shown on the
   * terminal.
   *
   * @param description The description that was provided when uploading the app. The description is
   *     not shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or
   * **invalid**.
   *
   * @param errorCode The error code of the Android app with the &#x60;status&#x60; of either
   *     **error** or **invalid**.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   * @deprecated since Management API v3 Use &#x60;errors&#x60; instead.
   */
  @Deprecated // deprecated since Management API v3: Use `errors` instead.
  public AndroidApp errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or
   * **invalid**.
   *
   * @return errorCode The error code of the Android app with the &#x60;status&#x60; of either
   *     **error** or **invalid**.
   * @deprecated // deprecated since Management API v3: Use `errors` instead.
   */
  @Deprecated // deprecated since Management API v3: Use `errors` instead.
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * The error code of the Android app with the &#x60;status&#x60; of either **error** or
   * **invalid**.
   *
   * @param errorCode The error code of the Android app with the &#x60;status&#x60; of either
   *     **error** or **invalid**.
   * @deprecated since Management API v3 Use &#x60;errors&#x60; instead.
   */
  @Deprecated // deprecated since Management API v3: Use `errors` instead.
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  /**
   * The list of errors of the Android app.
   *
   * @param errors The list of errors of the Android app.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp errors(List<AndroidAppError> errors) {
    this.errors = errors;
    return this;
  }

  public AndroidApp addErrorsItem(AndroidAppError errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

  /**
   * The list of errors of the Android app.
   *
   * @return errors The list of errors of the Android app.
   */
  @JsonProperty(JSON_PROPERTY_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<AndroidAppError> getErrors() {
    return errors;
  }

  /**
   * The list of errors of the Android app.
   *
   * @param errors The list of errors of the Android app.
   */
  @JsonProperty(JSON_PROPERTY_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrors(List<AndroidAppError> errors) {
    this.errors = errors;
  }

  /**
   * The unique identifier of the app.
   *
   * @param id The unique identifier of the app.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the app.
   *
   * @return id The unique identifier of the app.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the app.
   *
   * @param id The unique identifier of the app.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The app name that is shown on the terminal.
   *
   * @param label The app name that is shown on the terminal.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp label(String label) {
    this.label = label;
    return this;
  }

  /**
   * The app name that is shown on the terminal.
   *
   * @return label The app name that is shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLabel() {
    return label;
  }

  /**
   * The app name that is shown on the terminal.
   *
   * @param label The app name that is shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabel(String label) {
    this.label = label;
  }

  /**
   * The package name that uniquely identifies the Android app.
   *
   * @param packageName The package name that uniquely identifies the Android app.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp packageName(String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * The package name that uniquely identifies the Android app.
   *
   * @return packageName The package name that uniquely identifies the Android app.
   */
  @JsonProperty(JSON_PROPERTY_PACKAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPackageName() {
    return packageName;
  }

  /**
   * The package name that uniquely identifies the Android app.
   *
   * @param packageName The package name that uniquely identifies the Android app.
   */
  @JsonProperty(JSON_PROPERTY_PACKAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageName(String packageName) {
    this.packageName = packageName;
  }

  /**
   * The status of the app. Possible values: * &#x60;processing&#x60;: the app is being signed and
   * converted to a format that the terminal can handle. * &#x60;error&#x60;: something went wrong.
   * Check that the app matches the
   * [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   * &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   * &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app is no
   * longer available.
   *
   * @param status The status of the app. Possible values: * &#x60;processing&#x60;: the app is
   *     being signed and converted to a format that the terminal can handle. * &#x60;error&#x60;:
   *     something went wrong. Check that the app matches the
   *     [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   *     &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   *     &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app
   *     is no longer available.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the app. Possible values: * &#x60;processing&#x60;: the app is being signed and
   * converted to a format that the terminal can handle. * &#x60;error&#x60;: something went wrong.
   * Check that the app matches the
   * [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   * &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   * &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app is no
   * longer available.
   *
   * @return status The status of the app. Possible values: * &#x60;processing&#x60;: the app is
   *     being signed and converted to a format that the terminal can handle. * &#x60;error&#x60;:
   *     something went wrong. Check that the app matches the
   *     [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   *     &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   *     &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app
   *     is no longer available.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the app. Possible values: * &#x60;processing&#x60;: the app is being signed and
   * converted to a format that the terminal can handle. * &#x60;error&#x60;: something went wrong.
   * Check that the app matches the
   * [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   * &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   * &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app is no
   * longer available.
   *
   * @param status The status of the app. Possible values: * &#x60;processing&#x60;: the app is
   *     being signed and converted to a format that the terminal can handle. * &#x60;error&#x60;:
   *     something went wrong. Check that the app matches the
   *     [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). *
   *     &#x60;invalid&#x60;: there is something wrong with the APK file of the app. *
   *     &#x60;ready&#x60;: the app has been signed and converted. * &#x60;archived&#x60;: the app
   *     is no longer available.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The version number of the app.
   *
   * @param versionCode The version number of the app.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp versionCode(Integer versionCode) {
    this.versionCode = versionCode;
    return this;
  }

  /**
   * The version number of the app.
   *
   * @return versionCode The version number of the app.
   */
  @JsonProperty(JSON_PROPERTY_VERSION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getVersionCode() {
    return versionCode;
  }

  /**
   * The version number of the app.
   *
   * @param versionCode The version number of the app.
   */
  @JsonProperty(JSON_PROPERTY_VERSION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionCode(Integer versionCode) {
    this.versionCode = versionCode;
  }

  /**
   * The app version number that is shown on the terminal.
   *
   * @param versionName The app version number that is shown on the terminal.
   * @return the current {@code AndroidApp} instance, allowing for method chaining
   */
  public AndroidApp versionName(String versionName) {
    this.versionName = versionName;
    return this;
  }

  /**
   * The app version number that is shown on the terminal.
   *
   * @return versionName The app version number that is shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_VERSION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVersionName() {
    return versionName;
  }

  /**
   * The app version number that is shown on the terminal.
   *
   * @param versionName The app version number that is shown on the terminal.
   */
  @JsonProperty(JSON_PROPERTY_VERSION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionName(String versionName) {
    this.versionName = versionName;
  }

  /** Return true if this AndroidApp object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AndroidApp androidApp = (AndroidApp) o;
    return Objects.equals(this.description, androidApp.description)
        && Objects.equals(this.errorCode, androidApp.errorCode)
        && Objects.equals(this.errors, androidApp.errors)
        && Objects.equals(this.id, androidApp.id)
        && Objects.equals(this.label, androidApp.label)
        && Objects.equals(this.packageName, androidApp.packageName)
        && Objects.equals(this.status, androidApp.status)
        && Objects.equals(this.versionCode, androidApp.versionCode)
        && Objects.equals(this.versionName, androidApp.versionName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        description, errorCode, errors, id, label, packageName, status, versionCode, versionName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AndroidApp {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    packageName: ").append(toIndentedString(packageName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    versionCode: ").append(toIndentedString(versionCode)).append("\n");
    sb.append("    versionName: ").append(toIndentedString(versionName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AndroidApp given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AndroidApp
   * @throws JsonProcessingException if the JSON string is invalid with respect to AndroidApp
   */
  public static AndroidApp fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AndroidApp.class);
  }

  /**
   * Convert an instance of AndroidApp to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
