/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Connectivity */
@JsonPropertyOrder({
  Connectivity.JSON_PROPERTY_SIMCARD_STATUS,
  Connectivity.JSON_PROPERTY_TERMINAL_I_P_ADDRESS_U_R_L
})
public class Connectivity {
  /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only
   * at terminal level, and only for models that support cellular connectivity. Possible values: *
   * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on
   * the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not
   * activated. The terminal can&#39;t use cellular connectivity.
   */
  public enum SimcardStatusEnum {
    ACTIVATED(String.valueOf("ACTIVATED")),

    INVENTORY(String.valueOf("INVENTORY"));

    private String value;

    SimcardStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SimcardStatusEnum fromValue(String value) {
      for (SimcardStatusEnum b : SimcardStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SIMCARD_STATUS = "simcardStatus";
  private SimcardStatusEnum simcardStatus;

  public static final String JSON_PROPERTY_TERMINAL_I_P_ADDRESS_U_R_L = "terminalIPAddressURL";
  private EventUrl terminalIPAddressURL;

  public Connectivity() {}

  /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only
   * at terminal level, and only for models that support cellular connectivity. Possible values: *
   * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on
   * the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not
   * activated. The terminal can&#39;t use cellular connectivity.
   *
   * @param simcardStatus Indicates the status of the SIM card in the payment terminal. Can be
   *     updated and received only at terminal level, and only for models that support cellular
   *     connectivity. Possible values: * **ACTIVATED**: the SIM card is activated. Cellular
   *     connectivity may still need to be enabled on the terminal itself, in the **Network**
   *     settings. * **INVENTORY**: the SIM card is not activated. The terminal can&#39;t use
   *     cellular connectivity.
   * @return the current {@code Connectivity} instance, allowing for method chaining
   */
  public Connectivity simcardStatus(SimcardStatusEnum simcardStatus) {
    this.simcardStatus = simcardStatus;
    return this;
  }

  /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only
   * at terminal level, and only for models that support cellular connectivity. Possible values: *
   * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on
   * the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not
   * activated. The terminal can&#39;t use cellular connectivity.
   *
   * @return simcardStatus Indicates the status of the SIM card in the payment terminal. Can be
   *     updated and received only at terminal level, and only for models that support cellular
   *     connectivity. Possible values: * **ACTIVATED**: the SIM card is activated. Cellular
   *     connectivity may still need to be enabled on the terminal itself, in the **Network**
   *     settings. * **INVENTORY**: the SIM card is not activated. The terminal can&#39;t use
   *     cellular connectivity.
   */
  @JsonProperty(JSON_PROPERTY_SIMCARD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SimcardStatusEnum getSimcardStatus() {
    return simcardStatus;
  }

  /**
   * Indicates the status of the SIM card in the payment terminal. Can be updated and received only
   * at terminal level, and only for models that support cellular connectivity. Possible values: *
   * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on
   * the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not
   * activated. The terminal can&#39;t use cellular connectivity.
   *
   * @param simcardStatus Indicates the status of the SIM card in the payment terminal. Can be
   *     updated and received only at terminal level, and only for models that support cellular
   *     connectivity. Possible values: * **ACTIVATED**: the SIM card is activated. Cellular
   *     connectivity may still need to be enabled on the terminal itself, in the **Network**
   *     settings. * **INVENTORY**: the SIM card is not activated. The terminal can&#39;t use
   *     cellular connectivity.
   */
  @JsonProperty(JSON_PROPERTY_SIMCARD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSimcardStatus(SimcardStatusEnum simcardStatus) {
    this.simcardStatus = simcardStatus;
  }

  /**
   * terminalIPAddressURL
   *
   * @param terminalIPAddressURL
   * @return the current {@code Connectivity} instance, allowing for method chaining
   */
  public Connectivity terminalIPAddressURL(EventUrl terminalIPAddressURL) {
    this.terminalIPAddressURL = terminalIPAddressURL;
    return this;
  }

  /**
   * Get terminalIPAddressURL
   *
   * @return terminalIPAddressURL
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_I_P_ADDRESS_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EventUrl getTerminalIPAddressURL() {
    return terminalIPAddressURL;
  }

  /**
   * terminalIPAddressURL
   *
   * @param terminalIPAddressURL
   */
  @JsonProperty(JSON_PROPERTY_TERMINAL_I_P_ADDRESS_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminalIPAddressURL(EventUrl terminalIPAddressURL) {
    this.terminalIPAddressURL = terminalIPAddressURL;
  }

  /** Return true if this Connectivity object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Connectivity connectivity = (Connectivity) o;
    return Objects.equals(this.simcardStatus, connectivity.simcardStatus)
        && Objects.equals(this.terminalIPAddressURL, connectivity.terminalIPAddressURL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(simcardStatus, terminalIPAddressURL);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Connectivity {\n");
    sb.append("    simcardStatus: ").append(toIndentedString(simcardStatus)).append("\n");
    sb.append("    terminalIPAddressURL: ")
        .append(toIndentedString(terminalIPAddressURL))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Connectivity given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Connectivity
   * @throws JsonProcessingException if the JSON string is invalid with respect to Connectivity
   */
  public static Connectivity fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Connectivity.class);
  }

  /**
   * Convert an instance of Connectivity to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
