/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Hardware */
@JsonPropertyOrder({
  Hardware.JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT,
  Hardware.JSON_PROPERTY_RESET_TOTALS_HOUR,
  Hardware.JSON_PROPERTY_RESTART_HOUR
})
public class Hardware {
  public static final String JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT = "displayMaximumBackLight";
  private Integer displayMaximumBackLight;

  public static final String JSON_PROPERTY_RESET_TOTALS_HOUR = "resetTotalsHour";
  private Integer resetTotalsHour;

  public static final String JSON_PROPERTY_RESTART_HOUR = "restartHour";
  private Integer restartHour;

  public Hardware() {}

  /**
   * The brightness of the display when the terminal is being used, expressed as a percentage.
   *
   * @param displayMaximumBackLight The brightness of the display when the terminal is being used,
   *     expressed as a percentage.
   * @return the current {@code Hardware} instance, allowing for method chaining
   */
  public Hardware displayMaximumBackLight(Integer displayMaximumBackLight) {
    this.displayMaximumBackLight = displayMaximumBackLight;
    return this;
  }

  /**
   * The brightness of the display when the terminal is being used, expressed as a percentage.
   *
   * @return displayMaximumBackLight The brightness of the display when the terminal is being used,
   *     expressed as a percentage.
   */
  @JsonProperty(JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getDisplayMaximumBackLight() {
    return displayMaximumBackLight;
  }

  /**
   * The brightness of the display when the terminal is being used, expressed as a percentage.
   *
   * @param displayMaximumBackLight The brightness of the display when the terminal is being used,
   *     expressed as a percentage.
   */
  @JsonProperty(JSON_PROPERTY_DISPLAY_MAXIMUM_BACK_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayMaximumBackLight(Integer displayMaximumBackLight) {
    this.displayMaximumBackLight = displayMaximumBackLight;
  }

  /**
   * The hour of the day when the terminal is set to reset the Totals report. By default, the reset
   * hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0, maximum value: 23.
   *
   * @param resetTotalsHour The hour of the day when the terminal is set to reset the Totals report.
   *     By default, the reset hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0,
   *     maximum value: 23.
   * @return the current {@code Hardware} instance, allowing for method chaining
   */
  public Hardware resetTotalsHour(Integer resetTotalsHour) {
    this.resetTotalsHour = resetTotalsHour;
    return this;
  }

  /**
   * The hour of the day when the terminal is set to reset the Totals report. By default, the reset
   * hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0, maximum value: 23.
   *
   * @return resetTotalsHour The hour of the day when the terminal is set to reset the Totals
   *     report. By default, the reset hour is at 6:00 AM in the timezone of the terminal. Minimum
   *     value: 0, maximum value: 23.
   */
  @JsonProperty(JSON_PROPERTY_RESET_TOTALS_HOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getResetTotalsHour() {
    return resetTotalsHour;
  }

  /**
   * The hour of the day when the terminal is set to reset the Totals report. By default, the reset
   * hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0, maximum value: 23.
   *
   * @param resetTotalsHour The hour of the day when the terminal is set to reset the Totals report.
   *     By default, the reset hour is at 6:00 AM in the timezone of the terminal. Minimum value: 0,
   *     maximum value: 23.
   */
  @JsonProperty(JSON_PROPERTY_RESET_TOTALS_HOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResetTotalsHour(Integer resetTotalsHour) {
    this.resetTotalsHour = resetTotalsHour;
  }

  /**
   * The hour of the day when the terminal is set to reboot to apply the configuration and software
   * updates. By default, the restart hour is at 6:00 AM in the timezone of the terminal. Minimum
   * value: 0, maximum value: 23.
   *
   * @param restartHour The hour of the day when the terminal is set to reboot to apply the
   *     configuration and software updates. By default, the restart hour is at 6:00 AM in the
   *     timezone of the terminal. Minimum value: 0, maximum value: 23.
   * @return the current {@code Hardware} instance, allowing for method chaining
   */
  public Hardware restartHour(Integer restartHour) {
    this.restartHour = restartHour;
    return this;
  }

  /**
   * The hour of the day when the terminal is set to reboot to apply the configuration and software
   * updates. By default, the restart hour is at 6:00 AM in the timezone of the terminal. Minimum
   * value: 0, maximum value: 23.
   *
   * @return restartHour The hour of the day when the terminal is set to reboot to apply the
   *     configuration and software updates. By default, the restart hour is at 6:00 AM in the
   *     timezone of the terminal. Minimum value: 0, maximum value: 23.
   */
  @JsonProperty(JSON_PROPERTY_RESTART_HOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getRestartHour() {
    return restartHour;
  }

  /**
   * The hour of the day when the terminal is set to reboot to apply the configuration and software
   * updates. By default, the restart hour is at 6:00 AM in the timezone of the terminal. Minimum
   * value: 0, maximum value: 23.
   *
   * @param restartHour The hour of the day when the terminal is set to reboot to apply the
   *     configuration and software updates. By default, the restart hour is at 6:00 AM in the
   *     timezone of the terminal. Minimum value: 0, maximum value: 23.
   */
  @JsonProperty(JSON_PROPERTY_RESTART_HOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestartHour(Integer restartHour) {
    this.restartHour = restartHour;
  }

  /** Return true if this Hardware object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Hardware hardware = (Hardware) o;
    return Objects.equals(this.displayMaximumBackLight, hardware.displayMaximumBackLight)
        && Objects.equals(this.resetTotalsHour, hardware.resetTotalsHour)
        && Objects.equals(this.restartHour, hardware.restartHour);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayMaximumBackLight, resetTotalsHour, restartHour);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Hardware {\n");
    sb.append("    displayMaximumBackLight: ")
        .append(toIndentedString(displayMaximumBackLight))
        .append("\n");
    sb.append("    resetTotalsHour: ").append(toIndentedString(resetTotalsHour)).append("\n");
    sb.append("    restartHour: ").append(toIndentedString(restartHour)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Hardware given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Hardware
   * @throws JsonProcessingException if the JSON string is invalid with respect to Hardware
   */
  public static Hardware fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Hardware.class);
  }

  /**
   * Convert an instance of Hardware to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
