/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** InstallAndroidAppDetails */
@JsonPropertyOrder({
  InstallAndroidAppDetails.JSON_PROPERTY_APP_ID,
  InstallAndroidAppDetails.JSON_PROPERTY_TYPE
})
public class InstallAndroidAppDetails {
  public static final String JSON_PROPERTY_APP_ID = "appId";
  private String appId;

  /** Type of terminal action: Install an Android app. */
  public enum TypeEnum {
    INSTALLANDROIDAPP(String.valueOf("InstallAndroidApp"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.INSTALLANDROIDAPP;

  public InstallAndroidAppDetails() {}

  /**
   * The unique identifier of the app to be installed.
   *
   * @param appId The unique identifier of the app to be installed.
   * @return the current {@code InstallAndroidAppDetails} instance, allowing for method chaining
   */
  public InstallAndroidAppDetails appId(String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * The unique identifier of the app to be installed.
   *
   * @return appId The unique identifier of the app to be installed.
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAppId() {
    return appId;
  }

  /**
   * The unique identifier of the app to be installed.
   *
   * @param appId The unique identifier of the app to be installed.
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * Type of terminal action: Install an Android app.
   *
   * @param type Type of terminal action: Install an Android app.
   * @return the current {@code InstallAndroidAppDetails} instance, allowing for method chaining
   */
  public InstallAndroidAppDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of terminal action: Install an Android app.
   *
   * @return type Type of terminal action: Install an Android app.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of terminal action: Install an Android app.
   *
   * @param type Type of terminal action: Install an Android app.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this InstallAndroidAppDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InstallAndroidAppDetails installAndroidAppDetails = (InstallAndroidAppDetails) o;
    return Objects.equals(this.appId, installAndroidAppDetails.appId)
        && Objects.equals(this.type, installAndroidAppDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InstallAndroidAppDetails {\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of InstallAndroidAppDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of InstallAndroidAppDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     InstallAndroidAppDetails
   */
  public static InstallAndroidAppDetails fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, InstallAndroidAppDetails.class);
  }

  /**
   * Convert an instance of InstallAndroidAppDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
