/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ListMerchantApiCredentialsResponse */
@JsonPropertyOrder({
  ListMerchantApiCredentialsResponse.JSON_PROPERTY_LINKS,
  ListMerchantApiCredentialsResponse.JSON_PROPERTY_DATA,
  ListMerchantApiCredentialsResponse.JSON_PROPERTY_ITEMS_TOTAL,
  ListMerchantApiCredentialsResponse.JSON_PROPERTY_PAGES_TOTAL
})
public class ListMerchantApiCredentialsResponse {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private PaginationLinks links;

  public static final String JSON_PROPERTY_DATA = "data";
  private List<ApiCredential> data;

  public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
  private Integer itemsTotal;

  public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
  private Integer pagesTotal;

  public ListMerchantApiCredentialsResponse() {}

  /**
   * links
   *
   * @param links
   * @return the current {@code ListMerchantApiCredentialsResponse} instance, allowing for method
   *     chaining
   */
  public ListMerchantApiCredentialsResponse links(PaginationLinks links) {
    this.links = links;
    return this;
  }

  /**
   * Get links
   *
   * @return links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaginationLinks getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(PaginationLinks links) {
    this.links = links;
  }

  /**
   * The list of API credentials.
   *
   * @param data The list of API credentials.
   * @return the current {@code ListMerchantApiCredentialsResponse} instance, allowing for method
   *     chaining
   */
  public ListMerchantApiCredentialsResponse data(List<ApiCredential> data) {
    this.data = data;
    return this;
  }

  public ListMerchantApiCredentialsResponse addDataItem(ApiCredential dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * The list of API credentials.
   *
   * @return data The list of API credentials.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ApiCredential> getData() {
    return data;
  }

  /**
   * The list of API credentials.
   *
   * @param data The list of API credentials.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(List<ApiCredential> data) {
    this.data = data;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal Total number of items.
   * @return the current {@code ListMerchantApiCredentialsResponse} instance, allowing for method
   *     chaining
   */
  public ListMerchantApiCredentialsResponse itemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
    return this;
  }

  /**
   * Total number of items.
   *
   * @return itemsTotal Total number of items.
   */
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getItemsTotal() {
    return itemsTotal;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal Total number of items.
   */
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal Total number of pages.
   * @return the current {@code ListMerchantApiCredentialsResponse} instance, allowing for method
   *     chaining
   */
  public ListMerchantApiCredentialsResponse pagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
    return this;
  }

  /**
   * Total number of pages.
   *
   * @return pagesTotal Total number of pages.
   */
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPagesTotal() {
    return pagesTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal Total number of pages.
   */
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
  }

  /** Return true if this ListMerchantApiCredentialsResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListMerchantApiCredentialsResponse listMerchantApiCredentialsResponse =
        (ListMerchantApiCredentialsResponse) o;
    return Objects.equals(this.links, listMerchantApiCredentialsResponse.links)
        && Objects.equals(this.data, listMerchantApiCredentialsResponse.data)
        && Objects.equals(this.itemsTotal, listMerchantApiCredentialsResponse.itemsTotal)
        && Objects.equals(this.pagesTotal, listMerchantApiCredentialsResponse.pagesTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, data, itemsTotal, pagesTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListMerchantApiCredentialsResponse {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    itemsTotal: ").append(toIndentedString(itemsTotal)).append("\n");
    sb.append("    pagesTotal: ").append(toIndentedString(pagesTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ListMerchantApiCredentialsResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ListMerchantApiCredentialsResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ListMerchantApiCredentialsResponse
   */
  public static ListMerchantApiCredentialsResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ListMerchantApiCredentialsResponse.class);
  }

  /**
   * Convert an instance of ListMerchantApiCredentialsResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
