/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ListMerchantResponse */
@JsonPropertyOrder({
  ListMerchantResponse.JSON_PROPERTY_LINKS,
  ListMerchantResponse.JSON_PROPERTY_DATA,
  ListMerchantResponse.JSON_PROPERTY_ITEMS_TOTAL,
  ListMerchantResponse.JSON_PROPERTY_PAGES_TOTAL
})
public class ListMerchantResponse {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private PaginationLinks links;

  public static final String JSON_PROPERTY_DATA = "data";
  private List<Merchant> data;

  public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
  private Integer itemsTotal;

  public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
  private Integer pagesTotal;

  public ListMerchantResponse() {}

  /**
   * links
   *
   * @param links
   * @return the current {@code ListMerchantResponse} instance, allowing for method chaining
   */
  public ListMerchantResponse links(PaginationLinks links) {
    this.links = links;
    return this;
  }

  /**
   * Get links
   *
   * @return links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaginationLinks getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(PaginationLinks links) {
    this.links = links;
  }

  /**
   * The list of merchant accounts.
   *
   * @param data The list of merchant accounts.
   * @return the current {@code ListMerchantResponse} instance, allowing for method chaining
   */
  public ListMerchantResponse data(List<Merchant> data) {
    this.data = data;
    return this;
  }

  public ListMerchantResponse addDataItem(Merchant dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * The list of merchant accounts.
   *
   * @return data The list of merchant accounts.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Merchant> getData() {
    return data;
  }

  /**
   * The list of merchant accounts.
   *
   * @param data The list of merchant accounts.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(List<Merchant> data) {
    this.data = data;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal Total number of items.
   * @return the current {@code ListMerchantResponse} instance, allowing for method chaining
   */
  public ListMerchantResponse itemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
    return this;
  }

  /**
   * Total number of items.
   *
   * @return itemsTotal Total number of items.
   */
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getItemsTotal() {
    return itemsTotal;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal Total number of items.
   */
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal Total number of pages.
   * @return the current {@code ListMerchantResponse} instance, allowing for method chaining
   */
  public ListMerchantResponse pagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
    return this;
  }

  /**
   * Total number of pages.
   *
   * @return pagesTotal Total number of pages.
   */
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPagesTotal() {
    return pagesTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal Total number of pages.
   */
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
  }

  /** Return true if this ListMerchantResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListMerchantResponse listMerchantResponse = (ListMerchantResponse) o;
    return Objects.equals(this.links, listMerchantResponse.links)
        && Objects.equals(this.data, listMerchantResponse.data)
        && Objects.equals(this.itemsTotal, listMerchantResponse.itemsTotal)
        && Objects.equals(this.pagesTotal, listMerchantResponse.pagesTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, data, itemsTotal, pagesTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListMerchantResponse {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    itemsTotal: ").append(toIndentedString(itemsTotal)).append("\n");
    sb.append("    pagesTotal: ").append(toIndentedString(pagesTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ListMerchantResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ListMerchantResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ListMerchantResponse
   */
  public static ListMerchantResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ListMerchantResponse.class);
  }

  /**
   * Convert an instance of ListMerchantResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
