/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** PayByBankPlaidInfo */
@JsonPropertyOrder({
  PayByBankPlaidInfo.JSON_PROPERTY_COUNTRY_CODE,
  PayByBankPlaidInfo.JSON_PROPERTY_LOGO,
  PayByBankPlaidInfo.JSON_PROPERTY_MERCHANT_CITY,
  PayByBankPlaidInfo.JSON_PROPERTY_MERCHANT_LEGAL_NAME,
  PayByBankPlaidInfo.JSON_PROPERTY_MERCHANT_SHOP_URL,
  PayByBankPlaidInfo.JSON_PROPERTY_MERCHANT_STATE_PROVINCE,
  PayByBankPlaidInfo.JSON_PROPERTY_MERCHANT_STREET_ADDRESS,
  PayByBankPlaidInfo.JSON_PROPERTY_TRANSACTION_DESCRIPTION,
  PayByBankPlaidInfo.JSON_PROPERTY_ZIP_CODE
})
public class PayByBankPlaidInfo {
  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_LOGO = "logo";
  private String logo;

  public static final String JSON_PROPERTY_MERCHANT_CITY = "merchantCity";
  private String merchantCity;

  public static final String JSON_PROPERTY_MERCHANT_LEGAL_NAME = "merchantLegalName";
  private String merchantLegalName;

  public static final String JSON_PROPERTY_MERCHANT_SHOP_URL = "merchantShopUrl";
  private String merchantShopUrl;

  public static final String JSON_PROPERTY_MERCHANT_STATE_PROVINCE = "merchantStateProvince";
  private String merchantStateProvince;

  public static final String JSON_PROPERTY_MERCHANT_STREET_ADDRESS = "merchantStreetAddress";
  private String merchantStreetAddress;

  public static final String JSON_PROPERTY_TRANSACTION_DESCRIPTION = "transactionDescription";
  private TransactionDescriptionInfo transactionDescription;

  public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
  private String zipCode;

  public PayByBankPlaidInfo() {}

  /**
   * Country Code.
   *
   * @param countryCode Country Code.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Country Code.
   *
   * @return countryCode Country Code.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountryCode() {
    return countryCode;
  }

  /**
   * Country Code.
   *
   * @param countryCode Country Code.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  /**
   * Merchant logo (max. size 150kB). Format: Base64-encoded string.
   *
   * @param logo Merchant logo (max. size 150kB). Format: Base64-encoded string.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo logo(String logo) {
    this.logo = logo;
    return this;
  }

  /**
   * Merchant logo (max. size 150kB). Format: Base64-encoded string.
   *
   * @return logo Merchant logo (max. size 150kB). Format: Base64-encoded string.
   */
  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLogo() {
    return logo;
  }

  /**
   * Merchant logo (max. size 150kB). Format: Base64-encoded string.
   *
   * @param logo Merchant logo (max. size 150kB). Format: Base64-encoded string.
   */
  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogo(String logo) {
    this.logo = logo;
  }

  /**
   * The city the merchant is doing business in.
   *
   * @param merchantCity The city the merchant is doing business in.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo merchantCity(String merchantCity) {
    this.merchantCity = merchantCity;
    return this;
  }

  /**
   * The city the merchant is doing business in.
   *
   * @return merchantCity The city the merchant is doing business in.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantCity() {
    return merchantCity;
  }

  /**
   * The city the merchant is doing business in.
   *
   * @param merchantCity The city the merchant is doing business in.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantCity(String merchantCity) {
    this.merchantCity = merchantCity;
  }

  /**
   * Legal Business Name of the Merchant.
   *
   * @param merchantLegalName Legal Business Name of the Merchant.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo merchantLegalName(String merchantLegalName) {
    this.merchantLegalName = merchantLegalName;
    return this;
  }

  /**
   * Legal Business Name of the Merchant.
   *
   * @return merchantLegalName Legal Business Name of the Merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantLegalName() {
    return merchantLegalName;
  }

  /**
   * Legal Business Name of the Merchant.
   *
   * @param merchantLegalName Legal Business Name of the Merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantLegalName(String merchantLegalName) {
    this.merchantLegalName = merchantLegalName;
  }

  /**
   * Merchant shop url.
   *
   * @param merchantShopUrl Merchant shop url.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo merchantShopUrl(String merchantShopUrl) {
    this.merchantShopUrl = merchantShopUrl;
    return this;
  }

  /**
   * Merchant shop url.
   *
   * @return merchantShopUrl Merchant shop url.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_SHOP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantShopUrl() {
    return merchantShopUrl;
  }

  /**
   * Merchant shop url.
   *
   * @param merchantShopUrl Merchant shop url.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_SHOP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantShopUrl(String merchantShopUrl) {
    this.merchantShopUrl = merchantShopUrl;
  }

  /**
   * The state/province of the merchant.
   *
   * @param merchantStateProvince The state/province of the merchant.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo merchantStateProvince(String merchantStateProvince) {
    this.merchantStateProvince = merchantStateProvince;
    return this;
  }

  /**
   * The state/province of the merchant.
   *
   * @return merchantStateProvince The state/province of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantStateProvince() {
    return merchantStateProvince;
  }

  /**
   * The state/province of the merchant.
   *
   * @param merchantStateProvince The state/province of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_STATE_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantStateProvince(String merchantStateProvince) {
    this.merchantStateProvince = merchantStateProvince;
  }

  /**
   * The street address of the merchant.
   *
   * @param merchantStreetAddress The street address of the merchant.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo merchantStreetAddress(String merchantStreetAddress) {
    this.merchantStreetAddress = merchantStreetAddress;
    return this;
  }

  /**
   * The street address of the merchant.
   *
   * @return merchantStreetAddress The street address of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_STREET_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantStreetAddress() {
    return merchantStreetAddress;
  }

  /**
   * The street address of the merchant.
   *
   * @param merchantStreetAddress The street address of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_STREET_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantStreetAddress(String merchantStreetAddress) {
    this.merchantStreetAddress = merchantStreetAddress;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo transactionDescription(
      TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
    return this;
  }

  /**
   * Get transactionDescription
   *
   * @return transactionDescription
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransactionDescriptionInfo getTransactionDescription() {
    return transactionDescription;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionDescription(TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
  }

  /**
   * The zip code of the account.
   *
   * @param zipCode The zip code of the account.
   * @return the current {@code PayByBankPlaidInfo} instance, allowing for method chaining
   */
  public PayByBankPlaidInfo zipCode(String zipCode) {
    this.zipCode = zipCode;
    return this;
  }

  /**
   * The zip code of the account.
   *
   * @return zipCode The zip code of the account.
   */
  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getZipCode() {
    return zipCode;
  }

  /**
   * The zip code of the account.
   *
   * @param zipCode The zip code of the account.
   */
  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZipCode(String zipCode) {
    this.zipCode = zipCode;
  }

  /** Return true if this PayByBankPlaidInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayByBankPlaidInfo payByBankPlaidInfo = (PayByBankPlaidInfo) o;
    return Objects.equals(this.countryCode, payByBankPlaidInfo.countryCode)
        && Objects.equals(this.logo, payByBankPlaidInfo.logo)
        && Objects.equals(this.merchantCity, payByBankPlaidInfo.merchantCity)
        && Objects.equals(this.merchantLegalName, payByBankPlaidInfo.merchantLegalName)
        && Objects.equals(this.merchantShopUrl, payByBankPlaidInfo.merchantShopUrl)
        && Objects.equals(this.merchantStateProvince, payByBankPlaidInfo.merchantStateProvince)
        && Objects.equals(this.merchantStreetAddress, payByBankPlaidInfo.merchantStreetAddress)
        && Objects.equals(this.transactionDescription, payByBankPlaidInfo.transactionDescription)
        && Objects.equals(this.zipCode, payByBankPlaidInfo.zipCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        countryCode,
        logo,
        merchantCity,
        merchantLegalName,
        merchantShopUrl,
        merchantStateProvince,
        merchantStreetAddress,
        transactionDescription,
        zipCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayByBankPlaidInfo {\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    merchantCity: ").append(toIndentedString(merchantCity)).append("\n");
    sb.append("    merchantLegalName: ").append(toIndentedString(merchantLegalName)).append("\n");
    sb.append("    merchantShopUrl: ").append(toIndentedString(merchantShopUrl)).append("\n");
    sb.append("    merchantStateProvince: ")
        .append(toIndentedString(merchantStateProvince))
        .append("\n");
    sb.append("    merchantStreetAddress: ")
        .append(toIndentedString(merchantStreetAddress))
        .append("\n");
    sb.append("    transactionDescription: ")
        .append(toIndentedString(transactionDescription))
        .append("\n");
    sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PayByBankPlaidInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayByBankPlaidInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PayByBankPlaidInfo
   */
  public static PayByBankPlaidInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayByBankPlaidInfo.class);
  }

  /**
   * Convert an instance of PayByBankPlaidInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
