/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Payment */
@JsonPropertyOrder({
  Payment.JSON_PROPERTY_CONTACTLESS_CURRENCY,
  Payment.JSON_PROPERTY_HIDE_MINOR_UNITS_IN_CURRENCIES
})
public class Payment {
  public static final String JSON_PROPERTY_CONTACTLESS_CURRENCY = "contactlessCurrency";
  private String contactlessCurrency;

  public static final String JSON_PROPERTY_HIDE_MINOR_UNITS_IN_CURRENCIES =
      "hideMinorUnitsInCurrencies";
  private List<String> hideMinorUnitsInCurrencies;

  public Payment() {}

  /**
   * The default currency for contactless payments on the payment terminal, as the three-letter [ISO
   * 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.
   *
   * @param contactlessCurrency The default currency for contactless payments on the payment
   *     terminal, as the three-letter [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency
   *     code.
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment contactlessCurrency(String contactlessCurrency) {
    this.contactlessCurrency = contactlessCurrency;
    return this;
  }

  /**
   * The default currency for contactless payments on the payment terminal, as the three-letter [ISO
   * 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.
   *
   * @return contactlessCurrency The default currency for contactless payments on the payment
   *     terminal, as the three-letter [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency
   *     code.
   */
  @JsonProperty(JSON_PROPERTY_CONTACTLESS_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getContactlessCurrency() {
    return contactlessCurrency;
  }

  /**
   * The default currency for contactless payments on the payment terminal, as the three-letter [ISO
   * 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.
   *
   * @param contactlessCurrency The default currency for contactless payments on the payment
   *     terminal, as the three-letter [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency
   *     code.
   */
  @JsonProperty(JSON_PROPERTY_CONTACTLESS_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactlessCurrency(String contactlessCurrency) {
    this.contactlessCurrency = contactlessCurrency;
  }

  /**
   * Hides the minor units for the listed [ISO currency
   * codes](https://en.wikipedia.org/wiki/ISO_4217).
   *
   * @param hideMinorUnitsInCurrencies Hides the minor units for the listed [ISO currency
   *     codes](https://en.wikipedia.org/wiki/ISO_4217).
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment hideMinorUnitsInCurrencies(List<String> hideMinorUnitsInCurrencies) {
    this.hideMinorUnitsInCurrencies = hideMinorUnitsInCurrencies;
    return this;
  }

  public Payment addHideMinorUnitsInCurrenciesItem(String hideMinorUnitsInCurrenciesItem) {
    if (this.hideMinorUnitsInCurrencies == null) {
      this.hideMinorUnitsInCurrencies = new ArrayList<>();
    }
    this.hideMinorUnitsInCurrencies.add(hideMinorUnitsInCurrenciesItem);
    return this;
  }

  /**
   * Hides the minor units for the listed [ISO currency
   * codes](https://en.wikipedia.org/wiki/ISO_4217).
   *
   * @return hideMinorUnitsInCurrencies Hides the minor units for the listed [ISO currency
   *     codes](https://en.wikipedia.org/wiki/ISO_4217).
   */
  @JsonProperty(JSON_PROPERTY_HIDE_MINOR_UNITS_IN_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getHideMinorUnitsInCurrencies() {
    return hideMinorUnitsInCurrencies;
  }

  /**
   * Hides the minor units for the listed [ISO currency
   * codes](https://en.wikipedia.org/wiki/ISO_4217).
   *
   * @param hideMinorUnitsInCurrencies Hides the minor units for the listed [ISO currency
   *     codes](https://en.wikipedia.org/wiki/ISO_4217).
   */
  @JsonProperty(JSON_PROPERTY_HIDE_MINOR_UNITS_IN_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideMinorUnitsInCurrencies(List<String> hideMinorUnitsInCurrencies) {
    this.hideMinorUnitsInCurrencies = hideMinorUnitsInCurrencies;
  }

  /** Return true if this Payment object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.contactlessCurrency, payment.contactlessCurrency)
        && Objects.equals(this.hideMinorUnitsInCurrencies, payment.hideMinorUnitsInCurrencies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactlessCurrency, hideMinorUnitsInCurrencies);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    contactlessCurrency: ")
        .append(toIndentedString(contactlessCurrency))
        .append("\n");
    sb.append("    hideMinorUnitsInCurrencies: ")
        .append(toIndentedString(hideMinorUnitsInCurrencies))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Payment given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Payment
   * @throws JsonProcessingException if the JSON string is invalid with respect to Payment
   */
  public static Payment fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Payment.class);
  }

  /**
   * Convert an instance of Payment to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
