/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PaymentMethodSetupInfo */
@JsonPropertyOrder({
  PaymentMethodSetupInfo.JSON_PROPERTY_ACCEL,
  PaymentMethodSetupInfo.JSON_PROPERTY_AFFIRM,
  PaymentMethodSetupInfo.JSON_PROPERTY_AFTERPAY_TOUCH,
  PaymentMethodSetupInfo.JSON_PROPERTY_AMEX,
  PaymentMethodSetupInfo.JSON_PROPERTY_APPLE_PAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_BCMC,
  PaymentMethodSetupInfo.JSON_PROPERTY_BUSINESS_LINE_ID,
  PaymentMethodSetupInfo.JSON_PROPERTY_CARTES_BANCAIRES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CLEARPAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_COUNTRIES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CUP,
  PaymentMethodSetupInfo.JSON_PROPERTY_CURRENCIES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CUSTOM_ROUTING_FLAGS,
  PaymentMethodSetupInfo.JSON_PROPERTY_DINERS,
  PaymentMethodSetupInfo.JSON_PROPERTY_DISCOVER,
  PaymentMethodSetupInfo.JSON_PROPERTY_EFT_DIRECTDEBIT_C_A,
  PaymentMethodSetupInfo.JSON_PROPERTY_EFTPOS_AUSTRALIA,
  PaymentMethodSetupInfo.JSON_PROPERTY_GIROCARD,
  PaymentMethodSetupInfo.JSON_PROPERTY_GOOGLE_PAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_IDEAL,
  PaymentMethodSetupInfo.JSON_PROPERTY_INTERAC_CARD,
  PaymentMethodSetupInfo.JSON_PROPERTY_JCB,
  PaymentMethodSetupInfo.JSON_PROPERTY_KLARNA,
  PaymentMethodSetupInfo.JSON_PROPERTY_MAESTRO,
  PaymentMethodSetupInfo.JSON_PROPERTY_MC,
  PaymentMethodSetupInfo.JSON_PROPERTY_MEAL_VOUCHER_F_R,
  PaymentMethodSetupInfo.JSON_PROPERTY_NYCE,
  PaymentMethodSetupInfo.JSON_PROPERTY_PAYBYBANK_PLAID,
  PaymentMethodSetupInfo.JSON_PROPERTY_PAYME,
  PaymentMethodSetupInfo.JSON_PROPERTY_PAYPAL,
  PaymentMethodSetupInfo.JSON_PROPERTY_PAYTO,
  PaymentMethodSetupInfo.JSON_PROPERTY_PULSE,
  PaymentMethodSetupInfo.JSON_PROPERTY_REFERENCE,
  PaymentMethodSetupInfo.JSON_PROPERTY_SHOPPER_INTERACTION,
  PaymentMethodSetupInfo.JSON_PROPERTY_SODEXO,
  PaymentMethodSetupInfo.JSON_PROPERTY_SOFORT,
  PaymentMethodSetupInfo.JSON_PROPERTY_STAR,
  PaymentMethodSetupInfo.JSON_PROPERTY_STORE_IDS,
  PaymentMethodSetupInfo.JSON_PROPERTY_SWISH,
  PaymentMethodSetupInfo.JSON_PROPERTY_TICKET,
  PaymentMethodSetupInfo.JSON_PROPERTY_TWINT,
  PaymentMethodSetupInfo.JSON_PROPERTY_TYPE,
  PaymentMethodSetupInfo.JSON_PROPERTY_VIPPS,
  PaymentMethodSetupInfo.JSON_PROPERTY_VISA,
  PaymentMethodSetupInfo.JSON_PROPERTY_WECHATPAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_WECHATPAY_POS
})
public class PaymentMethodSetupInfo {
  public static final String JSON_PROPERTY_ACCEL = "accel";
  private AccelInfo accel;

  public static final String JSON_PROPERTY_AFFIRM = "affirm";
  private AffirmInfo affirm;

  public static final String JSON_PROPERTY_AFTERPAY_TOUCH = "afterpayTouch";
  private AfterpayTouchInfo afterpayTouch;

  public static final String JSON_PROPERTY_AMEX = "amex";
  private AmexInfo amex;

  public static final String JSON_PROPERTY_APPLE_PAY = "applePay";
  private ApplePayInfo applePay;

  public static final String JSON_PROPERTY_BCMC = "bcmc";
  private BcmcInfo bcmc;

  public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
  private String businessLineId;

  public static final String JSON_PROPERTY_CARTES_BANCAIRES = "cartesBancaires";
  private CartesBancairesInfo cartesBancaires;

  public static final String JSON_PROPERTY_CLEARPAY = "clearpay";
  private ClearpayInfo clearpay;

  public static final String JSON_PROPERTY_COUNTRIES = "countries";
  private List<String> countries;

  public static final String JSON_PROPERTY_CUP = "cup";
  private GenericPmWithTdiInfo cup;

  public static final String JSON_PROPERTY_CURRENCIES = "currencies";
  private List<String> currencies;

  public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
  private List<String> customRoutingFlags;

  public static final String JSON_PROPERTY_DINERS = "diners";
  private DinersInfo diners;

  public static final String JSON_PROPERTY_DISCOVER = "discover";
  private GenericPmWithTdiInfo discover;

  public static final String JSON_PROPERTY_EFT_DIRECTDEBIT_C_A = "eft_directdebit_CA";
  private GenericPmWithTdiInfo eftDirectdebitCA;

  public static final String JSON_PROPERTY_EFTPOS_AUSTRALIA = "eftpos_australia";
  private GenericPmWithTdiInfo eftposAustralia;

  public static final String JSON_PROPERTY_GIROCARD = "girocard";
  private GenericPmWithTdiInfo girocard;

  public static final String JSON_PROPERTY_GOOGLE_PAY = "googlePay";
  private GooglePayInfo googlePay;

  public static final String JSON_PROPERTY_IDEAL = "ideal";
  private GenericPmWithTdiInfo ideal;

  public static final String JSON_PROPERTY_INTERAC_CARD = "interac_card";
  private GenericPmWithTdiInfo interacCard;

  public static final String JSON_PROPERTY_JCB = "jcb";
  private JCBInfo jcb;

  public static final String JSON_PROPERTY_KLARNA = "klarna";
  private KlarnaInfo klarna;

  public static final String JSON_PROPERTY_MAESTRO = "maestro";
  private GenericPmWithTdiInfo maestro;

  public static final String JSON_PROPERTY_MC = "mc";
  private GenericPmWithTdiInfo mc;

  public static final String JSON_PROPERTY_MEAL_VOUCHER_F_R = "mealVoucher_FR";
  private MealVoucherFRInfo mealVoucherFR;

  public static final String JSON_PROPERTY_NYCE = "nyce";
  private NyceInfo nyce;

  public static final String JSON_PROPERTY_PAYBYBANK_PLAID = "paybybank_plaid";
  private PayByBankPlaidInfo paybybankPlaid;

  public static final String JSON_PROPERTY_PAYME = "payme";
  private PayMeInfo payme;

  public static final String JSON_PROPERTY_PAYPAL = "paypal";
  private PayPalInfo paypal;

  public static final String JSON_PROPERTY_PAYTO = "payto";
  private PayToInfo payto;

  public static final String JSON_PROPERTY_PULSE = "pulse";
  private PulseInfo pulse;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you
   * provide this field, it overrides the default sales channel set on the merchant account.
   * Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE(String.valueOf("eCommerce")),

    POS(String.valueOf("pos")),

    MOTO(String.valueOf("moto")),

    CONTAUTH(String.valueOf("contAuth"));

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SODEXO = "sodexo";
  private SodexoInfo sodexo;

  public static final String JSON_PROPERTY_SOFORT = "sofort";
  private SofortInfo sofort;

  public static final String JSON_PROPERTY_STAR = "star";
  private StarInfo star;

  public static final String JSON_PROPERTY_STORE_IDS = "storeIds";
  private List<String> storeIds;

  public static final String JSON_PROPERTY_SWISH = "swish";
  private SwishInfo swish;

  public static final String JSON_PROPERTY_TICKET = "ticket";
  private TicketInfo ticket;

  public static final String JSON_PROPERTY_TWINT = "twint";
  private TwintInfo twint;

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  public enum TypeEnum {
    ACCEL(String.valueOf("accel")),

    ACH(String.valueOf("ach")),

    AFFIRM(String.valueOf("affirm")),

    AFTERPAYTOUCH(String.valueOf("afterpaytouch")),

    ALELO(String.valueOf("alelo")),

    ALIPAY(String.valueOf("alipay")),

    ALIPAY_HK(String.valueOf("alipay_hk")),

    ALIPAY_WAP(String.valueOf("alipay_wap")),

    AMEX(String.valueOf("amex")),

    APPLEPAY(String.valueOf("applepay")),

    BANESE_CARD(String.valueOf("banese_card")),

    BANESE_CARD_CREDIT(String.valueOf("banese_card_credit")),

    BANESE_CARD_DEBIT(String.valueOf("banese_card_debit")),

    BANESE_CARD_PREPAID(String.valueOf("banese_card_prepaid")),

    BCMC(String.valueOf("bcmc")),

    BLIK(String.valueOf("blik")),

    CARTEBANCAIRE(String.valueOf("cartebancaire")),

    CLEARPAY(String.valueOf("clearpay")),

    CLICKTOPAY(String.valueOf("clicktopay")),

    CREDTODOS(String.valueOf("credtodos")),

    CREDTODOS_PRIVATE_CREDIT(String.valueOf("credtodos_private_credit")),

    CREDTODOS_PRIVATE_DEBIT(String.valueOf("credtodos_private_debit")),

    CUP(String.valueOf("cup")),

    DINERS(String.valueOf("diners")),

    DIRECTDEBIT_GB(String.valueOf("directdebit_GB")),

    DISCOVER(String.valueOf("discover")),

    EBANKING_FI(String.valueOf("ebanking_FI")),

    EFT_DIRECTDEBIT_CA(String.valueOf("eft_directdebit_CA")),

    EFTPOS_AUSTRALIA(String.valueOf("eftpos_australia")),

    ELO(String.valueOf("elo")),

    ELOCREDIT(String.valueOf("elocredit")),

    ELODEBIT(String.valueOf("elodebit")),

    GIROCARD(String.valueOf("girocard")),

    GOOGLEPAY(String.valueOf("googlepay")),

    HIPER(String.valueOf("hiper")),

    HIPERCARD(String.valueOf("hipercard")),

    IDEAL(String.valueOf("ideal")),

    INTERAC_CARD(String.valueOf("interac_card")),

    JCB(String.valueOf("jcb")),

    KLARNA(String.valueOf("klarna")),

    KLARNA_ACCOUNT(String.valueOf("klarna_account")),

    KLARNA_PAYNOW(String.valueOf("klarna_paynow")),

    MAESTRO(String.valueOf("maestro")),

    MBWAY(String.valueOf("mbway")),

    MC(String.valueOf("mc")),

    MCDEBIT(String.valueOf("mcdebit")),

    MEALVOUCHER_FR(String.valueOf("mealVoucher_FR")),

    MOBILEPAY(String.valueOf("mobilepay")),

    MULTIBANCO(String.valueOf("multibanco")),

    NYCE(String.valueOf("nyce")),

    ONLINEBANKING_PL(String.valueOf("onlineBanking_PL")),

    PAYBYBANK(String.valueOf("paybybank")),

    PAYBYBANK_PLAID(String.valueOf("paybybank_plaid")),

    PAYME(String.valueOf("payme")),

    PAYME_POS(String.valueOf("payme_pos")),

    PAYNOW(String.valueOf("paynow")),

    PAYNOW_POS(String.valueOf("paynow_pos")),

    PAYPAL(String.valueOf("paypal")),

    PAYTO(String.valueOf("payto")),

    PULSE(String.valueOf("pulse")),

    SODEXO(String.valueOf("sodexo")),

    STAR(String.valueOf("star")),

    SWISH(String.valueOf("swish")),

    TICKET(String.valueOf("ticket")),

    TODO_GIFTCARD(String.valueOf("todo_giftcard")),

    TRUSTLY(String.valueOf("trustly")),

    TWINT(String.valueOf("twint")),

    TWINT_POS(String.valueOf("twint_pos")),

    UP_BRAZIL_CREDIT(String.valueOf("up_brazil_credit")),

    VALE_REFEICAO(String.valueOf("vale_refeicao")),

    VALE_REFEICAO_PREPAID(String.valueOf("vale_refeicao_prepaid")),

    VIPPS(String.valueOf("vipps")),

    VISA(String.valueOf("visa")),

    VISADEBIT(String.valueOf("visadebit")),

    VPAY(String.valueOf("vpay")),

    WECHATPAY(String.valueOf("wechatpay")),

    WECHATPAY_POS(String.valueOf("wechatpay_pos"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VIPPS = "vipps";
  private VippsInfo vipps;

  public static final String JSON_PROPERTY_VISA = "visa";
  private GenericPmWithTdiInfo visa;

  public static final String JSON_PROPERTY_WECHATPAY = "wechatpay";
  private WeChatPayInfo wechatpay;

  public static final String JSON_PROPERTY_WECHATPAY_POS = "wechatpay_pos";
  private WeChatPayPosInfo wechatpayPos;

  public PaymentMethodSetupInfo() {}

  /**
   * accel
   *
   * @param accel
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo accel(AccelInfo accel) {
    this.accel = accel;
    return this;
  }

  /**
   * Get accel
   *
   * @return accel
   */
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccelInfo getAccel() {
    return accel;
  }

  /**
   * accel
   *
   * @param accel
   */
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccel(AccelInfo accel) {
    this.accel = accel;
  }

  /**
   * affirm
   *
   * @param affirm
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo affirm(AffirmInfo affirm) {
    this.affirm = affirm;
    return this;
  }

  /**
   * Get affirm
   *
   * @return affirm
   */
  @JsonProperty(JSON_PROPERTY_AFFIRM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AffirmInfo getAffirm() {
    return affirm;
  }

  /**
   * affirm
   *
   * @param affirm
   */
  @JsonProperty(JSON_PROPERTY_AFFIRM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffirm(AffirmInfo affirm) {
    this.affirm = affirm;
  }

  /**
   * afterpayTouch
   *
   * @param afterpayTouch
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo afterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
    return this;
  }

  /**
   * Get afterpayTouch
   *
   * @return afterpayTouch
   */
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AfterpayTouchInfo getAfterpayTouch() {
    return afterpayTouch;
  }

  /**
   * afterpayTouch
   *
   * @param afterpayTouch
   */
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAfterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
  }

  /**
   * amex
   *
   * @param amex
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo amex(AmexInfo amex) {
    this.amex = amex;
    return this;
  }

  /**
   * Get amex
   *
   * @return amex
   */
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AmexInfo getAmex() {
    return amex;
  }

  /**
   * amex
   *
   * @param amex
   */
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmex(AmexInfo amex) {
    this.amex = amex;
  }

  /**
   * applePay
   *
   * @param applePay
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo applePay(ApplePayInfo applePay) {
    this.applePay = applePay;
    return this;
  }

  /**
   * Get applePay
   *
   * @return applePay
   */
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplePayInfo getApplePay() {
    return applePay;
  }

  /**
   * applePay
   *
   * @param applePay
   */
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplePay(ApplePayInfo applePay) {
    this.applePay = applePay;
  }

  /**
   * bcmc
   *
   * @param bcmc
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo bcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
    return this;
  }

  /**
   * Get bcmc
   *
   * @return bcmc
   */
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BcmcInfo getBcmc() {
    return bcmc;
  }

  /**
   * bcmc
   *
   * @param bcmc
   */
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @param businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo businessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
    return this;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @return businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   */
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBusinessLineId() {
    return businessLineId;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @param businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   */
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
  }

  /**
   * cartesBancaires
   *
   * @param cartesBancaires
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo cartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
    return this;
  }

  /**
   * Get cartesBancaires
   *
   * @return cartesBancaires
   */
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CartesBancairesInfo getCartesBancaires() {
    return cartesBancaires;
  }

  /**
   * cartesBancaires
   *
   * @param cartesBancaires
   */
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
  }

  /**
   * clearpay
   *
   * @param clearpay
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo clearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
    return this;
  }

  /**
   * Get clearpay
   *
   * @return clearpay
   */
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ClearpayInfo getClearpay() {
    return clearpay;
  }

  /**
   * clearpay
   *
   * @param clearpay
   */
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @param countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo countries(List<String> countries) {
    this.countries = countries;
    return this;
  }

  public PaymentMethodSetupInfo addCountriesItem(String countriesItem) {
    if (this.countries == null) {
      this.countries = new ArrayList<>();
    }
    this.countries.add(countriesItem);
    return this;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @return countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCountries() {
    return countries;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @param countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountries(List<String> countries) {
    this.countries = countries;
  }

  /**
   * cup
   *
   * @param cup
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo cup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
    return this;
  }

  /**
   * Get cup
   *
   * @return cup
   */
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getCup() {
    return cup;
  }

  /**
   * cup
   *
   * @param cup
   */
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @param currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo currencies(List<String> currencies) {
    this.currencies = currencies;
    return this;
  }

  public PaymentMethodSetupInfo addCurrenciesItem(String currenciesItem) {
    if (this.currencies == null) {
      this.currencies = new ArrayList<>();
    }
    this.currencies.add(currenciesItem);
    return this;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @return currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCurrencies() {
    return currencies;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @param currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencies(List<String> currencies) {
    this.currencies = currencies;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @param customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo customRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
    return this;
  }

  public PaymentMethodSetupInfo addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
    if (this.customRoutingFlags == null) {
      this.customRoutingFlags = new ArrayList<>();
    }
    this.customRoutingFlags.add(customRoutingFlagsItem);
    return this;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @return customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCustomRoutingFlags() {
    return customRoutingFlags;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @param customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
  }

  /**
   * diners
   *
   * @param diners
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo diners(DinersInfo diners) {
    this.diners = diners;
    return this;
  }

  /**
   * Get diners
   *
   * @return diners
   */
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DinersInfo getDiners() {
    return diners;
  }

  /**
   * diners
   *
   * @param diners
   */
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiners(DinersInfo diners) {
    this.diners = diners;
  }

  /**
   * discover
   *
   * @param discover
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo discover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
    return this;
  }

  /**
   * Get discover
   *
   * @return discover
   */
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getDiscover() {
    return discover;
  }

  /**
   * discover
   *
   * @param discover
   */
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
  }

  /**
   * eftDirectdebitCA
   *
   * @param eftDirectdebitCA
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo eftDirectdebitCA(GenericPmWithTdiInfo eftDirectdebitCA) {
    this.eftDirectdebitCA = eftDirectdebitCA;
    return this;
  }

  /**
   * Get eftDirectdebitCA
   *
   * @return eftDirectdebitCA
   */
  @JsonProperty(JSON_PROPERTY_EFT_DIRECTDEBIT_C_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getEftDirectdebitCA() {
    return eftDirectdebitCA;
  }

  /**
   * eftDirectdebitCA
   *
   * @param eftDirectdebitCA
   */
  @JsonProperty(JSON_PROPERTY_EFT_DIRECTDEBIT_C_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftDirectdebitCA(GenericPmWithTdiInfo eftDirectdebitCA) {
    this.eftDirectdebitCA = eftDirectdebitCA;
  }

  /**
   * eftposAustralia
   *
   * @param eftposAustralia
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo eftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
    return this;
  }

  /**
   * Get eftposAustralia
   *
   * @return eftposAustralia
   */
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getEftposAustralia() {
    return eftposAustralia;
  }

  /**
   * eftposAustralia
   *
   * @param eftposAustralia
   */
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
  }

  /**
   * girocard
   *
   * @param girocard
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo girocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
    return this;
  }

  /**
   * Get girocard
   *
   * @return girocard
   */
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getGirocard() {
    return girocard;
  }

  /**
   * girocard
   *
   * @param girocard
   */
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGirocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
  }

  /**
   * googlePay
   *
   * @param googlePay
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo googlePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
    return this;
  }

  /**
   * Get googlePay
   *
   * @return googlePay
   */
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GooglePayInfo getGooglePay() {
    return googlePay;
  }

  /**
   * googlePay
   *
   * @param googlePay
   */
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
  }

  /**
   * ideal
   *
   * @param ideal
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo ideal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
    return this;
  }

  /**
   * Get ideal
   *
   * @return ideal
   */
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getIdeal() {
    return ideal;
  }

  /**
   * ideal
   *
   * @param ideal
   */
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdeal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
  }

  /**
   * interacCard
   *
   * @param interacCard
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo interacCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
    return this;
  }

  /**
   * Get interacCard
   *
   * @return interacCard
   */
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getInteracCard() {
    return interacCard;
  }

  /**
   * interacCard
   *
   * @param interacCard
   */
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInteracCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
  }

  /**
   * jcb
   *
   * @param jcb
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo jcb(JCBInfo jcb) {
    this.jcb = jcb;
    return this;
  }

  /**
   * Get jcb
   *
   * @return jcb
   */
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JCBInfo getJcb() {
    return jcb;
  }

  /**
   * jcb
   *
   * @param jcb
   */
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJcb(JCBInfo jcb) {
    this.jcb = jcb;
  }

  /**
   * klarna
   *
   * @param klarna
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo klarna(KlarnaInfo klarna) {
    this.klarna = klarna;
    return this;
  }

  /**
   * Get klarna
   *
   * @return klarna
   */
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public KlarnaInfo getKlarna() {
    return klarna;
  }

  /**
   * klarna
   *
   * @param klarna
   */
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKlarna(KlarnaInfo klarna) {
    this.klarna = klarna;
  }

  /**
   * maestro
   *
   * @param maestro
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo maestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
    return this;
  }

  /**
   * Get maestro
   *
   * @return maestro
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getMaestro() {
    return maestro;
  }

  /**
   * maestro
   *
   * @param maestro
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
  }

  /**
   * mc
   *
   * @param mc
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo mc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
    return this;
  }

  /**
   * Get mc
   *
   * @return mc
   */
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getMc() {
    return mc;
  }

  /**
   * mc
   *
   * @param mc
   */
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
  }

  /**
   * mealVoucherFR
   *
   * @param mealVoucherFR
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
    return this;
  }

  /**
   * Get mealVoucherFR
   *
   * @return mealVoucherFR
   */
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MealVoucherFRInfo getMealVoucherFR() {
    return mealVoucherFR;
  }

  /**
   * mealVoucherFR
   *
   * @param mealVoucherFR
   */
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
  }

  /**
   * nyce
   *
   * @param nyce
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo nyce(NyceInfo nyce) {
    this.nyce = nyce;
    return this;
  }

  /**
   * Get nyce
   *
   * @return nyce
   */
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NyceInfo getNyce() {
    return nyce;
  }

  /**
   * nyce
   *
   * @param nyce
   */
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNyce(NyceInfo nyce) {
    this.nyce = nyce;
  }

  /**
   * paybybankPlaid
   *
   * @param paybybankPlaid
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo paybybankPlaid(PayByBankPlaidInfo paybybankPlaid) {
    this.paybybankPlaid = paybybankPlaid;
    return this;
  }

  /**
   * Get paybybankPlaid
   *
   * @return paybybankPlaid
   */
  @JsonProperty(JSON_PROPERTY_PAYBYBANK_PLAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayByBankPlaidInfo getPaybybankPlaid() {
    return paybybankPlaid;
  }

  /**
   * paybybankPlaid
   *
   * @param paybybankPlaid
   */
  @JsonProperty(JSON_PROPERTY_PAYBYBANK_PLAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaybybankPlaid(PayByBankPlaidInfo paybybankPlaid) {
    this.paybybankPlaid = paybybankPlaid;
  }

  /**
   * payme
   *
   * @param payme
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo payme(PayMeInfo payme) {
    this.payme = payme;
    return this;
  }

  /**
   * Get payme
   *
   * @return payme
   */
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayMeInfo getPayme() {
    return payme;
  }

  /**
   * payme
   *
   * @param payme
   */
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayme(PayMeInfo payme) {
    this.payme = payme;
  }

  /**
   * paypal
   *
   * @param paypal
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo paypal(PayPalInfo paypal) {
    this.paypal = paypal;
    return this;
  }

  /**
   * Get paypal
   *
   * @return paypal
   */
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayPalInfo getPaypal() {
    return paypal;
  }

  /**
   * paypal
   *
   * @param paypal
   */
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaypal(PayPalInfo paypal) {
    this.paypal = paypal;
  }

  /**
   * payto
   *
   * @param payto
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo payto(PayToInfo payto) {
    this.payto = payto;
    return this;
  }

  /**
   * Get payto
   *
   * @return payto
   */
  @JsonProperty(JSON_PROPERTY_PAYTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayToInfo getPayto() {
    return payto;
  }

  /**
   * payto
   *
   * @param payto
   */
  @JsonProperty(JSON_PROPERTY_PAYTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayto(PayToInfo payto) {
    this.payto = payto;
  }

  /**
   * pulse
   *
   * @param pulse
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo pulse(PulseInfo pulse) {
    this.pulse = pulse;
    return this;
  }

  /**
   * Get pulse
   *
   * @return pulse
   */
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PulseInfo getPulse() {
    return pulse;
  }

  /**
   * pulse
   *
   * @param pulse
   */
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPulse(PulseInfo pulse) {
    this.pulse = pulse;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @param reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @return reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @param reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you
   * provide this field, it overrides the default sales channel set on the merchant account.
   * Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   *
   * @param shopperInteraction The sales channel. Required if the merchant account does not have a
   *     sales channel. When you provide this field, it overrides the default sales channel set on
   *     the merchant account. Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

  /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you
   * provide this field, it overrides the default sales channel set on the merchant account.
   * Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   *
   * @return shopperInteraction The sales channel. Required if the merchant account does not have a
   *     sales channel. When you provide this field, it overrides the default sales channel set on
   *     the merchant account. Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }

  /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you
   * provide this field, it overrides the default sales channel set on the merchant account.
   * Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   *
   * @param shopperInteraction The sales channel. Required if the merchant account does not have a
   *     sales channel. When you provide this field, it overrides the default sales channel set on
   *     the merchant account. Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }

  /**
   * sodexo
   *
   * @param sodexo
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo sodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
    return this;
  }

  /**
   * Get sodexo
   *
   * @return sodexo
   */
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SodexoInfo getSodexo() {
    return sodexo;
  }

  /**
   * sodexo
   *
   * @param sodexo
   */
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
  }

  /**
   * sofort
   *
   * @param sofort
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo sofort(SofortInfo sofort) {
    this.sofort = sofort;
    return this;
  }

  /**
   * Get sofort
   *
   * @return sofort
   */
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SofortInfo getSofort() {
    return sofort;
  }

  /**
   * sofort
   *
   * @param sofort
   */
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSofort(SofortInfo sofort) {
    this.sofort = sofort;
  }

  /**
   * star
   *
   * @param star
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo star(StarInfo star) {
    this.star = star;
    return this;
  }

  /**
   * Get star
   *
   * @return star
   */
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StarInfo getStar() {
    return star;
  }

  /**
   * star
   *
   * @param star
   */
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStar(StarInfo star) {
    this.star = star;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @param storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo storeIds(List<String> storeIds) {
    this.storeIds = storeIds;
    return this;
  }

  public PaymentMethodSetupInfo addStoreIdsItem(String storeIdsItem) {
    if (this.storeIds == null) {
      this.storeIds = new ArrayList<>();
    }
    this.storeIds.add(storeIdsItem);
    return this;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @return storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   */
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getStoreIds() {
    return storeIds;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @param storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   */
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreIds(List<String> storeIds) {
    this.storeIds = storeIds;
  }

  /**
   * swish
   *
   * @param swish
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo swish(SwishInfo swish) {
    this.swish = swish;
    return this;
  }

  /**
   * Get swish
   *
   * @return swish
   */
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SwishInfo getSwish() {
    return swish;
  }

  /**
   * swish
   *
   * @param swish
   */
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSwish(SwishInfo swish) {
    this.swish = swish;
  }

  /**
   * ticket
   *
   * @param ticket
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo ticket(TicketInfo ticket) {
    this.ticket = ticket;
    return this;
  }

  /**
   * Get ticket
   *
   * @return ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TicketInfo getTicket() {
    return ticket;
  }

  /**
   * ticket
   *
   * @param ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTicket(TicketInfo ticket) {
    this.ticket = ticket;
  }

  /**
   * twint
   *
   * @param twint
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo twint(TwintInfo twint) {
    this.twint = twint;
    return this;
  }

  /**
   * Get twint
   *
   * @return twint
   */
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TwintInfo getTwint() {
    return twint;
  }

  /**
   * twint
   *
   * @param twint
   */
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwint(TwintInfo twint) {
    this.twint = twint;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @param type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @return type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @param type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * vipps
   *
   * @param vipps
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo vipps(VippsInfo vipps) {
    this.vipps = vipps;
    return this;
  }

  /**
   * Get vipps
   *
   * @return vipps
   */
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VippsInfo getVipps() {
    return vipps;
  }

  /**
   * vipps
   *
   * @param vipps
   */
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVipps(VippsInfo vipps) {
    this.vipps = vipps;
  }

  /**
   * visa
   *
   * @param visa
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo visa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
    return this;
  }

  /**
   * Get visa
   *
   * @return visa
   */
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getVisa() {
    return visa;
  }

  /**
   * visa
   *
   * @param visa
   */
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
  }

  /**
   * wechatpay
   *
   * @param wechatpay
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo wechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
    return this;
  }

  /**
   * Get wechatpay
   *
   * @return wechatpay
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WeChatPayInfo getWechatpay() {
    return wechatpay;
  }

  /**
   * wechatpay
   *
   * @param wechatpay
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
  }

  /**
   * wechatpayPos
   *
   * @param wechatpayPos
   * @return the current {@code PaymentMethodSetupInfo} instance, allowing for method chaining
   */
  public PaymentMethodSetupInfo wechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
    return this;
  }

  /**
   * Get wechatpayPos
   *
   * @return wechatpayPos
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WeChatPayPosInfo getWechatpayPos() {
    return wechatpayPos;
  }

  /**
   * wechatpayPos
   *
   * @param wechatpayPos
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
  }

  /** Return true if this PaymentMethodSetupInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodSetupInfo paymentMethodSetupInfo = (PaymentMethodSetupInfo) o;
    return Objects.equals(this.accel, paymentMethodSetupInfo.accel)
        && Objects.equals(this.affirm, paymentMethodSetupInfo.affirm)
        && Objects.equals(this.afterpayTouch, paymentMethodSetupInfo.afterpayTouch)
        && Objects.equals(this.amex, paymentMethodSetupInfo.amex)
        && Objects.equals(this.applePay, paymentMethodSetupInfo.applePay)
        && Objects.equals(this.bcmc, paymentMethodSetupInfo.bcmc)
        && Objects.equals(this.businessLineId, paymentMethodSetupInfo.businessLineId)
        && Objects.equals(this.cartesBancaires, paymentMethodSetupInfo.cartesBancaires)
        && Objects.equals(this.clearpay, paymentMethodSetupInfo.clearpay)
        && Objects.equals(this.countries, paymentMethodSetupInfo.countries)
        && Objects.equals(this.cup, paymentMethodSetupInfo.cup)
        && Objects.equals(this.currencies, paymentMethodSetupInfo.currencies)
        && Objects.equals(this.customRoutingFlags, paymentMethodSetupInfo.customRoutingFlags)
        && Objects.equals(this.diners, paymentMethodSetupInfo.diners)
        && Objects.equals(this.discover, paymentMethodSetupInfo.discover)
        && Objects.equals(this.eftDirectdebitCA, paymentMethodSetupInfo.eftDirectdebitCA)
        && Objects.equals(this.eftposAustralia, paymentMethodSetupInfo.eftposAustralia)
        && Objects.equals(this.girocard, paymentMethodSetupInfo.girocard)
        && Objects.equals(this.googlePay, paymentMethodSetupInfo.googlePay)
        && Objects.equals(this.ideal, paymentMethodSetupInfo.ideal)
        && Objects.equals(this.interacCard, paymentMethodSetupInfo.interacCard)
        && Objects.equals(this.jcb, paymentMethodSetupInfo.jcb)
        && Objects.equals(this.klarna, paymentMethodSetupInfo.klarna)
        && Objects.equals(this.maestro, paymentMethodSetupInfo.maestro)
        && Objects.equals(this.mc, paymentMethodSetupInfo.mc)
        && Objects.equals(this.mealVoucherFR, paymentMethodSetupInfo.mealVoucherFR)
        && Objects.equals(this.nyce, paymentMethodSetupInfo.nyce)
        && Objects.equals(this.paybybankPlaid, paymentMethodSetupInfo.paybybankPlaid)
        && Objects.equals(this.payme, paymentMethodSetupInfo.payme)
        && Objects.equals(this.paypal, paymentMethodSetupInfo.paypal)
        && Objects.equals(this.payto, paymentMethodSetupInfo.payto)
        && Objects.equals(this.pulse, paymentMethodSetupInfo.pulse)
        && Objects.equals(this.reference, paymentMethodSetupInfo.reference)
        && Objects.equals(this.shopperInteraction, paymentMethodSetupInfo.shopperInteraction)
        && Objects.equals(this.sodexo, paymentMethodSetupInfo.sodexo)
        && Objects.equals(this.sofort, paymentMethodSetupInfo.sofort)
        && Objects.equals(this.star, paymentMethodSetupInfo.star)
        && Objects.equals(this.storeIds, paymentMethodSetupInfo.storeIds)
        && Objects.equals(this.swish, paymentMethodSetupInfo.swish)
        && Objects.equals(this.ticket, paymentMethodSetupInfo.ticket)
        && Objects.equals(this.twint, paymentMethodSetupInfo.twint)
        && Objects.equals(this.type, paymentMethodSetupInfo.type)
        && Objects.equals(this.vipps, paymentMethodSetupInfo.vipps)
        && Objects.equals(this.visa, paymentMethodSetupInfo.visa)
        && Objects.equals(this.wechatpay, paymentMethodSetupInfo.wechatpay)
        && Objects.equals(this.wechatpayPos, paymentMethodSetupInfo.wechatpayPos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accel,
        affirm,
        afterpayTouch,
        amex,
        applePay,
        bcmc,
        businessLineId,
        cartesBancaires,
        clearpay,
        countries,
        cup,
        currencies,
        customRoutingFlags,
        diners,
        discover,
        eftDirectdebitCA,
        eftposAustralia,
        girocard,
        googlePay,
        ideal,
        interacCard,
        jcb,
        klarna,
        maestro,
        mc,
        mealVoucherFR,
        nyce,
        paybybankPlaid,
        payme,
        paypal,
        payto,
        pulse,
        reference,
        shopperInteraction,
        sodexo,
        sofort,
        star,
        storeIds,
        swish,
        ticket,
        twint,
        type,
        vipps,
        visa,
        wechatpay,
        wechatpayPos);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodSetupInfo {\n");
    sb.append("    accel: ").append(toIndentedString(accel)).append("\n");
    sb.append("    affirm: ").append(toIndentedString(affirm)).append("\n");
    sb.append("    afterpayTouch: ").append(toIndentedString(afterpayTouch)).append("\n");
    sb.append("    amex: ").append(toIndentedString(amex)).append("\n");
    sb.append("    applePay: ").append(toIndentedString(applePay)).append("\n");
    sb.append("    bcmc: ").append(toIndentedString(bcmc)).append("\n");
    sb.append("    businessLineId: ").append(toIndentedString(businessLineId)).append("\n");
    sb.append("    cartesBancaires: ").append(toIndentedString(cartesBancaires)).append("\n");
    sb.append("    clearpay: ").append(toIndentedString(clearpay)).append("\n");
    sb.append("    countries: ").append(toIndentedString(countries)).append("\n");
    sb.append("    cup: ").append(toIndentedString(cup)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    customRoutingFlags: ").append(toIndentedString(customRoutingFlags)).append("\n");
    sb.append("    diners: ").append(toIndentedString(diners)).append("\n");
    sb.append("    discover: ").append(toIndentedString(discover)).append("\n");
    sb.append("    eftDirectdebitCA: ").append(toIndentedString(eftDirectdebitCA)).append("\n");
    sb.append("    eftposAustralia: ").append(toIndentedString(eftposAustralia)).append("\n");
    sb.append("    girocard: ").append(toIndentedString(girocard)).append("\n");
    sb.append("    googlePay: ").append(toIndentedString(googlePay)).append("\n");
    sb.append("    ideal: ").append(toIndentedString(ideal)).append("\n");
    sb.append("    interacCard: ").append(toIndentedString(interacCard)).append("\n");
    sb.append("    jcb: ").append(toIndentedString(jcb)).append("\n");
    sb.append("    klarna: ").append(toIndentedString(klarna)).append("\n");
    sb.append("    maestro: ").append(toIndentedString(maestro)).append("\n");
    sb.append("    mc: ").append(toIndentedString(mc)).append("\n");
    sb.append("    mealVoucherFR: ").append(toIndentedString(mealVoucherFR)).append("\n");
    sb.append("    nyce: ").append(toIndentedString(nyce)).append("\n");
    sb.append("    paybybankPlaid: ").append(toIndentedString(paybybankPlaid)).append("\n");
    sb.append("    payme: ").append(toIndentedString(payme)).append("\n");
    sb.append("    paypal: ").append(toIndentedString(paypal)).append("\n");
    sb.append("    payto: ").append(toIndentedString(payto)).append("\n");
    sb.append("    pulse: ").append(toIndentedString(pulse)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    sodexo: ").append(toIndentedString(sodexo)).append("\n");
    sb.append("    sofort: ").append(toIndentedString(sofort)).append("\n");
    sb.append("    star: ").append(toIndentedString(star)).append("\n");
    sb.append("    storeIds: ").append(toIndentedString(storeIds)).append("\n");
    sb.append("    swish: ").append(toIndentedString(swish)).append("\n");
    sb.append("    ticket: ").append(toIndentedString(ticket)).append("\n");
    sb.append("    twint: ").append(toIndentedString(twint)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vipps: ").append(toIndentedString(vipps)).append("\n");
    sb.append("    visa: ").append(toIndentedString(visa)).append("\n");
    sb.append("    wechatpay: ").append(toIndentedString(wechatpay)).append("\n");
    sb.append("    wechatpayPos: ").append(toIndentedString(wechatpayPos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentMethodSetupInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethodSetupInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaymentMethodSetupInfo
   */
  public static PaymentMethodSetupInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethodSetupInfo.class);
  }

  /**
   * Convert an instance of PaymentMethodSetupInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
